# ################################################################
# UTCMS_rule.sql
# Creates rule table
# Special things:
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from: 
# refers  : type(rule_type)
#
# ################################################################
# Field descriptions
# ################################################################
# rule_type     Type that this rule belongs to
# rule_name     Name of this rule
# rule_rule     Instructions

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS rule;

# ################################################################
# Create the rule table and it's indexes
# ################################################################
CREATE TABLE rule (
    rule_type   INTEGER         NOT NULL    DEFAULT 0,
    rule_name   CHAR(32)        NOT NULL,
    rule_rule   CHAR(200)       NOT NULL,

    PRIMARY KEY ( rule_type, rule_name )
);

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON rule TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# Group #00: Files that can only be distinguished by suffix
# ################################################################
# Identification rules
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   1,      "ify00010",     "notexe + notumod + notunreal + suff .gif" ),
(   2,      "ify00030",     "notexe + notumod + notunreal + suff .jpg" ),
(   2,      "ify00040",     "notexe + notumod + notunreal + suff .jpeg" ),
(   3,      "ify00050",     "notexe + notumod + notunreal + suff .png" ),
(   4,      "ify00060",     "notexe + notumod + notunreal + suff .pcx" ),
(   5,      "ify00070",     "notexe + notumod + notunreal + suff .bmp" ),
(   6,      "ify00080",     "notexe + notumod + notunreal + suff .ico" ),
(   7,      "ify00090",     "notexe + notumod + notunreal + suff .wav" ),
(   8,      "ify00100",     "notexe + notumod + notunreal + suff .aif" ),
(   8,      "ify00110",     "notexe + notumod + notunreal + suff .aiff" ),
(   9,      "ify00120",     "notexe + notumod + notunreal + suff .s3m" ),
(   10,     "ify00130",     "notexe + notumod + notunreal + suff .it" ),
(   11,     "ify00140",     "notexe + notumod + notunreal + suff .xm" ),
(   12,     "ify00150",     "notexe + notumod + notunreal + suff .mp3" ),
(   12,     "ify00151",     "notexe + notumod + notunreal + suff .mp2" ),
(   13,     "ify00160",     "notexe + notumod + notunreal + suff .3ds" ),
(   13,     "ify00161",     "notexe + notumod + notunreal + suff .max" ),
(   14,     "ify00170",     "notexe + notumod + notunreal + suff .dxf" ),
(   15,     "ify00180",     "notexe + notumod + notunreal + suff .t3d" ),
(   19,     "ify00220",     "notexe + notumod + notunreal + suff .so" ),
(   101,    "ify00230",     "notexe + notumod + notunreal + suff .gz" ),
(   102,    "ify00240",     "notexe + notumod + notunreal + suff .tar" ),
(   103,    "ify00250",     "notexe + notumod + notunreal + suff .zip" ),
(   104,    "ify00260",     "notexe + umod + notunreal + suff .umod" ),
(   104,    "ify00261",     "notexe + umod + notunreal + suff .ut2mod" ),
(   201,    "ify00270",     "notexe + notumod + notunreal + suff .pdf" ),
(   202,    "ify00280",     "notexe + notumod + notunreal + suff .html" ),
(   202,    "ify00290",     "notexe + notumod + notunreal + suff .htm" ),
(   203,    "ify00300",     "notexe + notumod + notunreal + suff .txt" ),
(   203,    "ify00310",     "notexe + notumod + notunreal + suff .1st" ),
(   203,    "ify00320",     "notexe + notumod + notunreal + suff .readme" ),
(   203,    "ify00330",     "notexe + notumod + notunreal + file readme." ),
(   203,    "ify00331",     "notexe + notumod + notunreal + file readme" ),
(   204,    "ify00340",     "notexe + notumod + notunreal + suff .doc" ),
(   205,    "ify00350",     "notexe + notumod + notunreal + suff .uhtm" ),
(   206,    "ify00360",     "notexe + notumod + notunreal + suff .css" ),
(   301,    "ify00370",     "notexe + notumod + notunreal + suff .ini" ),
(   301,    "ify00371",     "notexe + notumod + notunreal + suff .tut" ),
(   401,    "ify00390",     "notexe + notumod + notunreal + suff .ucc" ),
(   401,    "ify00400",     "notexe + notumod + notunreal + suff .uc" ),
(   406,    "ify00410",     "notexe + notumod + notunreal + suff .ogg" ),
(   410,    "ify00420",     "notexe + notumod + notunreal + suff .int" ),
(   411,    "ify00420",     "notexe + notumod + notunreal + suff .det" ),
(   412,    "ify00421",     "notexe + notumod + notunreal + suff .est" ),
(   413,    "ify00422",     "notexe + notumod + notunreal + suff .itt" ),
(   414,    "ify00423",     "notexe + notumod + notunreal + suff .frt" ),
(   415,    "ify00424",     "notexe + notumod + notunreal + suff .upl" ),
(   416,    "ify00425",     "notexe + notumod + notunreal + suff .ka" ),
(   417,    "ify00426",     "notexe + notumod + notunreal + suff .ifr" ),
(   20,     "ify00427",     "notexe + notumod + notunreal + suff .upp" ),
(   21,     "ify00428",     "notexe + notumod + notunreal + suff .psk" ),
(   22,     "ify00429",     "notexe + notumod + notunreal + suff .psa" ),
(   23,     "ify00430",     "notexe + notumod + notunreal + suff .upt" ),
(   429,    "ify00431",     "notexe + notumod + notunreal + suff .3d" );

# ################################################################
# A Bunch of executable files allowed to enter da house
# ################################################################
# DLL
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   16,     "ify00500",     "isexe + file depthcursor.dll" ),
(   16,     "ify00501",     "isexe + file thescsoundsource.dll" ),
(   16,     "ify00502",     "isexe + file thieveryai.dll" ),
(   16,     "ify00503",     "isexe + file thieverylowlevel.dll" ),
(   16,     "ify00504",     "isexe + file thieverymod.dll" );

# ################################################################
# EXE
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   17,     "ify00600",     "isexe + file thaux.exe" ),
(   17,     "ify00601",     "isexe + file thievery.exe" );

# ################################################################
# BAT
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   18,     "ify00700",     "notexe + file thieveryserver.bat" );

# ################################################################
# Primary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   1,      "primary",      "IMG" ),
(   2,      "primary",      "IMG" ),
(   3,      "primary",      "IMG" ),
(   4,      "primary",      "IMG" ),
(   5,      "primary",      "IMG" ),
(   6,      "primary",      "IMG" ),
(   7,      "primary",      "SND" ),
(   8,      "primary",      "SND" ),
(   9,      "primary",      "MUS" ),
(   10,     "primary",      "MUS" ),
(   11,     "primary",      "MUS" ),
(   12,     "primary",      "SND" ),
(   13,     "primary",      "3DF" ),
(   14,     "primary",      "3DF" ),
(   15,     "primary",      "UNR" ),
(   16,     "primary",      "WIN" ),
(   17,     "primary",      "WIN" ),
(   18,     "primary",      "WIN" ),
(   19,     "primary",      "LNX" ),
(   101,    "primary",      "PKG" ),
(   102,    "primary",      "PKG" ),
(   103,    "primary",      "PKG" ),
(   104,    "primary",      "PKG" ),
(   201,    "primary",      "DOC" ),
(   202,    "primary",      "DOC" ),
(   203,    "primary",      "DOC" ),
(   204,    "primary",      "DOC" ),
(   205,    "primary",      "DOC" ),
(   206,    "primary",      "DOC" ),
(   301,    "primary",      "UNR" ),
(   401,    "primary",      "UNR" ),
(   406,    "primary",      "UNR" ),
(   410,    "primary",      "UNR" ),
(   411,    "primary",      "UNR" ),
(   412,    "primary",      "UNR" ),
(   413,    "primary",      "UNR" ),
(   414,    "primary",      "UNR" ),
(   415,    "primary",      "UNR" ),
(   416,    "primary",      "UNR" ),
(   417,    "primary",      "UNR" ),
(   20,     "primary",      "3DF" ),
(   21,     "primary",      "3DF" ),
(   22,     "primary",      "3DF" ),
(   23,     "primary",      "3DF" ),
(   429,    "primary",      "UNR" );

# Secondary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   1,      "secondary",    "GIF" ),
(   2,      "secondary",    "JPG" ),
(   3,      "secondary",    "PNG" ),
(   4,      "secondary",    "PCX" ),
(   5,      "secondary",    "BMP" ),
(   6,      "secondary",    "ICO" ),
(   7,      "secondary",    "WAV" ),
(   8,      "secondary",    "AIF" ),
(   9,      "secondary",    "S3M" ),
(   10,     "secondary",    "IT" ),
(   11,     "secondary",    "XM" ),
(   12,     "secondary",    "MP3" ),
(   13,     "secondary",    "3DS-MAX" ),
(   14,     "secondary",    "DXF" ),
(   15,     "secondary",    "T3D" ),
(   16,     "secondary",    "DLL" ),
(   17,     "secondary",    "EXE" ),
(   18,     "secondary",    "BAT" ),
(   19,     "secondary",    "SO" ),
(   101,    "secondary",    "GZ" ),
(   102,    "secondary",    "TAR" ),
(   103,    "secondary",    "ZIP" ),
(   104,    "secondary",    "UMOD" ),
(   201,    "secondary",    "PDF" ),
(   202,    "secondary",    "HTM" ),
(   203,    "secondary",    "TXT" ),
(   204,    "secondary",    "DOC" ),
(   205,    "secondary",    "UHT" ),
(   206,    "secondary",    "CSS" ),
(   301,    "secondary",    "INI" ),
(   401,    "secondary",    "UCC" ),
(   406,    "secondary",    "OGG" ),
(   410,    "secondary",    "TXT-INT" ),
(   411,    "secondary",    "TXT-DE" ),
(   412,    "secondary",    "TXT-ES" ),
(   413,    "secondary",    "TXT-IT" ),
(   414,    "secondary",    "TXT-FR" ),
(   415,    "secondary",    "UPL" ),
(   416,    "secondary",    "KARMA" ),
(   417,    "secondary",    "IFR" ),
(    20,    "secondary",    "UPT-UPP" ),
(    21,    "secondary",    "UPT-PSK" ),
(    22,    "secondary",    "UPT-PSA" ),
(    23,    "secondary",    "UPT-DATA" ),
(   429,    "secondary",    "3DMODEL" );

# Preview method (obsolete)
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   1,      "preview",      "image/" ),
(   2,      "preview",      "image/" ),
(   3,      "preview",      "image/" ),
(   4,      "preview",      "image/" ),
(   5,      "preview",      "image/" ),
(   6,      "preview",      "filedetails/" ),
(   7,      "preview",      "filedetails/" ),
(   8,      "preview",      "filedetails/" ),
(   9,      "preview",      "filedetails/" ),
(   10,     "preview",      "filedetails/" ),
(   11,     "preview",      "filedetails/" ),
(   12,     "preview",      "filedetails/" ),
(   13,     "preview",      "filedetails/" ),
(   14,     "preview",      "filedetails/" ),
(   15,     "preview",      "t3d/" ),
(   16,     "preview",      "filedetails/" ),
(   17,     "preview",      "filedetails/" ),
(   18,     "preview",      "filedetails/" ),
(   19,     "preview",      "filedetails/" ),
(   101,    "preview",      "filedetails/" ),
(   102,    "preview",      "filedetails/" ),
(   103,    "preview",      "filedetails/" ),
(   104,    "preview",      "filedetails/" ),
(   201,    "preview",      "filedetails/" ),
(   202,    "preview",      "text/" ),
(   203,    "preview",      "text/" ),
(   204,    "preview",      "filedetails/" ),
(   205,    "preview",      "filedetails/" ),
(   206,    "preview",      "filedetails/" ),
(   301,    "preview",      "text/" ),
(   401,    "preview",      "text/" ),
(   406,    "preview",      "filedetails/" ),
(   410,    "preview",      "text/" ),
(   411,    "preview",      "text/" ),
(   412,    "preview",      "text/" ),
(   413,    "preview",      "text/" ),
(   414,    "preview",      "text/" ),
(   415,    "preview",      "skin/" ),
(   416,    "preview",      "filedetails/" ),
(   417,    "preview",      "filedetails/" ),
(    20,    "preview",      "filedetails/" ),
(    21,    "preview",      "filedetails/" ),
(    22,    "preview",      "filedetails/" ),
(    23,    "preview",      "filedetails/" ),
(   429,    "preview",      "filedetails/" );

# Preview methods
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   1,      "pvmeth",       "i" ),
(   2,      "pvmeth",       "i" ),
(   3,      "pvmeth",       "i" ),
(   4,      "pvmeth",       "i" ),
(   5,      "pvmeth",       "i" ),
(   7,      "pvmeth",       "d" ),
(   8,      "pvmeth",       "d" ),
(   9,      "pvmeth",       "d" ),
(   10,     "pvmeth",       "d" ),
(   11,     "pvmeth",       "d" ),
(   12,     "pvmeth",       "d" ),
(   15,     "pvmeth",       "r" ),
(   201,    "pvmeth",       "d" ),
(   202,    "pvmeth",       "d" ),
(   203,    "pvmeth",       "t" ),
(   205,    "pvmeth",       "d" ),
(   301,    "pvmeth",       "t" ),
(   401,    "pvmeth",       "t" ),
(   410,    "pvmeth",       "t" ),
(   411,    "pvmeth",       "t" ),
(   412,    "pvmeth",       "t" ),
(   413,    "pvmeth",       "t" ),
(   414,    "pvmeth",       "t" ),
(   415,    "pvmeth",       "ts" ),
(   416,    "pvmeth",       "t" );

# Installation directory - used during package reconstruction
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   1,      "installdir",   "Help/images" ),
(   2,      "installdir",   "Help/images" ),
(   3,      "installdir",   "Help/images" ),
(   4,      "installdir",   "Help/images" ),
(   5,      "installdir",   "Help/images" ),
(   6,      "installdir",   "Help/images" ),
(   7,      "installdir",   "Sounds" ),
(   8,      "installdir",   "Sounds" ),
(   9,      "installdir",   "Music" ),
(   10,     "installdir",   "Music" ),
(   11,     "installdir",   "Music" ),
(   12,     "installdir",   "Sounds" ),
(   13,     "installdir",   "$(filename)/Models" ),
(   14,     "installdir",   "$(filename)/Models" ),
(   15,     "installdir",   "$(filename)/Models" ),
(   16,     "installdir",   "System" ),
(   17,     "installdir",   "System" ),
(   18,     "installdir",   "System" ),
(   19,     "installdir",   "System" ),
(   101,    "installdir",   "Unknown" ),
(   102,    "installdir",   "Unknown" ),
(   103,    "installdir",   "Unknown" ),
(   104,    "installdir",   "Unknown" ),
(   201,    "installdir",   "Help" ),
(   202,    "installdir",   "Help" ),
(   203,    "installdir",   "Help" ),
(   204,    "installdir",   "Help" ),
(   205,    "installdir",   "Web" ),
(   206,    "installdir",   "Help" ),
(   301,    "installdir",   "System" ),
(   401,    "installdir",   "$(filename)/Classes" ),
(   406,    "installdir",   "Music" ),
(   410,    "installdir",   "System" ),
(   411,    "installdir",   "System" ),
(   412,    "installdir",   "System" ),
(   413,    "installdir",   "System" ),
(   414,    "installdir",   "System" ),
(   415,    "installdir",   "System" ),
(   416,    "installdir",   "KarmaData" ),
(   417,    "installdir",   "ForceFeedback" ),
(    20,    "installdir",   "UPaint/Characters" ),
(    21,    "installdir",   "UPaint/Meshes" ),
(    22,    "installdir",   "UPaint/TauntAnims" ),
(    23,    "installdir",   "UPaint" ),
(   429,    "installdir",   "$(filename)/Models" );


# Unpack methods - used for disposing WIN files as well
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   19,     "unpacking",    "disp" ),
(   101,    "unpacking",    "gzip" ),
(   102,    "unpacking",    "tar" ),
(   103,    "unpacking",    "zip" ),
(   104,    "unpacking",    "umod" );

# ################################################################
# Group #01: Packages that are NOT unreal - disposed
# ################################################################
# Identification rules
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   99998,  "ify01001",     "notumod + notunreal + suff .u" ),
(   99998,  "ify01002",     "notumod + notunreal + suff .utx" ),
(   99998,  "ify01003",     "notumod + notunreal + suff .umx" ),
(   99998,  "ify01004",     "notumod + notunreal + suff .uax" ),
(   99998,  "ify01005",     "notumod + notunreal + suff .unr" ),
(   99998,  "ify01006",     "notumod + notunreal + suff .aao" ),
(   99998,  "ify01007",     "notumod + notunreal + suff .usx" ),
(   99998,  "ify01008",     "notumod + notunreal + suff .ut2" ),
(   99999,  "ify01998",     "notunreal" ),
(   99999,  "ify01999",     "isexe" );

# Primary type - for corrupt UNR files
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   99998,  "primary",      "UNR" ),
(   99999,  "primary",      "XXX" );

# Secondary type - for corrupt UNR files
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   99998,  "secondary",    "UNR-ERROR" ),
(   99999,  "secondary",    "XXX-ERROR" );

# Preview method (obsolete)
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   99998,  "preview",      "filedetails/" ),
(   99999,  "preview",      "filedetails/" );

# Installation directory - none for these
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   99998,  "installdir",   "Maps" ),
(   99999,  "installdir",   "Unknown" );

# Unpack methods - disposing - not the corrupt UNR files though
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   99999,  "unpacking",    "disp" );

# ################################################################
# Group #015:   Mutators
# ################################################################
# Identification rules
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(     418,  "ify01500",     "isut2k3 + file engine.u" ),
(     418,  "ify01510",     "isut2k3 + file unrealgame.u" ),
(     418,  "ify01520",     "isut2k3 + file xgame.u" ),
(     450,  "ify01610",     "isu1 + suff .u + function MutatorTakeDamage" ),
(     451,  "ify01620",     "isut + suff .u + function MutatorTakeDamage" ),
(     452,  "ify01700",     "isut2k3 + suff .u + function StartEffect" ),
(     452,  "ify01710",     "isut2k3 + suff .u + function StopEffect" ),
(     452,  "ify01720",     "isut2k3 + suff .u + function ModifyPlayer" );

# Primary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(     450,  "primary",      "UNR" ),
(     451,  "primary",      "UNR" ),
(     452,  "primary",      "UNR" );

# Secondary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   450,    "secondary",    "U1-U-MUT" ),
(   451,    "secondary",    "UT-U-MUT" ),
(   452,    "secondary",    "UT2k3-U-MUT" );

# Preview method (obsolete)
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   450,    "preview",      "unrdetails/" ),
(   451,    "preview",      "unrdetails/" ),
(   452,    "preview",      "unrdetails/" );

# Preview methods
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   450,    "pvmeth",       "u" ),
(   451,    "pvmeth",       "u" ),
(   452,    "pvmeth",       "u" );

# Installation directory - used during package reconstruction
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   450,    "installdir",   "System" ),
(   451,    "installdir",   "System" ),
(   452,    "installdir",   "System" );

# ################################################################
# Group #02: Files that are common to all unreal gametypes
#            Distinguished by the suffix only !!!
# ################################################################
# Identification rules
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   418,    "ify02001",     "isut2k3 + suff .u" ),
(   423,    "ify02002",     "isaao + suff .u" ),
(   402,    "ify02003",     "suff .u" ),
(   419,    "ify02004",     "isut2k3 + suff .utx" ),
(   424,    "ify02005",     "isaao + suff .utx" ),
(   403,    "ify02006",     "isut + suff .utx" ),
(   430,    "ify02007",     "suff .utx" ),
(   420,    "ify02008",     "isut2k3 + suff .uax" ),
(   425,    "ify02009",     "isaao + suff .uax" ),
(   404,    "ify02010",     "suff .uax" ),
(   421,    "ify02011",     "isut2k3 + suff .umx" ),
(   426,    "ify02012",     "isaao + suff .umx" ),
(   405,    "ify02013",     "suff .umx" ),
(   422,    "ify02014",     "isut2k3 + suff .u3d" ),
(   427,    "ify02015",     "isaao + suff .u3d" ),
(   407,    "ify02016",     "suff .u3d" ),
(   408,    "ify02017",     "isut2k3 + suff .usx" ),
(   428,    "ify02018",     "isaao + suff .usx" ),
(   409,    "ify02019",     "isut2k3 + suff .ukx" ),
(   625,    "ify02020",     "isaao + suff .aao" ),
(   903,    "ify02021",     "isu1 + notsuff .unr" ),
(   910,    "ify02022",     "isut + notsuff .unr" ),
(   911,    "ify02023",     "isaao + notsuff .aao" ),
(   918,    "ify02024",     "isut2k3 + notsuff .ut2 + notsuff .unr" );


# Primary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   418,    "primary",      "UNR" ),
(   423,    "primary",      "UNR" ),
(   402,    "primary",      "UNR" ),
(   419,    "primary",      "UNR" ),
(   424,    "primary",      "UNR" ),
(   403,    "primary",      "UNR" ),
(   430,    "primary",      "UNR" ),
(   420,    "primary",      "UNR" ),
(   425,    "primary",      "UNR" ),
(   404,    "primary",      "UNR" ),
(   421,    "primary",      "UNR" ),
(   426,    "primary",      "UNR" ),
(   405,    "primary",      "UNR" ),
(   422,    "primary",      "UNR" ),
(   427,    "primary",      "UNR" ),
(   407,    "primary",      "UNR" ),
(   408,    "primary",      "UNR" ),
(   428,    "primary",      "UNR" ),
(   409,    "primary",      "UNR" ),
(   625,    "primary",      "UNR" ),
(   903,    "primary",      "UNR" ),
(   910,    "primary",      "UNR" ),
(   911,    "primary",      "UNR" ),
(   918,    "primary",      "UNR" );
    
# Secondary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   418,    "secondary",    "UT2K3-U" ),
(   423,    "secondary",    "AAO-U" ),
(   402,    "secondary",    "UT-U" ),
(   419,    "secondary",    "UT2K3-UTX" ),
(   424,    "secondary",    "AAO-UTX" ),
(   403,    "secondary",    "UT-UTX" ),
(   430,    "secondary",    "U1-UTX" ),
(   420,    "secondary",    "UT2K3-UAX" ),
(   425,    "secondary",    "AAO-UAX" ),
(   404,    "secondary",    "UT-UAX" ),
(   421,    "secondary",    "UT2K3-UMX" ),
(   426,    "secondary",    "AAO-UMX" ),
(   405,    "secondary",    "UT-UMX" ),
(   422,    "secondary",    "UT2K3-U3D" ),
(   427,    "secondary",    "AAO-U3D" ),
(   407,    "secondary",    "UT-U3D" ),
(   408,    "secondary",    "UT2K3-USX" ),
(   428,    "secondary",    "AAO-USX" ),
(   409,    "secondary",    "UT2K3-UKX" ),
(   625,    "secondary",    "AAO-LEVEL" ),
(   903,    "secondary",    "U1-UNKNOWN" ),
(   910,    "secondary",    "UT-UNKNOWN" ),
(   911,    "secondary",    "AAO-UNKNOWN" ),
(   918,    "secondary",    "UT2K3-UNKNOWN" );

# Preview method (obsolete)
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   418,    "preview",      "unrdetails/" ),
(   423,    "preview",      "unrdetails/" ),
(   402,    "preview",      "unrdetails/" ),
(   419,    "preview",      "texture/" ),
(   424,    "preview",      "texture/" ),
(   403,    "preview",      "texture/" ),
(   430,    "preview",      "texture/" ),
(   420,    "preview",      "sound/" ),
(   425,    "preview",      "sound/" ),
(   404,    "preview",      "sound/" ),
(   421,    "preview",      "unrdetails/" ),
(   426,    "preview",      "unrdetails/" ),
(   405,    "preview",      "unrdetails/" ),
(   422,    "preview",      "unrdetails/" ),
(   427,    "preview",      "unrdetails/" ),
(   407,    "preview",      "unrdetails/" ),
(   408,    "preview",      "unrdetails/" ),
(   428,    "preview",      "unrdetails/" ),
(   409,    "preview",      "unrdetails/" ),
(   625,    "preview",      "unrdetails/" ),
(   903,    "preview",      "unrdetails/" ),
(   910,    "preview",      "unrdetails/" ),
(   911,    "preview",      "unrdetails/" ),
(   918,    "preview",      "unrdetails/" );

# Preview methods
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   418,    "pvmeth",       "u" ),
(   423,    "pvmeth",       "u" ),
(   402,    "pvmeth",       "u" ),
(   419,    "pvmeth",       "ux" ),
(   424,    "pvmeth",       "ux" ),
(   403,    "pvmeth",       "ux" ),
(   430,    "pvmeth",       "ux" ),
(   420,    "pvmeth",       "u" ),
(   425,    "pvmeth",       "u" ),
(   404,    "pvmeth",       "u" ),
(   421,    "pvmeth",       "u" ),
(   426,    "pvmeth",       "u" ),
(   405,    "pvmeth",       "u" ),
(   422,    "pvmeth",       "u" ),
(   427,    "pvmeth",       "u" ),
(   407,    "pvmeth",       "u" ),
(   408,    "pvmeth",       "u" ),
(   428,    "pvmeth",       "u" ),
(   409,    "pvmeth",       "u" ),
(   625,    "pvmeth",       "u" ),
(   903,    "pvmeth",       "u" ),
(   910,    "pvmeth",       "u" ),
(   911,    "pvmeth",       "u" ),
(   918,    "pvmeth",       "u" );

# Installation directory - used during package reconstruction
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   418,    "installdir",   "System" ),
(   423,    "installdir",   "System" ),
(   402,    "installdir",   "System" ),
(   419,    "installdir",   "Textures" ),
(   424,    "installdir",   "Textures" ),
(   403,    "installdir",   "Textures" ),
(   430,    "installdir",   "Textures" ),
(   420,    "installdir",   "Sounds" ),
(   425,    "installdir",   "Sounds" ),
(   404,    "installdir",   "Sounds" ),
(   421,    "installdir",   "Music" ),
(   426,    "installdir",   "Music" ),
(   405,    "installdir",   "Music" ),
(   422,    "installdir",   "$(filename)/Models" ),
(   427,    "installdir",   "$(filename)/Models" ),
(   407,    "installdir",   "$(filename)/Models" ),
(   408,    "installdir",   "StaticMeshes" ),
(   428,    "installdir",   "StaticMeshes" ),
(   409,    "installdir",   "Animations" ),
(   625,    "installdir",   "Maps" ),
(   903,    "installdir",   "Trash" ),
(   910,    "installdir",   "Trash" ),
(   911,    "installdir",   "Trash" ),
(   918,    "installdir",   "Trash" );

# Unpack methods - none for this group

# ################################################################
# Group #029: UT maps that have commonly known problems in them
# ################################################################
# Identification rules
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   904,    "ify02902",     "isut + suff .unr + pref as- + actor UT_invisibility > 0 + actor UT_Stealth > 0" ),
(   905,    "ify02912",     "isut + suff .unr + pref dom- + actor UT_invisibility > 0 + actor UT_Stealth > 0" ),
(   906,    "ify02922",     "isut + suff .unr + pref ctf- + actor UT_invisibility > 0 + actor UT_Stealth > 0" ),
(   907,    "ify02932",     "isut + suff .unr + pref dm + actor UT_invisibility > 0 + actor UT_Stealth > 0" );

# ################################################################
# Group #03: Unreal/UT modifications that are always needing
#            some package or always contain some known actor
#            and therefore are easy to distinguish
# ################################################################
# Identification rules
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   614,    "ify03010",     "isut + suff .unr + actor LevelInfo >= 1 + actor ONPLevelInfo >= 1" ),
(   614,    "ify03011",     "isut + suff .unr + pref NP + actor LevelInfo >= 1 + needs np2,NPTalk" ),
(   601,    "ify03020",     "isut + suff .unr + actor LevelInfo >= 1 + actor MCTFFlagBase >= 1" ),
(   601,    "ify03030",     "isut + suff .unr + actor LevelInfo >= 1 + needs MultiCTF,MultiCTFTex" ),
(   603,    "ify03040",     "isut + suff .unr + actor LevelInfo >= 1 + needs jailbreak,jbarena" ),
(   619,    "ify03050",     "isut + suff .unr + actor LevelInfo >= 1 + needs RocketArena" ),
(   604,    "ify03060",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + pref as  + needs rw_Tpack0,rw_Install,INF_Core,INF_Decorations,INF_Mapping,INF_Assets,INF_Assets2,INF_Lite,RealWorld" ),
(   605,    "ify03070",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + pref ctf + needs rw_Tpack0,rw_Install,INF_Core,INF_Decorations,INF_Mapping,INF_Assets,INF_Assets2,INF_Lite,RealWorld" ),
(   606,    "ify03080",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 1 + pref dm  + needs rw_Tpack0,rw_Install,INF_Core,INF_Decorations,INF_Mapping,INF_Assets,INF_Assets2,INF_Lite,RealWorld" ),
(   607,    "ify03090",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + pref dom + needs rw_Tpack0,rw_Install,INF_Core,INF_Decorations,INF_Mapping,INF_Assets,INF_Assets2,INF_Lite,RealWorld" ),
(   631,    "ify03091",     "isut + suff .unr + actor LevelInfo >= 1 + actor DTFFlagBase >= 2 + pref dtf-" ),
(   632,    "ify03092",     "isut + suff .unr + actor LevelInfo >= 1 + pref fb- + needs FragBall" ),
(   608,    "ify03100",     "isut + suff .unr + actor LevelInfo >= 1 + needs INF_Core,INF_Decorations,INF_Mapping,INF_Assets,INF_Assets2,INF_Lite,RealWorld" ),
(   618,    "ify03110",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 1 + actor FlagDomReceptacle >= 1 + actor FlagDomBase >= 2 + needs FlagDom" ),
(   621,    "ify03120",     "isut + suff .unr + actor LevelInfo >= 1 + actor SHTeamBaseCenter >= 1 + needs scavhunt" ),
(   616,    "ify03130",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 4 + needs ctfplus" ),
(   620,    "ify03140",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + pref sftdm- + needs sf,sfdeco,sfgame" ),
(   620,    "ify03141",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + pref sf- + needs sf,sfdeco,sfgame" ),
(   649,    "ify03142",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + pref sfdm- + needs sf,sfgame" ),
(   650,    "ify03143",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + pref sfes- + needs sf,sfgame" ),
(   651,    "ify03144",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + pref sfhr- + needs sf,sfgame" ),
(   652,    "ify03145",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + notpref sw- + needs sf,sfgame" ),
(   617,    "ify03150",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 4 + pref ctf4- + actor FlagBase == 4" ),
(   617,    "ify03151",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 4 + actor FlagBase4 == 4" ),
(   602,    "ify03160",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + pref sd- + needs Smashdroid,SmashDroidMaps" ),
(   615,    "ify03170",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + pref cnq-" ),
(   628,    "ify03180",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + needs DefenceAlliance" ),
(   630,    "ify03190",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + needs MarathonMod,MInf" ),
(   633,    "ify03200",     "isut + suff .unr + pref koth + actor LevelInfo >= 1 + actor PlayerStart >= 2 + needs utchaosmap,ChaosUT,ChaosGames" ),
(   636,    "ify03201",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + needs utchaosmap,ChaosUT,ChaosGames" ),
(   634,    "ify03202",     "isut + suff .unr + actor LevelInfo >= 1 + actor RacePlayerStartSpot > 0 + needs RaceGame" ),
(   635,    "ify03203",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart > 0 + needs koth2" ),
(   637,    "ify03204",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart > 0 + needs hammertime" ),
(   638,    "ify03205",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart > 0 + needs UnrealFortress" ),
(   639,    "ify03205",     "isut + suff .unr + pref uspace + actor LevelInfo >= 1 + actor PlayerStart > 0 + needs USpace" ),
(   629,    "ify03206",     "isut + suff .unr + actor LevelInfo >= 1 + needs AirFightUT" ),
(   640,    "ify03207",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart > 0 + needs JWF_BotAttract,JungleWarfare" ),
(   641,    "ify03208",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart > 0 + needs ThieveryAI,ThieveryMod,ThMenu,ThieveryTitle" ),
(   642,    "ify03209",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart > 0 + needs WSWestern_pack1,Badlands,WesternProps" ),
(   643,    "ify03210",     "isut + suff .unr + actor LevelInfo >= 1 + actor GodzLevelInfo >= 1 + actor PlayerStart > 0 + needs Godz" ),
(   643,    "ify03211",     "isut + suff .unr + actor LevelInfo >= 1 + actor DTPSpawnpoint > 0 + actor PlayerStart > 0 + needs Godz" ),
(   644,    "ify03212",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart > 0 + needs TeamOrbit,TeamOrbitMedia" ),
(   508,    "ify03213",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart > 0 + needs XidiaX2Deco,XidiaDecos01,xidiampack" ),
(   508,    "ify03214",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart > 0 + actor xidialevelinfo > 0" ),
(   645,    "ify03215",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart > 0 + needs NaliRange" ),
(   646,    "ify03216",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart > 0 + actor UB_Levelinfo > 0 + needs UB1" ),
(   647,    "ify03217",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart > 0 + needs U4e2000,U4eFM,U4eFortress,U4eT,U4eJailbreak,U4eN2,U4eTC,U4eTM" ),
(   648,    "ify03218",     "isut + suff .unr + actor LevelInfo >= 1 + actor NEPlayerStart > 0 + needs NightsEdge" ),
(   653,    "ify03219",     "isut + suff .unr + actor TTR_LevelInfo >= 1 + needs TTR" ),
(   654,    "ify03220",     "isut + suff .unr + actor LevelInfo >= 1 + needs Marines" ),
(   509,    "ify03221",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart > 0 + needs SpatialFear" );


# Primary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   614,    "primary",      "UNR" ),
(   601,    "primary",      "UNR" ),
(   603,    "primary",      "UNR" ),
(   604,    "primary",      "UNR" ),
(   605,    "primary",      "UNR" ),
(   606,    "primary",      "UNR" ),
(   607,    "primary",      "UNR" ),
(   608,    "primary",      "UNR" ),
(   618,    "primary",      "UNR" ),
(   619,    "primary",      "UNR" ),
(   621,    "primary",      "UNR" ),
(   616,    "primary",      "UNR" ),
(   620,    "primary",      "UNR" ),
(   617,    "primary",      "UNR" ),
(   602,    "primary",      "UNR" ),
(   615,    "primary",      "UNR" ),
(   628,    "primary",      "UNR" ),
(   630,    "primary",      "UNR" ),
(   631,    "primary",      "UNR" ),
(   632,    "primary",      "UNR" ),
(   633,    "primary",      "UNR" ),
(   634,    "primary",      "UNR" ),
(   635,    "primary",      "UNR" ),
(   636,    "primary",      "UNR" ),
(   637,    "primary",      "UNR" ),
(   638,    "primary",      "UNR" ),
(   639,    "primary",      "UNR" ),
(   629,    "primary",      "UNR" ),
(   640,    "primary",      "UNR" ),
(   641,    "primary",      "UNR" ),
(   642,    "primary",      "UNR" ),
(   643,    "primary",      "UNR" ),
(   644,    "primary",      "UNR" ),
(   508,    "primary",      "UNR" ),
(   645,    "primary",      "UNR" ),
(   646,    "primary",      "UNR" ),
(   647,    "primary",      "UNR" ),
(   648,    "primary",      "UNR" ),
(   649,    "primary",      "UNR" ),
(   650,    "primary",      "UNR" ),
(   651,    "primary",      "UNR" ),
(   652,    "primary",      "UNR" ),
(   653,    "primary",      "UNR" ),
(   654,    "primary",      "UNR" ),
(   509,    "primary",      "UNR" );

# Secondary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   614,    "secondary",    "UT-ONP" ),
(   601,    "secondary",    "UT-CTFM" ),
(   603,    "secondary",    "UT-JB" ),
(   604,    "secondary",    "UT-AS-INF" ),
(   605,    "secondary",    "UT-CTF-INF" ),
(   606,    "secondary",    "UT-DM-INF" ),
(   607,    "secondary",    "UT-DOM-INF" ),
(   608,    "secondary",    "UT-INF" ),
(   618,    "secondary",    "UT-FD" ),
(   619,    "secondary",    "UT-RA" ),
(   621,    "secondary",    "UT-SH" ),
(   616,    "secondary",    "UT-CTF4+" ),
(   620,    "secondary",    "UT-SFORTDM" ),
(   617,    "secondary",    "UT-CTF4" ),
(   602,    "secondary",    "UT-SD" ),
(   615,    "secondary",    "UT-CNQ" ),
(   628,    "secondary",    "UT-DA" ),
(   630,    "secondary",    "UT-Marathon" ),
(   631,    "secondary",    "UT-DTF" ),
(   632,    "secondary",    "UT-FBall" ),
(   633,    "secondary",    "UT-CUTKOTH" ),
(   634,    "secondary",    "UT-RACE" ),
(   635,    "secondary",    "UT-KOTH" ),
(   636,    "secondary",    "UT-CHAOS" ),
(   637,    "secondary",    "UT-HTIME" ),
(   638,    "secondary",    "UT-UFORT" ),
(   639,    "secondary",    "UT-USPACE" ),
(   629,    "secondary",    "UT-AIRFGHT" ),
(   640,    "secondary",    "UT-JWF" ),
(   641,    "secondary",    "UT-THIEV" ),
(   642,    "secondary",    "UT-BADLA" ),
(   643,    "secondary",    "UT-GODZ" ),
(   644,    "secondary",    "UT-NEOCAIRO" ),
(   508,    "secondary",    "UT-SP-XID" ),
(   645,    "secondary",    "UT-NALIRA" ),
(   646,    "secondary",    "UT-UNABOMB" ),
(   647,    "secondary",    "UT-UNABOMB" ),
(   648,    "secondary",    "UT-NIGEDG" ),
(   649,    "secondary",    "UT-SFDM" ),
(   650,    "secondary",    "UT-SFORES" ),
(   651,    "secondary",    "UT-SFORHR" ),
(   652,    "secondary",    "UT-SFORUNK" ),
(   653,    "secondary",    "UT-TTR" ),
(   654,    "secondary",    "UT-MARINS" ),
(   509,    "secondary",    "UT-SPATFE" );

# Preview method (obsolete)
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   614,    "preview",      "screenshots/" ),
(   601,    "preview",      "screenshots/" ),
(   603,    "preview",      "screenshots/" ),
(   604,    "preview",      "screenshots/" ),
(   605,    "preview",      "screenshots/" ),
(   606,    "preview",      "screenshots/" ),
(   607,    "preview",      "screenshots/" ),
(   608,    "preview",      "screenshots/" ),
(   618,    "preview",      "screenshots/" ),
(   619,    "preview",      "screenshots/" ),
(   621,    "preview",      "screenshots/" ),
(   616,    "preview",      "screenshots/" ),
(   620,    "preview",      "screenshots/" ),
(   617,    "preview",      "screenshots/" ),
(   602,    "preview",      "screenshots/" ),
(   615,    "preview",      "screenshots/" ),
(   628,    "preview",      "screenshots/" ),
(   630,    "preview",      "screenshots/" ),
(   631,    "preview",      "screenshots/" ),
(   632,    "preview",      "screenshots/" ),
(   633,    "preview",      "screenshots/" ),
(   634,    "preview",      "screenshots/" ),
(   635,    "preview",      "screenshots/" ),
(   636,    "preview",      "screenshots/" ),
(   637,    "preview",      "screenshots/" ),
(   638,    "preview",      "screenshots/" ),
(   639,    "preview",      "screenshots/" ),
(   629,    "preview",      "screenshots/" ),
(   640,    "preview",      "screenshots/" ),
(   641,    "preview",      "screenshots/" ),
(   642,    "preview",      "screenshots/" ),
(   643,    "preview",      "screenshots/" ),
(   644,    "preview",      "screenshots/" ),
(   508,    "preview",      "screenshots/" ),
(   645,    "preview",      "screenshots/" ),
(   646,    "preview",      "screenshots/" ),
(   647,    "preview",      "screenshots/" ),
(   648,    "preview",      "screenshots/" ),
(   649,    "preview",      "screenshots/" ),
(   650,    "preview",      "screenshots/" ),
(   651,    "preview",      "screenshots/" ),
(   652,    "preview",      "screenshots/" ),
(   653,    "preview",      "screenshots/" ),
(   654,    "preview",      "screenshots/" ),
(   509,    "preview",      "screenshots/" );

# Preview method
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   614,    "pvmeth",       "ul" ),
(   601,    "pvmeth",       "ul" ),
(   603,    "pvmeth",       "ul" ),
(   604,    "pvmeth",       "ula" ),
(   605,    "pvmeth",       "ul" ),
(   606,    "pvmeth",       "ul" ),
(   607,    "pvmeth",       "ul" ),
(   608,    "pvmeth",       "ul" ),
(   618,    "pvmeth",       "ul" ),
(   619,    "pvmeth",       "ul" ),
(   621,    "pvmeth",       "ul" ),
(   616,    "pvmeth",       "ul" ),
(   620,    "pvmeth",       "ul" ),
(   617,    "pvmeth",       "ul" ),
(   602,    "pvmeth",       "ul" ),
(   615,    "pvmeth",       "ul" ),
(   628,    "pvmeth",       "ul" ),
(   630,    "pvmeth",       "ul" ),
(   631,    "pvmeth",       "ul" ),
(   632,    "pvmeth",       "ul" ),
(   633,    "pvmeth",       "ul" ),
(   634,    "pvmeth",       "ul" ),
(   635,    "pvmeth",       "ul" ),
(   636,    "pvmeth",       "ul" ),
(   637,    "pvmeth",       "ul" ),
(   638,    "pvmeth",       "ul" ),
(   639,    "pvmeth",       "ul" ),
(   629,    "pvmeth",       "ul" ),
(   640,    "pvmeth",       "ul" ),
(   641,    "pvmeth",       "ul" ),
(   642,    "pvmeth",       "ul" ),
(   643,    "pvmeth",       "ul" ),
(   644,    "pvmeth",       "ul" ),
(   508,    "pvmeth",       "ul" ),
(   645,    "pvmeth",       "ul" ),
(   646,    "pvmeth",       "ul" ),
(   647,    "pvmeth",       "ul" ),
(   648,    "pvmeth",       "ul" ),
(   649,    "pvmeth",       "ul" ),
(   650,    "pvmeth",       "ul" ),
(   651,    "pvmeth",       "ul" ),
(   652,    "pvmeth",       "ul" ),
(   653,    "pvmeth",       "ul" ),
(   654,    "pvmeth",       "ul" ),
(   509,    "pvmeth",       "ul" );

# Installation directory - used during package reconstruction
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   614,    "installdir",   "Maps" ),
(   601,    "installdir",   "Maps" ),
(   603,    "installdir",   "Maps" ),
(   604,    "installdir",   "Maps" ),
(   605,    "installdir",   "Maps" ),
(   606,    "installdir",   "Maps" ),
(   607,    "installdir",   "Maps" ),
(   608,    "installdir",   "Maps" ),
(   618,    "installdir",   "Maps" ),
(   619,    "installdir",   "Maps" ),
(   621,    "installdir",   "Maps" ),
(   616,    "installdir",   "Maps" ),
(   620,    "installdir",   "Maps" ),
(   617,    "installdir",   "Maps" ),
(   602,    "installdir",   "Maps" ),
(   628,    "installdir",   "Maps" ),
(   630,    "installdir",   "Maps" ),
(   631,    "installdir",   "Maps" ),
(   632,    "installdir",   "Maps" ),
(   633,    "installdir",   "Maps" ),
(   634,    "installdir",   "Maps" ),
(   635,    "installdir",   "Maps" ),
(   636,    "installdir",   "Maps" ),
(   637,    "installdir",   "Maps" ),
(   638,    "installdir",   "Maps" ),
(   639,    "installdir",   "Maps" ),
(   629,    "installdir",   "Maps" ),
(   640,    "installdir",   "Maps" ),
(   641,    "installdir",   "Maps" ),
(   642,    "installdir",   "Maps" ),
(   643,    "installdir",   "Maps" ),
(   644,    "installdir",   "Maps" ),
(   508,    "installdir",   "Maps" ),
(   645,    "installdir",   "Maps" ),
(   646,    "installdir",   "Maps" ),
(   647,    "installdir",   "Maps" ),
(   648,    "installdir",   "Maps" ),
(   649,    "installdir",   "Maps" ),
(   650,    "installdir",   "Maps" ),
(   651,    "installdir",   "Maps" ),
(   652,    "installdir",   "Maps" ),
(   653,    "installdir",   "Maps" ),
(   654,    "installdir",   "Maps" ),
(   509,    "installdir",   "Maps" );

# Unpack methods - none for this group

# ################################################################
# Group #04: Different brands of Tactical Ops
# ################################################################
# Identification rules
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   622,    "ify04010",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + pref sw-" ),
(   624,    "ify04020",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + pref to-aot- + needs s_swat" ),
(   623,    "ify04040",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 2 + pref to- + needs s_swat" );

# Primary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   622,    "primary",      "UNR" ),
(   624,    "primary",      "UNR" ),
(   623,    "primary",      "UNR" );

# Secondary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   622,    "secondary",    "UT-SW" ),
(   624,    "secondary",    "UT-AOT" ),
(   623,    "secondary",    "UT-TO" );

# Preview method (obsolete)
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   622,    "preview",      "screenshots/" ),
(   624,    "preview",      "screenshots/" ),
(   623,    "preview",      "screenshots/" );

# Preview method
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   622,    "pvmeth",       "ul" ),
(   624,    "pvmeth",       "ul" ),
(   623,    "pvmeth",       "ul" );

# Installation directory - used during package reconstruction
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   622,    "installdir",   "Maps" ),
(   624,    "installdir",   "Maps" ),
(   623,    "installdir",   "Maps" );

# Unpack methods - none for this group

# ################################################################
# Group #05: Unreal modifications
# ################################################################
# Identification rules
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   701,    "ify05010",     "isu1 + suff .unr + actor LevelInfo >= 1 + needs RealCTF" ),
(   706,    "ify05020",     "isu1 + suff .unr + actor LevelInfo >= 1 + needs u4e,u4e1" ),
(   707,    "ify05021",     "isu1 + suff .unr + actor LevelInfo >= 1 + needs Serpentine" ),
(   704,    "ify05030",     "isu1 + suff .unr + actor LevelInfo >= 1 + needs infiltration" ),
(   702,    "ify05040",     "isu1 + suff .unr + actor LevelInfo >= 1 + pref dk + actor PlayerStart >= 1" ),
(   703,    "ify05050",     "isu1 + suff .unr + actor LevelInfo >= 1 + pref dm + actor PlayerStart >= 1" ),
(   705,    "ify05060",     "isu1 + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 1 + actor PlayerStart < 3" ),
(   703,    "ify05070",     "isu1 + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 3" );

# Primary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   701,    "primary",      "UNR" ),
(   702,    "primary",      "UNR" ),
(   703,    "primary",      "UNR" ),
(   704,    "primary",      "UNR" ),
(   705,    "primary",      "UNR" ),
(   706,    "primary",      "UNR" ),
(   707,    "primary",      "UNR" );

# Secondary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   701,    "secondary",    "U1-RealCTF" ),
(   702,    "secondary",    "U1-DK" ),
(   703,    "secondary",    "U1-DM" ),
(   704,    "secondary",    "U1-INF" ),
(   705,    "secondary",    "U1-SP" ),
(   706,    "secondary",    "U1-U4E" ),
(   707,    "secondary",    "U1-Serp" );

# Preview methods (obsolete)
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   701,    "preview",      "levelinfo/" ),
(   702,    "preview",      "levelinfo/" ),
(   703,    "preview",      "levelinfo/" ),
(   704,    "preview",      "levelinfo/" ),
(   705,    "preview",      "levelinfo/" ),
(   706,    "preview",      "levelinfo/" ),
(   707,    "preview",      "levelinfo/" );

# Preview methods
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   701,    "pvmeth",       "ul" ),
(   702,    "pvmeth",       "ul" ),
(   703,    "pvmeth",       "ul" ),
(   704,    "pvmeth",       "ul" ),
(   705,    "pvmeth",       "ul" ),
(   706,    "pvmeth",       "ul" ),
(   707,    "pvmeth",       "ul" );

# Installation directory - used during package reconstruction
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   701,    "installdir",   "Maps" ),
(   702,    "installdir",   "Maps" ),
(   703,    "installdir",   "Maps" ),
(   704,    "installdir",   "Maps" ),
(   705,    "installdir",   "Maps" ),
(   706,    "installdir",   "Maps" ),
(   707,    "installdir",   "Maps" );

# Unpack methods - none for this group

# ################################################################
# Group #06: AAO modifications
# ################################################################
# Identification rules

# Primary type, stored to file

# Secondary type, stored to file

# Preview methods

# Installation directory - used during package reconstruction

# Unpack methods - none for this group

# ################################################################
# Group #07: UT2K3 modifications
# ################################################################
# Identification rules
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   820,    "ify07000",     "isut2k3 + suff .ut2 + pref db- + actor LevelInfo >= 1 + needs Deathball" ),
(   821,    "ify07010",     "isut2k3 + suff .ut2 + pref hfb- + actor LevelInfo >= 1 + actor HFBallSpawner > 0 + actor HFGoal > 0 + needs HFBall" ),
(   822,    "ify07020",     "isut2k3 + suff .ut2 + pref ba- + actor LevelInfo >= 1 + needs BlastArena" ),
(   823,    "ify07030",     "isut2k3 + suff .ut2 + pref ftb- + actor LevelInfo >= 1 + actor FTB_BombDelivery > 0 + actor FTB_BombSpawn > 0 + needs FindTheBall" ),
(   824,    "ify07040",     "isut2k3 + suff .ut2 + pref str- + actor LevelInfo >= 1 + actor Stairs_KarmaSpawn > 0 + needs Stairs" ),
(   825,    "ify07050",     "isut2k3 + suff .ut2 + actor LevelInfo >= 1 + needs Paintball" ),
(   826,    "ify07060",     "isut2k3 + suff .ut2 + pref ovl- + actor LevelInfo >= 1 + actor OverloadGoal > 0 + needs Overload" ),
(   827,    "ify07070",     "isut2k3 + suff .ut2 + pref us- + actor LevelInfo >= 1 + actor USCarReset > 0 + actor US_CheckPoint > 0 + needs UnrealSpeed" ),
(   828,    "ify07080",     "isut2k3 + suff .ut2 + actor LevelInfo >= 1 + actor NBBrick > 0 + needs NaliBricks" ),
(   828,    "ify07081",     "isut2k3 + suff .ut2 + actor LevelInfo >= 1 + actor NBWaterVolume > 0 + needs NaliBricks" ),
(   829,    "ify07090",     "isut2k3 + suff .ut2 + pref kh- + actor LevelInfo >= 1 + actor xDomPointA > 0" ),
(   829,    "ify07091",     "isut2k3 + suff .ut2 + pref kh- + actor LevelInfo >= 1 + actor xDomPointB > 0" ),
(   830,    "ify07100",     "isut2k3 + suff .ut2 + pref bp- + actor LevelInfo >= 1" ),
(   831,    "ify07110",     "isut2k3 + suff .ut2 + pref ofc- + actor LevelInfo >= 1 + actor  OFC_FlagBase > 0 + needs OneFlagCapture" ),
(   832,    "ify07120",     "isut2k3 + suff .ut2 + pref as- + actor LevelInfo >= 1 + needs RoARAssault" ),
(   832,    "ify07121",     "isut2k3 + suff .ut2 + pref asr- + actor LevelInfo >= 1 + needs RoARAssault" ),
(   833,    "ify07130",     "isut2k3 + suff .ut2 + actor LevelInfo >= 1 + needs Greed" ),
(   834,    "ify07140",     "isut2k3 + suff .ut2 + actor LevelInfo >= 1 + actor MMLevelInfo > 0 + needs Marble" ),
(   835,    "ify07150",     "isut2k3 + suff .ut2 + pref dob- + actor LevelInfo >= 1 + actor Dob_BombSpawn > 0 + needs DodgeBall" ),
(   836,    "ify07160",     "isut2k3 + suff .ut2 + pref uw- + actor LevelInfo >= 1 + actor UWStartSpot > 0 + needs UnWheel" ),
(   837,    "ify07170",     "isut2k3 + suff .ut2 + pref fo-obj + actor LevelInfo >= 1 + actor FO_OBJ_Controller > 0 + needs Faceoff" ),
(   837,    "ify07171",     "isut2k3 + suff .ut2 + pref fo-obj + actor LevelInfo >= 1 + actor FO_OBJ_HoldableDelivery > 0 + needs Faceoff" ),
(   837,    "ify07172",     "isut2k3 + suff .ut2 + pref fo-obj + actor LevelInfo >= 1 + actor FO_OBJ_HoldableHomeBase > 0 + needs Faceoff" ),
(   838,    "ify07180",     "isut2k3 + suff .ut2 + pref fo-ctf + actor LevelInfo >= 1 + actor FO_CTF_RedFlag > 0 + needs Faceoff" ),
(   838,    "ify07181",     "isut2k3 + suff .ut2 + pref fo-ctf + actor LevelInfo >= 1 + actor FO_CTF_BlueFlag > 0 + needs Faceoff" ),
(   839,    "ify07190",     "isut2k3 + suff .ut2 + pref fo- + actor LevelInfo >= 1  + needs Faceoff" ),
(   840,    "ify07200",     "isut2k3 + suff .ut2 + actor LevelInfo >= 1 + needs ESCGame" ),
(   841,    "ify07210",     "isut2k3 + suff .ut2 + pref ten- + actor LevelInfo >= 1 + needs Deathball,Tennis" ),
(   842,    "ify07220",     "isut2k3 + suff .ut2 + pref fd- + actor LevelInfo >= 1 + needs FlagDom" ),
(   843,    "ify07230",     "isut2k3 + suff .ut2 + pref ldm- + actor LevelInfo >= 1 + needs LawDogsGame,LawDogsKarma,LawDogsVehicles" ),
(   844,    "ify07240",     "isut2k3 + suff .ut2 + pref ro- + actor LevelInfo >= 1 + actor ROLevelInfo > 0 + needs ROGame" ),
(   845,    "ify07250",     "isut2k3 + suff .ut2 + pref dm- + actor LevelInfo >= 1 + needs ChaosUT" ),
(   846,    "ify07260",     "isut2k3 + suff .ut2 + pref koth- + actor LevelInfo >= 1 + needs ChaosUT" ),
(   848,    "ify07270",     "isut2k3 + suff .ut2 + pref fo-mis- + actor LevelInfo >= 1 + needs FragOps" ),
(   849,    "ify07271",     "isut2k3 + suff .ut2 + pref fo-rg- + actor LevelInfo >= 1 + needs FragOps" ),
(   847,    "ify07272",     "isut2k3 + suff .ut2 + actor LevelInfo >= 1 + needs FragOps" );

# Primary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   820,    "primary",      "UNR" ),
(   821,    "primary",      "UNR" ),
(   822,    "primary",      "UNR" ),
(   823,    "primary",      "UNR" ),
(   824,    "primary",      "UNR" ),
(   825,    "primary",      "UNR" ),
(   826,    "primary",      "UNR" ),
(   827,    "primary",      "UNR" ),
(   828,    "primary",      "UNR" ),
(   829,    "primary",      "UNR" ),
(   830,    "primary",      "UNR" ),
(   831,    "primary",      "UNR" ),
(   832,    "primary",      "UNR" ),
(   833,    "primary",      "UNR" ),
(   834,    "primary",      "UNR" ),
(   835,    "primary",      "UNR" ),
(   836,    "primary",      "UNR" ),
(   837,    "primary",      "UNR" ),
(   838,    "primary",      "UNR" ),
(   839,    "primary",      "UNR" ),
(   840,    "primary",      "UNR" ),
(   841,    "primary",      "UNR" ),
(   842,    "primary",      "UNR" ),
(   843,    "primary",      "UNR" ),
(   844,    "primary",      "UNR" ),
(   845,    "primary",      "UNR" ),
(   846,    "primary",      "UNR" ),
(   847,    "primary",      "UNR" ),
(   848,    "primary",      "UNR" ),
(   849,    "primary",      "UNR" );

# Secondary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   820,    "secondary",    "UT2K3-DBALL" ),
(   821,    "secondary",    "UT2K3-HBALL" ),
(   822,    "secondary",    "UT2K3-BLARE" ),
(   823,    "secondary",    "UT2K3-FTHBL" ),
(   824,    "secondary",    "UT2K3-STAIR" ),
(   825,    "secondary",    "UT2K3-PBALL" ),
(   826,    "secondary",    "UT2K3-OVRLD" ),
(   827,    "secondary",    "UT2K3-USPEE" ),
(   828,    "secondary",    "UT2K3-NALIB" ),
(   829,    "secondary",    "UT2K3-KOTHL" ),
(   830,    "secondary",    "UT2K3-BLOPI" ),
(   831,    "secondary",    "UT2K3-OFCTF" ),
(   832,    "secondary",    "UT2K3-ASSRO" ),
(   833,    "secondary",    "UT2K3-GREED" ),
(   834,    "secondary",    "UT2K3-MMADN" ),
(   835,    "secondary",    "UT2K3-DODBA" ),
(   836,    "secondary",    "UT2K3-UWHEL" ),
(   837,    "secondary",    "UT2K3-FOOBJ" ),
(   838,    "secondary",    "UT2K3-FOCTF" ),
(   839,    "secondary",    "UT2K3-FOTDM" ),
(   840,    "secondary",    "UT2K3-AIRBU" ),
(   841,    "secondary",    "UT2K3-TENNI" ),
(   842,    "secondary",    "UT2K3-FDOMI" ),
(   843,    "secondary",    "UT2K3-LAWDO" ),
(   844,    "secondary",    "UT2K3-REDOR" ),
(   845,    "secondary",    "UT2K3-CUTDM" ),
(   846,    "secondary",    "UT2K3-CUTKO" ),
(   847,    "secondary",    "UT2K3-FRGOP" ),
(   848,    "secondary",    "UT2K3-FOPMI" ),
(   849,    "secondary",    "UT2K3-FOPRG" );

# Preview method (default)
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   820,    "preview",      "screenshots/" ),
(   821,    "preview",      "screenshots/" ),
(   822,    "preview",      "screenshots/" ),
(   823,    "preview",      "screenshots/" ),
(   824,    "preview",      "screenshots/" ),
(   825,    "preview",      "screenshots/" ),
(   826,    "preview",      "screenshots/" ),
(   827,    "preview",      "screenshots/" ),
(   828,    "preview",      "screenshots/" ),
(   829,    "preview",      "screenshots/" ),
(   830,    "preview",      "screenshots/" ),
(   831,    "preview",      "screenshots/" ),
(   832,    "preview",      "screenshots/" ),
(   833,    "preview",      "screenshots/" ),
(   834,    "preview",      "screenshots/" ),
(   835,    "preview",      "screenshots/" ),
(   836,    "preview",      "screenshots/" ),
(   837,    "preview",      "screenshots/" ),
(   838,    "preview",      "screenshots/" ),
(   839,    "preview",      "screenshots/" ),
(   840,    "preview",      "screenshots/" ),
(   841,    "preview",      "screenshots/" ),
(   842,    "preview",      "screenshots/" ),
(   843,    "preview",      "screenshots/" ),
(   844,    "preview",      "screenshots/" ),
(   845,    "preview",      "screenshots/" ),
(   846,    "preview",      "screenshots/" ),
(   847,    "preview",      "screenshots/" ),
(   848,    "preview",      "screenshots/" ),
(   849,    "preview",      "screenshots/" );

# Preview methods
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   820,    "pvmeth",       "ul" ),
(   821,    "pvmeth",       "ul" ),
(   822,    "pvmeth",       "ul" ),
(   823,    "pvmeth",       "ul" ),
(   824,    "pvmeth",       "ul" ),
(   825,    "pvmeth",       "ul" ),
(   826,    "pvmeth",       "ul" ),
(   827,    "pvmeth",       "ul" ),
(   828,    "pvmeth",       "ul" ),
(   829,    "pvmeth",       "ul" ),
(   830,    "pvmeth",       "ul" ),
(   831,    "pvmeth",       "ul" ),
(   832,    "pvmeth",       "ula" ),
(   833,    "pvmeth",       "ul" ),
(   834,    "pvmeth",       "ul" ),
(   835,    "pvmeth",       "ul" ),
(   836,    "pvmeth",       "ul" ),
(   837,    "pvmeth",       "ul" ),
(   838,    "pvmeth",       "ul" ),
(   839,    "pvmeth",       "ul" ),
(   840,    "pvmeth",       "ul" ),
(   841,    "pvmeth",       "ul" ),
(   842,    "pvmeth",       "ul" ),
(   843,    "pvmeth",       "ul" ),
(   844,    "pvmeth",       "ul" ),
(   845,    "pvmeth",       "ul" ),
(   846,    "pvmeth",       "ul" ),
(   847,    "pvmeth",       "ul" ),
(   848,    "pvmeth",       "ul" ),
(   849,    "pvmeth",       "ul" );

# Installation directory - used during package reconstruction
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   820,    "installdir",   "Maps" ),
(   821,    "installdir",   "Maps" ),
(   822,    "installdir",   "Maps" ),
(   823,    "installdir",   "Maps" ),
(   824,    "installdir",   "Maps" ),
(   825,    "installdir",   "Maps" ),
(   826,    "installdir",   "Maps" ),
(   827,    "installdir",   "Maps" ),
(   828,    "installdir",   "Maps" ),
(   829,    "installdir",   "Maps" ),
(   830,    "installdir",   "Maps" ),
(   831,    "installdir",   "Maps" ),
(   832,    "installdir",   "Maps" ),
(   833,    "installdir",   "Maps" ),
(   834,    "installdir",   "Maps" ),
(   835,    "installdir",   "Maps" ),
(   836,    "installdir",   "Maps" ),
(   837,    "installdir",   "Maps" ),
(   838,    "installdir",   "Maps" ),
(   839,    "installdir",   "Maps" ),
(   840,    "installdir",   "Maps" ),
(   841,    "installdir",   "Maps" ),
(   842,    "installdir",   "Maps" ),
(   843,    "installdir",   "Maps" ),
(   844,    "installdir",   "Maps" ),
(   845,    "installdir",   "Maps" ),
(   846,    "installdir",   "Maps" ),
(   847,    "installdir",   "Maps" ),
(   848,    "installdir",   "Maps" ),
(   849,    "installdir",   "Maps" );

# Unpack methods - none for this group


# ################################################################
# Group #08: Standard UT game level types
#           Here are also those game levels that can only be
#           distinguished by their name (which - is baaad! )
# ################################################################
# Identification rules
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   501,    "ify08010",     "isut + suff .unr + pref as + actor AssaultInfo >= 1 + actor LevelInfo >= 1 + actor FortStandard >= 1 + actor PlayerStart >= 1" ),
(   502,    "ify08020",     "isut + suff .unr + pref ctf + actor LevelInfo >= 1 + actor FlagBase >= 1 + actor PlayerStart >= 2" ),
(   502,    "ify08021",     "isut + suff .unr + pref ctf + actor LevelInfo >= 1 + actor METFlagBase >= 1 + actor PlayerStart >= 2" ),
(   502,    "ify08022",     "isut + suff .unr + pref ctf + actor LevelInfo >= 1 + actor GanymedeFlagBase >= 1 + actor PlayerStart >= 2" ),
(   502,    "ify08023",     "isut + suff .unr + pref ctf + actor LevelInfo >= 1 + actor FlagBase >= 1 + actor S7G_PlayerStart >= 2" ),
(   502,    "ify08024",     "isut + suff .unr + pref ctf-avrilvsbritne" ),
(   503,    "ify08030",     "isut + suff .unr + pref dom + actor ControlPoint >= 1 + actor LevelInfo >= 1 + actor PlayerStart >= 2" ),
(   503,    "ify08031",     "isut + suff .unr + pref dom + actor ArmyraControlPoint >= 1 + actor LevelInfo >= 1 + actor PlayerStart >= 2" ),
(   504,    "ify08040",     "isut + suff .unr + pref dm- + actor LevelInfo >= 1 + actor PlayerStart >= 1" ),
(   504,    "ify08041",     "isut + suff .unr + pref dm- + actor LevelInfo >= 1 + actor PhragItSpawnpoint >= 1" ),
(   626,    "ify08050",     "isut + suff .unr + pref mh- + actor LevelInfo >= 1 + actor PlayerStart >= 1" ),
(   627,    "ify08051",     "isut + suff .unr + pref ma- + actor LevelInfo >= 1 + actor PlayerStart >= 1" ),
(   505,    "ify08061",     "isut + suff .unr + needs oldskool + actor LevelInfo >= 1 + actor PlayerStart == 1" ),
(   506,    "ify08070",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 1 + actor PlayerStart < 3" ),
(   507,    "ify08071",     "isut + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 1 + needs Legacy" ),
(   504,    "ify08080",     "isut + notpref as- + notpref ctf- + notpref dom- + suff .unr + actor LevelInfo >= 1 + actor PlayerStart >= 3" );

# Primary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   501,    "primary",      "UNR" ),
(   502,    "primary",      "UNR" ),
(   503,    "primary",      "UNR" ),
(   504,    "primary",      "UNR" ),
(   626,    "primary",      "UNR" ),
(   627,    "primary",      "UNR" ),
(   505,    "primary",      "UNR" ),
(   506,    "primary",      "UNR" ),
(   507,    "primary",      "UNR" );

# Secondary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   501,    "secondary",    "UT-AS" ),
(   502,    "secondary",    "UT-CTF" ),
(   503,    "secondary",    "UT-DOM" ),
(   504,    "secondary",    "UT-DM" ),
(   626,    "secondary",    "UT-MH" ),
(   627,    "secondary",    "UT-MA" ),
(   505,    "secondary",    "UT-SP-OSK" ),
(   506,    "secondary",    "UT-SP" ),
(   507,    "secondary",    "UT-SP-LEG" );

# Preview method (obsolete)
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   501,    "preview",      "screenshots/" ),
(   502,    "preview",      "screenshots/" ),
(   503,    "preview",      "screenshots/" ),
(   504,    "preview",      "screenshots/" ),
(   626,    "preview",      "screenshots/" ),
(   627,    "preview",      "screenshots/" ),
(   505,    "preview",      "screenshots/" ),
(   506,    "preview",      "screenshots/" ),
(   507,    "preview",      "screenshots/" );

# Preview method
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   501,    "pvmeth",       "ula" ),
(   502,    "pvmeth",       "ul" ),
(   503,    "pvmeth",       "ul" ),
(   504,    "pvmeth",       "ul" ),
(   626,    "pvmeth",       "ul" ),
(   627,    "pvmeth",       "ul" ),
(   505,    "pvmeth",       "ul" ),
(   506,    "pvmeth",       "ul" ),
(   507,    "pvmeth",       "ul" );

# Installation directory - used during package reconstruction
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   501,    "installdir",   "Maps" ),
(   502,    "installdir",   "Maps" ),
(   503,    "installdir",   "Maps" ),
(   504,    "installdir",   "Maps" ),
(   626,    "installdir",   "Maps" ),
(   627,    "installdir",   "Maps" ),
(   505,    "installdir",   "Maps" ),
(   506,    "installdir",   "Maps" ),
(   507,    "installdir",   "Maps" );

# Unpack methods - none for this group

# ################################################################
# Group #09: Standard UT2003 game level types
# ################################################################
# Identification rules
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   801,    "ify09010",     "isut2k3 + suff .ut2 + pref dm- + actor LevelInfo > 0 + actor PlayerStart > 0" ),
(   802,    "ify09020",     "isut2k3 + suff .ut2 + pref ctf- + actor LevelInfo > 0 + actor PlayerStart > 1 + actor xRedFlagBase > 0" ),
(   802,    "ify09021",     "isut2k3 + suff .ut2 + pref ctf- + actor LevelInfo > 0 + actor PlayerStart > 1 + actor xBlueFlagBase > 0" ),
(   802,    "ify09022",     "isut2k3 + suff .ut2 + pref ctf- + actor LevelInfo > 0 + actor PlayerStart > 1 + actor xGreenFlagBase > 0" ),
(   802,    "ify09023",     "isut2k3 + suff .ut2 + pref ctf- + actor LevelInfo > 0 + actor PlayerStart > 1 + actor xGoldFlagBase > 0" ),
(   803,    "ify09060",     "isut2k3 + suff .ut2 + pref br- + actor LevelInfo > 0 + actor PlayerStart > 0 + actor xBombDelivery > 0 + actor xBombSpawn > 0" ),
(   805,    "ify09070",     "isut2k3 + suff .ut2 + pref dom- + actor LevelInfo > 0 + actor PlayerStart > 0 + actor xDomPointA > 0" ),
(   805,    "ify09071",     "isut2k3 + suff .ut2 + pref dom- + actor LevelInfo > 0 + actor PlayerStart > 0 + actor xDomPointB > 0" ),
(   806,    "ify09080",     "isut2k3 + suff .ut2 + pref tut- + actor LevelInfo > 0 + actor PlayerStart > 0" ),
(   804,    "ify09090",     "isut2k3 + suff .ut2 + actor LevelInfo > 0 + actor PlayerStart >= 1 + actor PlayerStart < 3" ),
(   801,    "ify09090",     "isut2k3 + notpref dm- + notpref ctf- + notpref br- + notpref dom- + suff .ut2 + actor LevelInfo > 0 + actor PlayerStart >= 3" );

# Primary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   801,    "primary",      "UNR" ),
(   802,    "primary",      "UNR" ),
(   803,    "primary",      "UNR" ),
(   804,    "primary",      "UNR" ),
(   805,    "primary",      "UNR" ),
(   806,    "primary",      "UNR" );

# Secondary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   801,    "secondary",    "UT2K3-DM" ),
(   802,    "secondary",    "UT2K3-CTF" ),
(   803,    "secondary",    "UT2K3-BR" ),
(   804,    "secondary",    "UT2K3-SP" ),
(   805,    "secondary",    "UT2K3-DOM" ),
(   806,    "secondary",    "UT2K3-TUT" );

# Preview method (obsolete)
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   801,    "preview",      "screenshots/" ),
(   802,    "preview",      "screenshots/" ),
(   803,    "preview",      "screenshots/" ),
(   804,    "preview",      "screenshots/" ),
(   805,    "preview",      "screenshots/" ),
(   806,    "preview",      "screenshots/" );

# Preview method
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   801,    "pvmeth",       "ul" ),
(   802,    "pvmeth",       "ul" ),
(   803,    "pvmeth",       "ul" ),
(   804,    "pvmeth",       "ul" ),
(   805,    "pvmeth",       "ul" ),
(   806,    "pvmeth",       "ul" );

# Installation directory - used during package reconstruction
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   801,    "installdir",   "Maps" ),
(   802,    "installdir",   "Maps" ),
(   803,    "installdir",   "Maps" ),
(   804,    "installdir",   "Maps" ),
(   805,    "installdir",   "Maps" ),
(   806,    "installdir",   "Maps" );

# Unpack methods - none for this group

# ################################################################
# Group #10: Unreal2 Modifications
# ################################################################
# Identification rules
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   750,    "ify10010",     "isut2k3 + suff .unr + pref xmp- + actor LevelInfo > 0" );

# Primary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   750,    "primary",      "UNR" );

# Secondary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   750,    "secondary",    "U2XMP" );

# Preview method (obsolete)
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   750,    "preview",      "screenshots/" );

# Preview method
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   750,    "pvmeth",       "ul" );

# Installation directory - used during package reconstruction
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   750,    "installdir",   "Maps" );


# ################################################################
# Group #99: Detection of unplayable and unclassified files
# ################################################################
# Identification rules
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   901,    "ify99001",     "isu1 + suff .unr + actor LevelInfo > 0 + actor PlayerStart == 0" ),
(   902,    "ify99002",     "isu1 + suff .unr" ),
(   904,    "ify99003",     "isut + suff .unr + pref as- + actor LevelInfo > 0" ),
(   905,    "ify99004",     "isut + suff .unr + pref dom- + actor LevelInfo > 0" ),
(   906,    "ify99005",     "isut + suff .unr + pref ctf- + actor LevelInfo > 0" ),
(   907,    "ify99006",     "isut + suff .unr + pref dm + actor LevelInfo > 0" ),
(   908,    "ify99007",     "isut + suff .unr + actor LevelInfo > 0 + actor PlayerStart == 0" ),
(   909,    "ify99008",     "isut + suff .unr" ),
(   912,    "ify99100",     "isut2k3 + suff .ut2 + pref br- + actor LevelInfo > 0" ),
(   913,    "ify99101",     "isut2k3 + suff .ut2 + pref dom- + actor LevelInfo > 0" ),
(   914,    "ify99102",     "isut2k3 + suff .ut2 + pref ctf- + actor LevelInfo > 0" ),
(   915,    "ify99103",     "isut2k3 + suff .ut2 + pref dm- + actor LevelInfo > 0 + actor PlayerStart == 0" ),
(   916,    "ify99104",     "isut2k3 + suff .ut2 + actor LevelInfo > 0 + actor PlayerStart == 0" ),
(   917,    "ify99105",     "isut2k3 + suff .ut2" ),
(   999,    "ify99900",     "suff .unr" ),
(   999,    "ify99901",     "suff .ut2" ),
(   999,    "ify99902",     "suff .aao" );

# Primary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   901,    "primary",      "UNR" ),
(   902,    "primary",      "UNR" ),
(   904,    "primary",      "UNR" ),
(   905,    "primary",      "UNR" ),
(   906,    "primary",      "UNR" ),
(   907,    "primary",      "UNR" ),
(   908,    "primary",      "UNR" ),
(   909,    "primary",      "UNR" ),
(   912,    "primary",      "UNR" ),
(   913,    "primary",      "UNR" ),
(   914,    "primary",      "UNR" ),
(   915,    "primary",      "UNR" ),
(   916,    "primary",      "UNR" ),
(   917,    "primary",      "UNR" ),
(   999,    "primary",      "UNR" );

# Secondary type, stored to file
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   901,    "secondary",    "U1-NOPLAY" ),
(   902,    "secondary",    "U1-LEVEL" ),
(   904,    "secondary",    "UT-AS-NOPLAY" ),
(   905,    "secondary",    "UT-DOM-NOPLAY" ),
(   906,    "secondary",    "UT-CTF-NOPLAY" ),
(   907,    "secondary",    "UT-DM-NOPLAY" ),
(   908,    "secondary",    "UT-NOPLAY" ),
(   909,    "secondary",    "UT-LEVEL" ),
(   912,    "secondary",    "UT2K3-BR-NOPLAY" ),
(   913,    "secondary",    "UT2K3-DOM-NOPLAY" ),
(   914,    "secondary",    "UT2K3-CTF-NOPLAY" ),
(   915,    "secondary",    "UT2K3-DM-LEVEL" ),
(   916,    "secondary",    "UT2K3-NOPLAY" ),
(   917,    "secondary",    "UT2K3-LEVEL" ),
(   999,    "secondary",    "UNREAL-LEVEL" );

# Preview methods (obsolete)
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   901,    "preview",      "levelinfo/" ),
(   902,    "preview",      "levelinfo/" ),
(   904,    "preview",      "screenshots/" ),
(   905,    "preview",      "screenshots/" ),
(   906,    "preview",      "screenshots/" ),
(   907,    "preview",      "screenshots/" ),
(   908,    "preview",      "screenshots/" ),
(   909,    "preview",      "screenshots/" ),
(   912,    "preview",      "screenshots/" ),
(   913,    "preview",      "screenshots/" ),
(   914,    "preview",      "screenshots/" ),
(   915,    "preview",      "screenshots/" ),
(   916,    "preview",      "screenshots/" ),
(   917,    "preview",      "screenshots/" ),
(   999,    "preview",      "unrdetails/" );

# Preview methods
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   901,    "pvmeth",       "ul" ),
(   902,    "pvmeth",       "ul" ),
(   904,    "pvmeth",       "ula" ),
(   905,    "pvmeth",       "ul" ),
(   906,    "pvmeth",       "ul" ),
(   907,    "pvmeth",       "ul" ),
(   908,    "pvmeth",       "ul" ),
(   909,    "pvmeth",       "ul" ),
(   912,    "pvmeth",       "ul" ),
(   913,    "pvmeth",       "ul" ),
(   914,    "pvmeth",       "ul" ),
(   915,    "pvmeth",       "ul" ),
(   916,    "pvmeth",       "ul" ),
(   917,    "pvmeth",       "ul" ),
(   999,    "pvmeth",       "u" );

# Installation directory - used during package reconstruction
INSERT INTO rule ( rule_type, rule_name, rule_rule ) VALUES
(   901,    "installdir",   "Maps" ),
(   902,    "installdir",   "Maps" ),
(   904,    "installdir",   "Maps" ),
(   905,    "installdir",   "Maps" ),
(   906,    "installdir",   "Maps" ),
(   907,    "installdir",   "Maps" ),
(   908,    "installdir",   "Maps" ),
(   909,    "installdir",   "Maps" ),
(   912,    "installdir",   "Maps" ),
(   913,    "installdir",   "Maps" ),
(   914,    "installdir",   "Maps" ),
(   915,    "installdir",   "Maps" ),
(   916,    "installdir",   "Maps" ),
(   917,    "installdir",   "Maps" ),
(   999,    "installdir",   "Maps" );

# Unpack methods - none for this group

# ################################################################
# EOF: UTCMS_rule.sql
# ################################################################
