# ################################################################
# UTCMS_sess.sql
# Creates sess table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from: 
# refers  : user(sess_user)
#
# ################################################################
# Field descriptions
# ################################################################
# sess_idnt		Record identifier, used to reference a session
# sess_user		Reference to the user
# sess_time		Time after which this session is invalid
# sess_pass		Password that was used the last time
# sess_addr		Address from where it came last time

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS sess;

# ################################################################
# Create the sess table and it's indexes
# ################################################################
CREATE TABLE sess (
	sess_idnt	INTEGER			NOT NULL	DEFAULT 0,
	sess_user	INTEGER			NOT NULL	DEFAULT 0,
	sess_time	INTEGER			NOT NULL	DEFAULT 0,
	sess_pass	CHAR(100)		NOT NULL,
	sess_addr	CHAR(100)		NOT NULL,

	PRIMARY KEY ( sess_idnt )
);

CREATE INDEX		sess_user_ix		ON sess ( sess_user );
CREATE INDEX		sess_time_ix		ON sess ( sess_time );
CREATE INDEX		sess_pass_ix		ON sess ( sess_pass );
CREATE INDEX		sess_addr_ix		ON sess ( sess_addr );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON sess TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# EOF: UTCMS_sess.sql
# ################################################################

