# ################################################################
# UTCMS_srvr.sql
# Creates srvr table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ################################################################
# Field descriptions
# ################################################################

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS srvr;

# ################################################################
# Create the srvr table and it's indexes
# ################################################################
CREATE TABLE srvr (
	srvr_addr	CHAR(64)		NOT NULL,
	srvr_port	INTEGER			NOT NULL	DEFAULT 0,
	srvr_quep	INTEGER			NOT NULL	DEFAULT 0,
	srvr_type	CHAR(8)			NOT NULL,
	srvr_name	CHAR(200)		NOT NULL,
	srvr_gmap	CHAR(64)		NOT NULL,
	srvr_gttl	CHAR(200)		NOT NULL,
	srvr_gtyp	CHAR(32)		NOT NULL,
	srvr_pcur	INTEGER			NOT NULL	DEFAULT 0,
	srvr_pmax	INTEGER			NOT NULL	DEFAULT 0,
	srvr_time	DATETIME		NOT NULL,
	PRIMARY KEY ( srvr_addr, srvr_quep )
);

CREATE INDEX		srvr_name_ix		ON srvr ( srvr_name );
CREATE INDEX		srvr_gmap_ix		ON srvr ( srvr_gmap );
CREATE INDEX		srvr_time_ix		ON srvr ( srvr_time );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON srvr TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# EOF: UTCMS_srvr.sql
# ################################################################
