# ################################################################
# UTCMS_type.sql
# Creates type table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from: file(file_type), rule(rule_type)
# refers  : styp(styp_idnt)
#
# ################################################################
# Field descriptions
# ################################################################
# type_idnt		Record identifier, used to reference a type
# type_revs		Starting record of review sequence
# type_reve		Ending record of review sequence
# type_ctgr		Category
# type_name		Name of this type
# type_apri		Priority in author decisions 0..100

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS type;

# ################################################################
# Create the type table and it's indexes
# ################################################################
CREATE TABLE type (
	type_idnt	INTEGER			NOT NULL	DEFAULT 0,
	type_ctgr	CHAR(64)		NOT NULL,
	type_name	CHAR(100)		NOT NULL,
	type_apri	INTEGER			NOT NULL	DEFAULT 0,

	PRIMARY KEY ( type_idnt )
);

CREATE INDEX		type_name_ix		ON type ( type_name );
CREATE INDEX		type_ctgr_ix		ON type ( type_ctgr );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON type TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# Additional files that can be managed by the system
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	1,		"Picture",	"GIF", 0 ),
(	2,		"Picture",	"JPG", 0 ),
(	3,		"Picture",	"PNG", 0 ),
(	4,		"Picture",	"PCX", 0 ),
(	5,		"Picture",	"BMP", 0 ),
(	6,		"Picture",	"Windows Icon", 0 ),
(	7,		"Sound",	"WAV", 0 ),
(	8,		"Sound",	"AIF", 0 ),
(	9,		"Music",	"Tracker S3M", 0 ),
(	10,		"Music",	"Tracker IT", 0 ),
(	11,		"Music",	"Tracker XM", 0 ),
(	12,		"Sound",	"MP2/MP3", 0 ),
(	13,		"Model",	"3D Studio Max", 0 ),
(	14,		"Model",	"DXF Autocad", 0 ),
(	15,		"Model",	"T3D Unreal Text", 90 ),
(	16,		"OS",		"Windows DLL", 0 ),
(	17,		"OS",		"Windows EXE", 0 ),
(	18,		"OS",		"Windows BAT", 0 ),
(	19,		"OS",		"Linux SO", 0 ),
(	20,		"Model",	"Upaint character", 0 ),
(	21,		"Model",	"Upaint skeleton", 0 ),
(	22,		"Model",	"Upaint animation", 0 ),
(	23,		"Model",	"Upaint data file", 0 );

# ################################################################
# Archive files
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	101,	"Archive",	"GZip", 0 ),
(	102,	"Archive",	"TAR", 0 ),
(	103,	"Archive",	"Zip", 0 ),
(	104,	"Archive",	"UMOD installer", 0 );

# ################################################################
# Document files
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	201,	"Document",	"PDF", 0 ),
(	202,	"Document",	"HTML", 80 ),
(	203,	"Document",	"TEXT", 80 ),
(	204,	"Document",	"WORD", 70 ),
(	205,	"Document",	"HTML (Unreal)", 80 ),
(	206,	"Document",	"HTML Cascaded Style Sheet", 60 );

# ################################################################
# Unreal configuration files
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	301,	"Config",	"Unreal/UT config file", 100 );

# ################################################################
# Unreal source, class, texture, audio and music files
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	401,	"Source",	"Unreal/UT/UT2k3 script source", 50 ),
(	402,	"Class",	"Unreal/UT Class", 90 ),
(	403,	"Picture",	"UT Texture", 90 ),
(	404,	"Sound",	"Unreal/UT Sound", 90 ),
(	405,	"Music",	"Unreal/UT Music", 90 ),
(	406,	"Music",	"UT2k3 Music - OGG", 90 ),
(	407,	"Model",	"Unreal/UT 3D file", 60 ),
(	408,	"Model",	"UT2k3 Static Mesh", 90 ),
(	409,	"Model",	"UT2k3 Animation", 90 ),
(	410,	"Config",	"Unreal/UT/UT2k3 Language - International", 95 ),
(	411,	"Config",	"Unreal/UT/UT2k3 Language - German", 95 ),
(	412,	"Config",	"Unreal/UT/UT2k3 Language - Spanish", 95 ),
(	413,	"Config",	"Unreal/UT/UT2k3 Language - Italian", 95 ),
(	414,	"Config",	"Unreal/UT/UT2k3 Language - French", 95 ),
(	415,	"Config",	"UT2k3 Player", 0 ),
(	416,	"Config",	"UT2k3 Karma Physics", 0 ),
(	417,	"Config",	"UT2k3 Force Feedback", 0 ),
(	418,	"Class",	"UT2k3 Class", 90 ),
(	419,	"Picture",	"UT2k3 Texture", 90 ),
(	420,	"Sound",	"UT2k3 Sound", 90 ),
(	421,	"Music",	"UT2k3 Music", 90 ),
(	422,	"Model",	"UT2k3 3D file", 90 ),
(	423,	"Class",	"AAO Class", 90 ),
(	424,	"Picture",	"AAO Texture", 90 ),
(	425,	"Sound",	"AAO Sound", 90 ),
(	426,	"Music",	"AAO Music", 90 ),
(	427,	"Model",	"AAO 3D file", 90 ),
(	428,	"Model",	"AAO Static Mesh", 90 ),
(	429,	"Model",	"Unreal/UT Model", 90 ),
(	430,	"Picture",	"Unreal Texture", 90 );

# ################################################################
# Special classes - Mutators and Skins
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	450,	"Class",	"Unreal MOD/Mutator", 90 ),
(	451,	"Class",	"UT MOD/Mutator", 90 ),
(	452,	"Class",	"UT2k3 MOD/Mutator", 90 );


# ################################################################
# Unreal Tournament standard game level types
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	501,	"Std Level",	"UT Assault", 90 ),
(	502,	"Std Level",	"UT CTF", 90 ),
(	503,	"Std Level",	"UT Domination", 90 ),
(	504,	"Std Level",	"UT Deathmatch", 90 ),
(	505,	"MOD Level",	"UT Single player, needs OldSkool", 90 ),
(	506,	"MOD Level",	"UT Single player", 90 ),
(	507,	"MOD Level",	"UT Single player (Legacy)", 90 ),
(	508,	"MOD Level",	"UT Single player (Xidia)", 90 ),
(	509,	"MOD Level",	"UT Single player (Spatial Fear)", 90 );

# ################################################################
# Unreal Tournament modified game level types
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	601,	"MOD Level",	"UT Multi CTF", 90 ),
(	602,	"MOD Level",	"UT Smash Droids", 90 ),
(	603,	"MOD Level",	"UT Jail Break", 90 ),
(	604,	"MOD Level",	"UT Infiltration Assault", 90 ),
(	605,	"MOD Level",	"UT Infiltration CTF", 90 ),
(	606,	"MOD Level",	"UT Infiltration Deathmatch", 90 ),
(	607,	"MOD Level",	"UT Infiltration Domination", 90 ),
(	608,	"MOD Level",	"UT Infiltration", 90 ),
(	614,	"MOD Level",	"UT Operation Na Pali", 90 ),
(	615,	"MOD Level",	"UT Conquest", 90 ),
(	616,	"MOD Level",	"UT CTF4 Plus 4-way CTF", 90 ),
(	617,	"MOD Level",	"UT CTF4 4-way CTF", 90 ),
(	618,	"MOD Level",	"UT Flag domination", 90 ),
(	619,	"MOD Level",	"UT Rocket Arena", 90 ),
(	620,	"MOD Level",	"UT Strike Force Team Deathmatch", 90 ),
(	621,	"MOD Level",	"UT Scavenger Hunt", 90 ),
(	622,	"MOD Level",	"UT Tactical Ops (SWAT)", 90 ),
(	623,	"MOD Level",	"UT Tactical Ops (TO)", 90 ),
(	624,	"MOD Level",	"UT Tactical Ops (AoT)", 90 ),
(	625,	"Std Level",	"Army Operations", 90 ),
(	626,	"MOD Level",	"UT Monster Hunt", 90 ),
(	627,	"MOD Level",	"UT Monster Arena", 90 ),
(	628,	"MOD Level",	"UT Defense Alliance", 90 ),
(	629,	"MOD Level",	"UT Airfight", 90 ),
(	630,	"MOD Level",	"UT Marathon MOD", 90 ),
(	631,	"MOD Level",	"UT Dominate The Flag", 90 ),
(	632,	"MOD Level",	"UT Fragball", 90 ),
(	633,	"MOD Level",	"UT ChaosUT (KOTH)", 90 ),
(	634,	"MOD Level",	"UT RACE Mod", 90 ),
(	635,	"MOD Level",	"UT King Of The Hill", 90 ),
(	636,	"MOD Level",	"UT ChaosUT", 90 ),
(	637,	"MOD Level",	"UT Hammertime", 90 ),
(	638,	"MOD Level",	"UT Unreal Fortress", 90 ),
(	639,	"MOD Level",	"UT Unreal Space", 90 ),
(	640,	"MOD Level",	"UT Jungle Warfare", 90 ),
(	641,	"MOD Level",	"UT Thievery", 90 ),
(	642,	"MOD Level",	"UT Bad Lands (Western)", 90 ),
(	643,	"MOD Level",	"UT Godz", 90 ),
(	644,	"MOD Level",	"UT Neo Cairo", 90 ),
(	645,	"MOD Level",	"UT Nali Range", 90 ),
(	646,	"MOD Level",	"UT Una Bomber", 90 ),
(	647,	"MOD Level",	"UT U4E Fortress", 90 ),
(	648,	"MOD Level",	"UT Nights Edge", 90 ),
(	649,	"MOD Level",	"UT Strike Force Deathmatch", 90 ),
(	650,	"MOD Level",	"UT Strike Force Escape", 90 ),
(	651,	"MOD Level",	"UT Strike Force Hostage Rescue", 90 ),
(	652,	"MOD Level",	"UT Strike Force Unknown", 90 ),
(	653,	"MOD Level",	"UT The Third Reich", 90 ),
(	654,	"MOD Level",	"UT Marines UT", 90 );


# ################################################################
# Unreal modified game level types
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	701,	"MOD Level",	"Unreal RealCFT", 90 ),
(	702,	"MOD Level",	"Unreal DarkMatch", 90 ),
(	703,	"MOD Level",	"Unreal Deathmatch", 90 ),
(	704,	"MOD Level",	"Unreal Infiltration", 90 ),
(	705,	"MOD Level",	"Unreal Single player", 90 ),
(	706,	"MOD Level",	"Unreal Unreal For Ever (U4E)", 90 ),
(	707,	"MOD Level",	"Unreal Serpentine", 90 );

# ################################################################
# Unreal2 modified game level types
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	750,	"MOD Level",	"Unreal2 Extended Multiplayer", 90 );



# ################################################################
# UT 2003 game level types
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	801,	"Std Level",	"UT2k3 Deathmatch", 90 ),
(	802,	"Std Level",	"UT2k3 CTF", 90 ),
(	803,	"Std Level",	"UT2k3 Bombing Run", 90 ),
(	804,	"Std Level",	"UT2k3 Single Player", 90 ),
(	805,	"Std Level",	"UT2k3 Domination", 90 ),
(	806,	"Std Level",	"UT2k3 Tutorial", 90 );

# ################################################################
# UT 2003 modified game level types
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	820,	"MOD Level",	"UT2k3 Death Ball", 90 ),
(	821,	"MOD Level",	"UT2k3 Happy Fun Ball", 90 ),
(	822,	"MOD Level",	"UT2k3 Blast Arena", 90 ),
(	823,	"MOD Level",	"UT2k3 Find The Ball", 90 ),
(	824,	"MOD Level",	"UT2k3 Porrasturvat Clone", 90 ),
(	825,	"MOD Level",	"UT2k3 Paintball", 90 ),
(	826,	"MOD Level",	"UT2k3 Overload", 90 ),
(	827,	"MOD Level",	"UT2k3 Unreal Speed", 90 ),
(	828,	"MOD Level",	"UT2k3 Nali Bricks", 90 ),
(	829,	"MOD Level",	"UT2k3 King Of The Hill", 90 ),
(	830,	"MOD Level",	"UT2k3 Blood Pit", 90 ),
(	831,	"MOD Level",	"UT2k3 One Flag Capture", 90 ),
(	832,	"MOD Level",	"UT2k3 Assault (RoAR)", 90 ),
(	833,	"MOD Level",	"UT2k3 Greed", 90 ),
(	834,	"MOD Level",	"UT2k3 Marble Madness", 90 ),
(	835,	"MOD Level",	"UT2k3 Dodge Ball", 90 ),
(	836,	"MOD Level",	"UT2k3 Unreal Wheels", 90 ),
(	837,	"MOD Level",	"UT2k3 Faceoff - OBJ", 90 ),
(	838,	"MOD Level",	"UT2k3 Faceoff - CTF", 90 ),
(	839,	"MOD Level",	"UT2k3 Faceoff - TDM", 90 ),
(	840,	"MOD Level",	"UT2k3 Air Buccaneers", 90 ),
(	841,	"MOD Level",	"UT2k3 Tennis", 90 ),
(	842,	"MOD Level",	"UT2k3 Flag Domination", 90 ),
(	843,	"MOD Level",	"UT2k3 Law Dogs", 90 ),
(	844,	"MOD Level",	"UT2k3 Red Orchestra", 90 ),
(	845,	"MOD Level",	"UT2k3 Chaos UT DM", 90 ),
(	846,	"MOD Level",	"UT2k3 Chaos UT KOTH", 90 ),
(	847,	"MOD Level",	"UT2k3 Frag Ops Map", 90 ),
(	848,	"MOD Level",	"UT2k3 Frag Ops Mission", 90 ),
(	849,	"MOD Level",	"UT2k3 Frag Ops Round Game", 90 );

# ################################################################
# Unidentified Unreal/UT/UT2k3 types
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	901,	"Unplayable",	"Unreal game level", 90 ),
(	902,	"Unregognized",	"Unreal game level", 90 ),
(	903,	"Unregognized",	"Unreal package", 90 ),
(	904,	"Unplayable",	"UT Assault game level", 90 ),
(	905,	"Unplayable",	"UT Domination game level", 90 ),
(	906,	"Unplayable",	"UT CTF game level", 90 ),
(	907,	"Unplayable",	"UT Deathmatch game level", 90 ),
(	908,	"Unplayable",	"UT game level", 90 ),
(	909,	"Unregognized",	"UT game level", 90 ),
(	910,	"Unregognized",	"UT package", 90 ),

(	911,	"Unregognized",	"AAO package", 90 ),

(	912,	"Unplayable",	"UT2k3 Bombing Run game level", 90 ),
(	913,	"Unplayable",	"UT2k3 Domination game level", 90 ),
(	914,	"Unplayable",	"UT2k3 CTF game level", 90 ),
(	915,	"Unplayable",	"UT2k3 Deathmatch game level", 90 ),
(	916,	"Unplayable",	"UT2k3 game level", 90 ),
(	917,	"Unregognized",	"UT2k3 game level", 90 ),
(	918,	"Unregognized",	"UT2k3 package", 90 ),

(	999,	"Unregognized",	"package", 90 );

# ################################################################
# Unknown file type
# ################################################################
INSERT INTO type ( type_idnt, type_ctgr, type_name, type_apri ) VALUES
(	99998,	"Corrupt",		"Unreal/UT/UT2k3 package", 0 ),
(	99999,	"Corrupt",		"File", 0 );

# ################################################################
# EOF: UTCMS_type.sql
# ################################################################
