# ################################################################
# UTCMS_urll.sql
# Creates urll table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from:
# refers  : 
#
# ################################################################
# Field descriptions
# ################################################################
# urll_name		Name of this link
# urll_type		Type of the link
# urll_addr		Address
# urll_ftyp		Fetch type
# urll_text		Explanation

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS urll;

# ################################################################
# Create the urll table and it's indexes
# ################################################################
CREATE TABLE urll (
	urll_name	CHAR(100)		NOT NULL,
	urll_type	CHAR(32)		NOT NULL,
	urll_addr	CHAR(200)		NOT NULL,
	urll_ftyp	CHAR(8)			NOT NULL,
	urll_user	INTEGER			NOT NULL	DEFAULT 0,
	urll_text	CHAR(250)		NOT NULL,
	PRIMARY KEY ( urll_name, urll_type, urll_addr )
);

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON urll TO quest@localhost;

FLUSH PRIVILEGES;


# ################################################################
# EOF: UTCMS_urll.sql
# ################################################################
