# ################################################################
# UTCMS_vote.sql
# Creates vote table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from: 
# refers  : file(vote_file)
#
# ################################################################
# Field descriptions
# ################################################################
# vote_idnt		Combination of address and the voted thing
# vote_time		Time when voted

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS vote;

# ################################################################
# Create the vote table and it's indexes
# ################################################################
CREATE TABLE vote (
	vote_idnt	char(40)		NOT NULL,
	vote_time	DATETIME		NOT NULL,

	PRIMARY KEY ( vote_idnt )
);

CREATE INDEX		vote_time_ix	ON vote ( vote_time );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON vote TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# EOF: UTCMS_vote.sql
# ################################################################
