# ################################################################
# UTCMS_xref.sql
# Creates xref table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from: 
# refers  : file(xref_file)
#
# ################################################################
# Field descriptions
# ################################################################
# xref_file		Refers the file record this is connected to
# xref_expo		0 -> Import, 1 -> Export
# xref_name		Name of the import/export item
# xref_refs		Number of references

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS xref;

# ################################################################
# Create the xref table and it's indexes
# ################################################################
CREATE TABLE xref (
	xref_file	INTEGER			NOT NULL	DEFAULT 0,
	xref_expo	INTEGER			NOT NULL	DEFAULT 0,
	xref_name	CHAR(40)		NOT NULL,
	xref_refs	INTEGER			NOT NULL	DEFAULT 0,

	PRIMARY KEY ( xref_file, xref_expo, xref_name )
);

CREATE INDEX		xref_name_ix		ON xref ( xref_name );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON xref TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# EOF: UTCMS_xref.sql
# ################################################################
