// --------------------------------------------------------------------
// CMySqlWhere.cxx
// Whatis:  Class especially suitable for making where statements
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CMySqlWhere.hxx"

// --------------------------------------------------------------
// public:      Quote
// --------------------------------------------------------------
CMySqlQuote::CMySqlQuote    () {
	itsQuote = NULL;
}

// --------------------------------------------------------------
CMySqlQuote::~CMySqlQuote    () {
	if	( itsQuote )	delete [] itsQuote;
}

// --------------------------------------------------------------
CMySqlQuote::CMySqlQuote              ( const CMySqlQuote & aC ) {
	itsQuote = NULL;
	itsQuote = ::my_private_strdup( aC.Quote() );
}

// --------------------------------------------------------------
CMySqlQuote & CMySqlQuote::operator = ( const CMySqlQuote & aC ) {
	if	( itsQuote )	delete [] itsQuote;
	itsQuote = ::my_private_strdup( aC.Quote() );
	return *this;
}

// --------------------------------------------------------------
const char * CMySqlQuote::Quote ( void ) const {
	return	itsQuote ? itsQuote : "";
}

// --------------------------------------------------------------
const char * CMySqlQuote::Quote ( const char * aQuote ) {
	size_t			l = 0;
	const char *	r;
	char *			w;

	// First, calculate the length of resulting string
	for	( r = aQuote; *r; r++ ) {
        switch  ( *r ) {
            case    '\'':
            case    '"':
            case     8:
            case     9:
            case    10:
            case    13:
            case    26:
            case    '\\':
            case    '%':	l++;
			default:		l++;
							break;
        }
	}

	// Allocate enough room for the resulting string
	if	( itsQuote )	delete [] itsQuote;
	itsQuote = new char [l + 1];
	w = itsQuote;
	for	( r = aQuote; *r; r++ ) {
        switch  ( *r ) {
            case    '\'':   *(w++) = '\\'; *(w++) = '\'';   break;
            case    '"':    *(w++) = '\\'; *(w++) = '"';    break;
            case     8:     *(w++) = '\\'; *(w++) = 'b';    break;
            case     9:     *(w++) = '\\'; *(w++) = 't';    break;
            case    10:     *(w++) = '\\'; *(w++) = 'n';    break;
            case    13:     *(w++) = '\\'; *(w++) = 'r';    break;
            case    26:     *(w++) = '\\'; *(w++) = 'z';    break;
            case    '\\':   *(w++) = '\\'; *(w++) = '\\';   break;
            case    '%':    *(w++) = '\\'; *(w++) = '%';    break;
            default:        *(w++) = *r;               		break;
        }
    }
    *w = 0;
    return  itsQuote;
}

// --------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------
CMySqlWhere::CMySqlWhere () {
    ::strcpy( itsWhere, "WHERE " );
}

// --------------------------------------------------------------
CMySqlWhere::~CMySqlWhere () {
}

// --------------------------------------------------------------
// public:      Copy constructor
// --------------------------------------------------------------
CMySqlWhere::CMySqlWhere ( const CMySqlWhere & aC ) {
    *this = aC;
}

// --------------------------------------------------------------
// public:      Assignment operators
// --------------------------------------------------------------
CMySqlWhere &   CMySqlWhere::operator = ( const CMySqlWhere & aC ) {
    ::memset( itsWhere, 0, sizeof( itsWhere ) );
    ::strcpy( itsWhere, aC.Where() );
    return *this;
}

// --------------------------------------------------------------
CMySqlWhere &   CMySqlWhere::operator = ( const char * aS ) {
    ::memset( itsWhere, 0, sizeof( itsWhere ) );
    if  ( aS ) {
        if  ( ::strncmp( aS, "WHERE ", 6 ) ) {
            ::strcpy( itsWhere, "WHERE " );
        }
        ::strcat( itsWhere, aS );
    }
    else {
        ::strcpy( itsWhere, "WHERE " );
    }
    return *this;
}

// --------------------------------------------------------------
// public:      Streamers
// --------------------------------------------------------------
CMySqlWhere &   CMySqlWhere::operator << ( const char * aS ) {
    ::strcat( itsWhere, aS );
    return *this;
}

CMySqlWhere &   CMySqlWhere::operator << ( const byte_tp aS ) {
    ::strcat( itsWhere, (const char *)aS );
    return *this;
}

CMySqlWhere &   CMySqlWhere::operator << ( dword_t aDw ) {
    ::sprintf( itsWhere + ::strlen( itsWhere ), "%u", (unsigned int)aDw );
    return *this;
}

CMySqlWhere &   CMySqlWhere::operator << ( word_t aW ) {
    ::sprintf( itsWhere + ::strlen( itsWhere ), "%u", (unsigned int)aW );
    return *this;
}

CMySqlWhere &   CMySqlWhere::operator << ( byte_t aB ) {
    ::sprintf( itsWhere + ::strlen( itsWhere ), "%c", aB );
    return *this;
}

CMySqlWhere &   CMySqlWhere::operator << ( double aF ) {
    ::sprintf( itsWhere + ::strlen( itsWhere ), "%f", aF );
    return *this;
}

CMySqlWhere &   CMySqlWhere::operator << ( bool aF ) {
    ::strcat( itsWhere, aF ? "1" : "0" );
    return *this;
}

CMySqlWhere &   CMySqlWhere::operator << ( time_t aT ) {
    struct  tm  tms = *::gmtime( & aT );

    ::sprintf(  itsWhere + ::strlen( itsWhere ), "%d-", tms.tm_year + 1900 );

    if  ( tms.tm_mon > 8 )      ::sprintf( itsWhere + ::strlen( itsWhere ), "%d-",  tms.tm_mon + 1 );
    else                        ::sprintf( itsWhere + ::strlen( itsWhere ), "0%d-", tms.tm_mon + 1 );

    if  ( tms.tm_mday > 9 )     ::sprintf( itsWhere + ::strlen( itsWhere ), "%d ",  tms.tm_mday );
    else                        ::sprintf( itsWhere + ::strlen( itsWhere ), "0%d ", tms.tm_mday );

    if  ( tms.tm_hour > 9 )     ::sprintf( itsWhere + ::strlen( itsWhere ), "%d:",  tms.tm_hour );
    else                        ::sprintf( itsWhere + ::strlen( itsWhere ), "0%d:", tms.tm_hour );

    if  ( tms.tm_min > 9 )      ::sprintf( itsWhere + ::strlen( itsWhere ), "%d:",  tms.tm_min );
    else                        ::sprintf( itsWhere + ::strlen( itsWhere ), "0%d:", tms.tm_min );

    if  ( tms.tm_sec > 9 )      ::sprintf( itsWhere + ::strlen( itsWhere ), "%d",   tms.tm_sec );
    else                        ::sprintf( itsWhere + ::strlen( itsWhere ), "0%d",  tms.tm_sec );

    return *this;
}

// --------------------------------------------------------------
// EOF: CMySqlWhere.cxx
// --------------------------------------------------------------
