// --------------------------------------------------------------------
// CTableDcac.cxx
// Whatis:  dcac table access
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableDcac.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,   4, "dcac_idnt",       false },    // 0
    {   0,  data_struct_type_ascz,  201, "dcac_file",       false },    // 1
    {   0,  data_struct_type_ascz,  201, "dcac_link",       false },    // 2
    {   0,  data_struct_type_ascz,  201, "dcac_csum",       false },    // 3
    {   0,  data_struct_type_ascz,  101, "dcac_addr",       false },    // 4
    {   0,  data_struct_type_time,    4, "dcac_ltim",       false },    // 5
    {   0,  data_struct_type_dword,   4, "dcac_prog",       false },    // 6
    {   0,  data_struct_type_dword,   4, "dcac_size",       false },    // 7
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableDcac::CTableDcac    ( ) : CMySqlData( __rules, sizeof( data_dcac_t ) ) {
    if  ( ! __initialized ) {
        data_dcac_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, dcac_idnt, dcac_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, dcac_idnt, dcac_file );
	    __rules[i++].offset = DATA_OFFSET( model, dcac_idnt, dcac_link );
	    __rules[i++].offset = DATA_OFFSET( model, dcac_idnt, dcac_csum );
	    __rules[i++].offset = DATA_OFFSET( model, dcac_idnt, dcac_addr );
	    __rules[i++].offset = DATA_OFFSET( model, dcac_idnt, dcac_ltim );
	    __rules[i++].offset = DATA_OFFSET( model, dcac_idnt, dcac_prog );
	    __rules[i++].offset = DATA_OFFSET( model, dcac_idnt, dcac_size );
	    __initialized = true;
    }
}
CTableDcac::~CTableDcac   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableDcac::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "dcac", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_dcac_tl   CTableDcac::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_dcac_tl   list;
    data_dcac_th   result;

    result = (data_dcac_th)CMySqlData::MakeSelect( aDb, "dcac", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableDcac::Insert (   CMySqlConnect_t &   aDb,
                                           data_dcac_tp   aR ) {
    data_dcac_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "dcac", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableDcac::Update (   CMySqlConnect_t &   aDb,
                                           data_dcac_tp   aR ) {
    CMySqlWhere         where;
    data_dcac_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "dcac_idnt=" << aR->dcac_idnt;
    CMySqlData::MakeUpdate( aDb, "dcac", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableDcac::Delete (   CMySqlConnect_t &   aDb,
                                                data_dcac_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
	    where << "dcac_idnt=" << aR->dcac_idnt;
        CMySqlData::MakeDelete( aDb, "dcac", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "dcac" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableDcac::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "dcac", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableDcac::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// public:      Return next available identifier
// --------------------------------------------------------------------
dword_t						CTableDcac::NextIdnt  ( CMySqlConnect_t &   aDb ) {
    return	CMySqlData::Maximum( aDb, "dcac", "dcac_idnt" ) + 1;
}

// --------------------------------------------------------------------
// EOF: CTableDcac.cxx
// --------------------------------------------------------------------
