// --------------------------------------------------------------------
// CTableFile.cxx
// Whatis:  file table access
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableFile.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,   4, "file_idnt",       false },    // 0
    {   0,  data_struct_type_dword,   4, "file_auth",       false },    // 1
    {   0,  data_struct_type_dword,   4, "file_type",       false },    // 2
    {   0,  data_struct_type_ascz,    9, "file_typ1",       false },    // 3
    {   0,  data_struct_type_ascz,   65, "file_ctgr",       false },    // 4
    {   0,  data_struct_type_ascz,   17, "file_typ2",       false },    // 5
    {   0,  data_struct_type_ascz,  101, "file_name",       false },    // 6
    {   0,  data_struct_type_ascz,   33, "file_suff",       false },    // 7
    {   0,  data_struct_type_dword,   4, "file_vers",       false },    // 8
    {   0,  data_struct_type_ascz,  101, "file_csum",       false },    // 9
    {   0,  data_struct_type_time,    4, "file_ctim",       false },    // 10
    {   0,  data_struct_type_time,    4, "file_mtim",       false },    // 11
    {   0,  data_struct_type_time,    4, "file_atim",       false },    // 12
    {   0,  data_struct_type_time,    4, "file_ltim",       false },    // 13
    {   0,  data_struct_type_dword,   4, "file_size",       false },    // 14
    {   0,  data_struct_type_dword,   4, "file_psiz",       false },    // 15
    {   0,  data_struct_type_dword,   4, "file_lcnt",       false },    // 16
    {   0,  data_struct_type_dword,   4, "file_flag",       false },    // 17
    {   0,  data_struct_type_ascz,   65, "file_data",       false },    // 18
    {   0,  data_struct_type_dword,   4, "file_user",       false },    // 19
    {   0,  data_struct_type_dword,   4, "file_rate",       false },    // 20
    {   0,  data_struct_type_dword,   4, "file_rat0",       false },    // 21
    {   0,  data_struct_type_dword,   4, "file_rat1",       false },    // 22
    {   0,  data_struct_type_dword,   4, "file_rat2",       false },    // 23
    {   0,  data_struct_type_dword,   4, "file_dlct",       false },    // 24
    {   0,  data_struct_type_dword,   4, "file_plct",       false },    // 25
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableFile::CTableFile    ( ) : CMySqlData( __rules, sizeof( data_file_t ) ) {
    if  ( ! __initialized ) {
        data_file_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_auth );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_type );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_typ1 );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_ctgr );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_typ2 );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_name );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_suff );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_vers );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_csum );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_ctim );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_mtim );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_atim );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_ltim );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_size );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_psiz );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_lcnt );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_flag );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_data );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_user );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_rate );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_rat0 );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_rat1 );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_rat2 );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_dlct );
	    __rules[i++].offset = DATA_OFFSET( model, file_idnt, file_plct );
	    __initialized = true;
    }
}
CTableFile::~CTableFile   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableFile::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "file", aDist, aWhere );
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_file_tl   CTableFile::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_file_tl   list;
    data_file_th   result;

    result = (data_file_th)CMySqlData::MakeSelect( aDb, "file", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableFile::Insert (   CMySqlConnect_t &   aDb,
                                           data_file_tp   aR ) {
    data_file_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "file", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableFile::Update (   CMySqlConnect_t &   aDb,
                                           data_file_tp   aR ) {
    CMySqlWhere         where;
    data_file_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "file_idnt=" << aR->file_idnt;
    CMySqlData::MakeUpdate( aDb, "file", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableFile::Delete (   CMySqlConnect_t &   aDb,
                                                data_file_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
	    where << "file_idnt=" << aR->file_idnt;
        CMySqlData::MakeDelete( aDb, "file", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "file" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableFile::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "file", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableFile::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// public:      Return next available identifier
// --------------------------------------------------------------------
dword_t						CTableFile::NextIdnt  ( CMySqlConnect_t &   aDb ) {
    return	CMySqlData::Maximum( aDb, "file", "file_idnt" ) + 1;
}

// --------------------------------------------------------------------
// EOF: CTableFile.cxx
// --------------------------------------------------------------------
