// --------------------------------------------------------------------
// CTableFsrv.cxx
// Whatis:  fsrv table access
// Fsrvors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableFsrv.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,    4, "fsrv_file",       false },    // 0
    {   0,  data_struct_type_ascz,    65, "fsrv_addr",       false },    // 1
    {   0,  data_struct_type_dword,    4, "fsrv_quep",       false },    // 2
    {   0,  data_struct_type_dword,    4, "fsrv_pcur",       false },    // 3
    {   0,  data_struct_type_dword,    4, "fsrv_pmax",       false },    // 4
    {   0,  data_struct_type_time,     4, "fsrv_time",       false },    // 5
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableFsrv::CTableFsrv    ( ) : CMySqlData( __rules, sizeof( data_fsrv_t ) ) {
    if  ( ! __initialized ) {
        data_fsrv_t	model;
		int			i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, fsrv_file, fsrv_file );
	    __rules[i++].offset = DATA_OFFSET( model, fsrv_file, fsrv_addr );
	    __rules[i++].offset = DATA_OFFSET( model, fsrv_file, fsrv_quep );
	    __rules[i++].offset = DATA_OFFSET( model, fsrv_file, fsrv_pcur );
	    __rules[i++].offset = DATA_OFFSET( model, fsrv_file, fsrv_pmax );
	    __rules[i++].offset = DATA_OFFSET( model, fsrv_file, fsrv_time );
	    __initialized = true;
    }
}

CTableFsrv::~CTableFsrv   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableFsrv::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "fsrv", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_fsrv_tl   CTableFsrv::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_fsrv_tl   list;
    data_fsrv_th   result;

    result = (data_fsrv_th)CMySqlData::MakeSelect( aDb, "fsrv", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableFsrv::Insert (   CMySqlConnect_t &   aDb,
                                           data_fsrv_tp   aR ) {
    data_fsrv_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "fsrv", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableFsrv::Update (   CMySqlConnect_t &   aDb,
                                           data_fsrv_tp   aR ) {
    CMySqlWhere         where;
    CMySqlQuote         q;
    data_fsrv_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "fsrv_file="  << aR->fsrv_file << " and ";
	where << "fsrv_addr='" << q.Quote( aR->fsrv_addr ) << "' and ";
    where << "fsrv_quep="  << aR->fsrv_quep;
    CMySqlData::MakeUpdate( aDb, "fsrv", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableFsrv::Delete (   CMySqlConnect_t &   aDb,
                                                data_fsrv_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
        CMySqlQuote q;
	    where << "fsrv_file="  << aR->fsrv_file << " and ";
		where << "fsrv_addr='" << q.Quote( aR->fsrv_addr ) << "' and ";
	    where << "fsrv_quep="  << aR->fsrv_quep;
        CMySqlData::MakeDelete( aDb, "fsrv", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "fsrv" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableFsrv::Delete (   CMySqlConnect_t &   aDb,
                                           const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "fsrv", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableFsrv::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTableFsrv.cxx
// --------------------------------------------------------------------
