// --------------------------------------------------------------------
// CTableMenu.cxx
// Whatis:  menu table access
// Menuors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableMenu.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_ascz,   33, "menu_name",       false },    // 0
    {   0,  data_struct_type_dword,   4, "menu_ordr",       false },    // 1
    {   0,  data_struct_type_ascz,   33, "menu_pnam",       false },    // 2
    {   0,  data_struct_type_dword,   4, "menu_pord",       false },    // 3
    {   0,  data_struct_type_ascz,  101, "menu_text",       false },    // 4
    {   0,  data_struct_type_ascz,   33, "menu_onst",       false },    // 5
    {   0,  data_struct_type_ascz,   33, "menu_ofst",       false },    // 6
    {   0,  data_struct_type_ascz,  251, "menu_link",       false },    // 7
    {   0,  data_struct_type_ascz,  251, "menu_titl",       false },    // 8
    {   0,  data_struct_type_ascz,   33, "menu_ttst",       false },    // 9
    {   0,  data_struct_type_ascz,  251, "menu_brfn",       false },    // 10
    {   0,  data_struct_type_ascz,   33, "menu_brst",       false },    // 11
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableMenu::CTableMenu    ( ) : CMySqlData( __rules, sizeof( data_menu_t ) ) {
    if  ( ! __initialized ) {
        data_menu_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, menu_name, menu_name );
	    __rules[i++].offset = DATA_OFFSET( model, menu_name, menu_ordr );
	    __rules[i++].offset = DATA_OFFSET( model, menu_name, menu_pnam );
	    __rules[i++].offset = DATA_OFFSET( model, menu_name, menu_pord );
	    __rules[i++].offset = DATA_OFFSET( model, menu_name, menu_text );
	    __rules[i++].offset = DATA_OFFSET( model, menu_name, menu_onst );
	    __rules[i++].offset = DATA_OFFSET( model, menu_name, menu_ofst );
	    __rules[i++].offset = DATA_OFFSET( model, menu_name, menu_link );
	    __rules[i++].offset = DATA_OFFSET( model, menu_name, menu_titl );
	    __rules[i++].offset = DATA_OFFSET( model, menu_name, menu_ttst );
	    __rules[i++].offset = DATA_OFFSET( model, menu_name, menu_brfn );
	    __rules[i++].offset = DATA_OFFSET( model, menu_name, menu_brst );
	    __initialized = true;
    }
}

CTableMenu::~CTableMenu   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableMenu::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "menu", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_menu_tl   CTableMenu::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_menu_tl   list;
    data_menu_th   result;

    result = (data_menu_th)CMySqlData::MakeSelect( aDb, "menu", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableMenu::Insert (   CMySqlConnect_t &   aDb,
                                           data_menu_tp   aR ) {
    data_menu_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "menu", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableMenu::Update (   CMySqlConnect_t &   aDb,
                                           data_menu_tp   aR ) {
    CMySqlWhere         where;
    CMySqlQuote         q;
    data_menu_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "menu_name='" << q.Quote( aR->menu_name ) << "' and ";
    where << "menu_ordr="  << aR->menu_ordr;
    CMySqlData::MakeUpdate( aDb, "menu", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableMenu::Delete (   CMySqlConnect_t &   aDb,
                                                data_menu_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
        CMySqlQuote q;
	    where << "menu_name='" << q.Quote( aR->menu_name ) << "' and ";
	    where << "menu_ordr="  << aR->menu_ordr;
        CMySqlData::MakeDelete( aDb, "menu", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "menu" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableMenu::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "menu", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableMenu::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTableMenu.cxx
// --------------------------------------------------------------------
