// --------------------------------------------------------------------
// CTablePack.cxx
// Whatis:  pack table access
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTablePack.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,   4, "pack_idnt",       false },    // 0
    {   0,  data_struct_type_ascz,  101, "pack_name",       false },    // 1
    {   0,  data_struct_type_ascz,  101, "pack_file",       false },    // 2
    {   0,  data_struct_type_dword,   4, "pack_user",       false },    // 3
    {   0,  data_struct_type_dword,   4, "pack_text",       false },    // 4
    {   0,  data_struct_type_dword,   4, "pack_pict",       false },    // 5
    {   0,  data_struct_type_time,    4, "pack_atim",       false },    // 6
    {   0,  data_struct_type_time,    4, "pack_mtim",       false },    // 7
    {   0,  data_struct_type_time,    4, "pack_ltim",       false },    // 8
    {   0,  data_struct_type_dword,   4, "pack_flag",       false },    // 9
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTablePack::CTablePack    ( ) : CMySqlData( __rules, sizeof( data_pack_t ) ) {
    if  ( ! __initialized ) {
        data_pack_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, pack_idnt, pack_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, pack_idnt, pack_name );
	    __rules[i++].offset = DATA_OFFSET( model, pack_idnt, pack_file );
	    __rules[i++].offset = DATA_OFFSET( model, pack_idnt, pack_user );
	    __rules[i++].offset = DATA_OFFSET( model, pack_idnt, pack_text );
	    __rules[i++].offset = DATA_OFFSET( model, pack_idnt, pack_pict );
	    __rules[i++].offset = DATA_OFFSET( model, pack_idnt, pack_atim );
	    __rules[i++].offset = DATA_OFFSET( model, pack_idnt, pack_mtim );
	    __rules[i++].offset = DATA_OFFSET( model, pack_idnt, pack_ltim );
	    __rules[i++].offset = DATA_OFFSET( model, pack_idnt, pack_flag );
	    __initialized = true;
    }
}
CTablePack::~CTablePack   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTablePack::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "pack", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_pack_tl   CTablePack::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_pack_tl   list;
    data_pack_th   result;

    result = (data_pack_th)CMySqlData::MakeSelect( aDb, "pack", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTablePack::Insert (   CMySqlConnect_t &   aDb,
                                           data_pack_tp   aR ) {
    data_pack_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "pack", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTablePack::Update (   CMySqlConnect_t &   aDb,
                                           data_pack_tp   aR ) {
    CMySqlWhere         where;
    data_pack_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "pack_idnt=" << aR->pack_idnt;
    CMySqlData::MakeUpdate( aDb, "pack", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTablePack::Delete (   CMySqlConnect_t &   aDb,
                                                data_pack_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
	    where << "pack_idnt=" << aR->pack_idnt;
        CMySqlData::MakeDelete( aDb, "pack", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "pack" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTablePack::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "pack", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTablePack::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// public:      Return next available identifier
// --------------------------------------------------------------------
dword_t						CTablePack::NextIdnt  ( CMySqlConnect_t &   aDb ) {
    return	CMySqlData::Maximum( aDb, "pack", "pack_idnt" ) + 1;
}

// --------------------------------------------------------------------
// EOF: CTablePack.cxx
// --------------------------------------------------------------------
