// --------------------------------------------------------------------
// CTablePref.cxx
// Whatis:  pref table access
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTablePref.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_ascz,   33, "pref_name",       false },    // 0
    {   0,  data_struct_type_ascz,  201, "pref_valu",       false },    // 1
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTablePref::CTablePref    ( ) : CMySqlData( __rules, sizeof( data_pref_t ) ) {
    if  ( ! __initialized ) {
        data_pref_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, pref_name, pref_name );
	    __rules[i++].offset = DATA_OFFSET( model, pref_name, pref_valu );
	    __initialized = true;
    }
}
CTablePref::~CTablePref   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTablePref::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "pref", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_pref_tl   CTablePref::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_pref_tl   list;
    data_pref_th   result;

    result = (data_pref_th)CMySqlData::MakeSelect( aDb, "pref", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTablePref::Insert (   CMySqlConnect_t &   aDb,
                                           data_pref_tp   aR ) {
    data_pref_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "pref", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTablePref::Update (   CMySqlConnect_t &   aDb,
                                           data_pref_tp   aR ) {
    CMySqlWhere         where;
    CMySqlQuote         q;
    data_pref_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "pref_name='" << q.Quote( aR->pref_name ) << "'";
    CMySqlData::MakeUpdate( aDb, "pref", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTablePref::Delete (   CMySqlConnect_t &   aDb,
                                                data_pref_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
        CMySqlQuote q;
	    where << "pref_name='" << q.Quote( aR->pref_name ) << "'";
        CMySqlData::MakeDelete( aDb, "pref", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "pref" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTablePref::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "pref", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTablePref::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTablePref.cxx
// --------------------------------------------------------------------
