// --------------------------------------------------------------------
// CTableRule.cxx
// Whatis:  rule table access
// Ruleors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableRule.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs rule                    size name               crypt
    {   0,  data_struct_type_dword,   4, "rule_type",       false },    // 0
    {   0,  data_struct_type_ascz,   33, "rule_name",       false },    // 1
    {   0,  data_struct_type_ascz,  201, "rule_rule",       false },    // 2
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableRule::CTableRule    ( ) : CMySqlData( __rules, sizeof( data_rule_t ) ) {
    if  ( ! __initialized ) {
        data_rule_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, rule_type, rule_type );
	    __rules[i++].offset = DATA_OFFSET( model, rule_type, rule_name );
	    __rules[i++].offset = DATA_OFFSET( model, rule_type, rule_rule );
	    __initialized = true;
    }
}
CTableRule::~CTableRule   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableRule::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "rule", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_rule_tl   CTableRule::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_rule_tl   list;
    data_rule_th   result;

    result = (data_rule_th)CMySqlData::MakeSelect( aDb, "rule", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableRule::Insert (   CMySqlConnect_t &   aDb,
                                           data_rule_tp   aR ) {
    data_rule_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "rule", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableRule::Update (   CMySqlConnect_t &   aDb,
                                           data_rule_tp   aR ) {
    CMySqlWhere         where;
    CMySqlQuote         q;
    data_rule_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "rule_type="  << aR->rule_type << " and ";
    where << "rule_name='" << q.Quote( aR->rule_name ) << "'";
    CMySqlData::MakeUpdate( aDb, "rule", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableRule::Delete (   CMySqlConnect_t &   aDb,
                                                data_rule_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
        CMySqlQuote q;

	    where << "rule_type="  << aR->rule_type << " and ";
	    where << "rule_name='" << q.Quote( aR->rule_name ) << "'";
        CMySqlData::MakeDelete( aDb, "rule", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "rule" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableRule::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "rule", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableRule::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTableRule.cxx
// --------------------------------------------------------------------
