// --------------------------------------------------------------------
// CTableSess.cxx
// Whatis:  sess table access
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableSess.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,   4, "sess_idnt",       false },    // 0
    {   0,  data_struct_type_dword,   4, "sess_user",       false },    // 1
    {   0,  data_struct_type_dword,   4, "sess_time",       false },    // 2
    {   0,  data_struct_type_ascz,  101, "sess_pass",       false },    // 3
    {   0,  data_struct_type_ascz,  101, "sess_addr",       false },    // 4
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableSess::CTableSess    ( ) : CMySqlData( __rules, sizeof( data_sess_t ) ) {
    if  ( ! __initialized ) {
        data_sess_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, sess_idnt, sess_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, sess_idnt, sess_user );
	    __rules[i++].offset = DATA_OFFSET( model, sess_idnt, sess_time );
	    __rules[i++].offset = DATA_OFFSET( model, sess_idnt, sess_pass );
	    __rules[i++].offset = DATA_OFFSET( model, sess_idnt, sess_addr );
	    __initialized = true;
    }
}
CTableSess::~CTableSess   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableSess::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "sess", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_sess_tl   CTableSess::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_sess_tl   list;
    data_sess_th   result;

    result = (data_sess_th)CMySqlData::MakeSelect( aDb, "sess", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableSess::Insert (   CMySqlConnect_t &   aDb,
                                           data_sess_tp   aR ) {
    data_sess_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "sess", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableSess::Update (   CMySqlConnect_t &   aDb,
                                           data_sess_tp   aR ) {
    CMySqlWhere         where;
    data_sess_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "sess_idnt=" << aR->sess_idnt;
    CMySqlData::MakeUpdate( aDb, "sess", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableSess::Delete (   CMySqlConnect_t &   aDb,
                                                data_sess_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
	    where << "sess_idnt=" << aR->sess_idnt;
        CMySqlData::MakeDelete( aDb, "sess", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "sess" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableSess::Delete (   CMySqlConnect_t &   aDb,
                                           const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "sess", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableSess::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// public:      Return next available identifier
// --------------------------------------------------------------------
dword_t						CTableSess::NextIdnt  ( CMySqlConnect_t &   aDb ) {
    return	CMySqlData::Maximum( aDb, "sess", "sess_idnt" ) + 1;
}

// --------------------------------------------------------------------
// EOF: CTableSess.cxx
// --------------------------------------------------------------------
