// --------------------------------------------------------------------
// CTableSrvr.cxx
// Whatis:  srvr table access
// Srvrors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableSrvr.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_ascz,   65, "srvr_addr",       false },    // 0
    {   0,  data_struct_type_dword,   4, "srvr_port",       false },    // 1
    {   0,  data_struct_type_dword,   4, "srvr_quep",       false },    // 2
    {   0,  data_struct_type_ascz,    9, "srvr_type",       false },    // 3
    {   0,  data_struct_type_ascz,  201, "srvr_name",       false },    // 4
    {   0,  data_struct_type_ascz,   65, "srvr_gmap",       false },    // 5
    {   0,  data_struct_type_ascz,  201, "srvr_gttl",       false },    // 6
    {   0,  data_struct_type_ascz,   33, "srvr_gtyp",       false },    // 7
    {   0,  data_struct_type_dword,   4, "srvr_pcur",       false },    // 8
    {   0,  data_struct_type_dword,   4, "srvr_pmax",       false },    // 9
    {   0,  data_struct_type_time,    4, "srvr_time",       false },    // 10
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableSrvr::CTableSrvr    ( ) : CMySqlData( __rules, sizeof( data_srvr_t ) ) {
    if  ( ! __initialized ) {
        data_srvr_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, srvr_addr, srvr_addr );
	    __rules[i++].offset = DATA_OFFSET( model, srvr_addr, srvr_port );
	    __rules[i++].offset = DATA_OFFSET( model, srvr_addr, srvr_quep );
	    __rules[i++].offset = DATA_OFFSET( model, srvr_addr, srvr_type );
	    __rules[i++].offset = DATA_OFFSET( model, srvr_addr, srvr_name );
	    __rules[i++].offset = DATA_OFFSET( model, srvr_addr, srvr_gmap );
	    __rules[i++].offset = DATA_OFFSET( model, srvr_addr, srvr_gttl );
	    __rules[i++].offset = DATA_OFFSET( model, srvr_addr, srvr_gtyp );
	    __rules[i++].offset = DATA_OFFSET( model, srvr_addr, srvr_pcur );
	    __rules[i++].offset = DATA_OFFSET( model, srvr_addr, srvr_pmax );
	    __rules[i++].offset = DATA_OFFSET( model, srvr_addr, srvr_time );
	    __initialized = true;
    }
}

CTableSrvr::~CTableSrvr   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableSrvr::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "srvr", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_srvr_tl   CTableSrvr::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_srvr_tl   list;
    data_srvr_th   result;

    result = (data_srvr_th)CMySqlData::MakeSelect( aDb, "srvr", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableSrvr::Insert (   CMySqlConnect_t &   aDb,
                                           data_srvr_tp   aR ) {
    data_srvr_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "srvr", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableSrvr::Update (   CMySqlConnect_t &   aDb,
                                           data_srvr_tp   aR ) {
    CMySqlWhere         where;
    CMySqlQuote         q;
    data_srvr_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "srvr_addr='" << q.Quote( aR->srvr_addr ) << "' and ";
	where << "srvr_quep=" << aR->srvr_quep;
    CMySqlData::MakeUpdate( aDb, "srvr", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableSrvr::Delete (   CMySqlConnect_t &   aDb,
                                                data_srvr_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
        CMySqlQuote q;
	    where << "srvr_addr='" << q.Quote( aR->srvr_addr ) << "' and ";
		where << "srvr_quep=" << aR->srvr_quep;
        CMySqlData::MakeDelete( aDb, "srvr", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "srvr" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableSrvr::Delete (   CMySqlConnect_t &   aDb,
                                           const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "srvr", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableSrvr::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTableSrvr.cxx
// --------------------------------------------------------------------
