// --------------------------------------------------------------------
// CTableType.cxx
// Whatis:  type table access
// Typeors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableType.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,   4, "type_idnt",       false },    // 0
    {   0,  data_struct_type_ascz,   65, "type_ctgr",       false },    // 1
    {   0,  data_struct_type_ascz,  101, "type_name",       false },    // 2
    {   0,  data_struct_type_dword,   4, "type_apri",       false },    // 3
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableType::CTableType    ( ) : CMySqlData( __rules, sizeof( data_type_t ) ) {
    if  ( ! __initialized ) {
        data_type_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, type_idnt, type_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, type_idnt, type_ctgr );
	    __rules[i++].offset = DATA_OFFSET( model, type_idnt, type_name );
	    __rules[i++].offset = DATA_OFFSET( model, type_idnt, type_apri );
	    __initialized = true;
    }
}
CTableType::~CTableType   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableType::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "type", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_type_tl   CTableType::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_type_tl   list;
    data_type_th   result;

    result = (data_type_th)CMySqlData::MakeSelect( aDb, "type", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableType::Insert (   CMySqlConnect_t &   aDb,
                                           data_type_tp   aR ) {
    data_type_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "type", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableType::Update (   CMySqlConnect_t &   aDb,
                                           data_type_tp   aR ) {
    CMySqlWhere         where;
    data_type_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "type_idnt=" << aR->type_idnt;
    CMySqlData::MakeUpdate( aDb, "type", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableType::Delete (   CMySqlConnect_t &   aDb,
                                                data_type_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
	    where << "type_idnt=" << aR->type_idnt;
        CMySqlData::MakeDelete( aDb, "type", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "type" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableType::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "type", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableType::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// public:      Return next available identifier
// --------------------------------------------------------------------
dword_t						CTableType::NextIdnt  ( CMySqlConnect_t &   aDb ) {
    return	CMySqlData::Maximum( aDb, "type", "type_idnt" ) + 1;
}

// --------------------------------------------------------------------
// EOF: CTableType.cxx
// --------------------------------------------------------------------
