// --------------------------------------------------------------------
// CTableUrll.cxx
// Whatis:  urll table access
// Urllors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableUrll.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_ascz,  101, "urll_name",       false },    // 0
    {   0,  data_struct_type_ascz,   33, "urll_type",       false },    // 1
    {   0,  data_struct_type_ascz,  201, "urll_addr",       false },    // 2
    {   0,  data_struct_type_ascz,    9, "urll_ftyp",       false },    // 3
    {   0,  data_struct_type_dword,   4, "urll_user",       false },    // 4
    {   0,  data_struct_type_ascz,  251, "urll_text",       false },    // 5
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableUrll::CTableUrll    ( ) : CMySqlData( __rules, sizeof( data_urll_t ) ) {
    if  ( ! __initialized ) {
        data_urll_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, urll_name, urll_name );
	    __rules[i++].offset = DATA_OFFSET( model, urll_name, urll_type );
	    __rules[i++].offset = DATA_OFFSET( model, urll_name, urll_addr );
	    __rules[i++].offset = DATA_OFFSET( model, urll_name, urll_ftyp );
	    __rules[i++].offset = DATA_OFFSET( model, urll_name, urll_user );
	    __rules[i++].offset = DATA_OFFSET( model, urll_name, urll_text );
	    __initialized = true;
    }
}
CTableUrll::~CTableUrll   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableUrll::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "urll", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_urll_tl   CTableUrll::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_urll_tl   list;
    data_urll_th   result;

    result = (data_urll_th)CMySqlData::MakeSelect( aDb, "urll", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableUrll::Insert (   CMySqlConnect_t &   aDb,
                                           data_urll_tp   aR ) {
    data_urll_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "urll", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableUrll::Update (   CMySqlConnect_t &   aDb,
                                           data_urll_tp   aR ) {
    CMySqlWhere         where;
    CMySqlQuote         q;
    data_urll_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "urll_name='" << q.Quote( aR->urll_name ) << "' and ";
    where << "urll_type='" << q.Quote( aR->urll_type ) << "' and ";
    where << "urll_addr='" << q.Quote( aR->urll_addr ) << "'";
    CMySqlData::MakeUpdate( aDb, "urll", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableUrll::Delete (   CMySqlConnect_t &   aDb,
                                                data_urll_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
        CMySqlQuote q;
	    where << "urll_name='" << q.Quote( aR->urll_name ) << "' and ";
	    where << "urll_type='" << q.Quote( aR->urll_type ) << "' and ";
	    where << "urll_addr='" << q.Quote( aR->urll_addr ) << "'";
        CMySqlData::MakeDelete( aDb, "urll", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "urll" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableUrll::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "urll", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableUrll::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTableUrll.cxx
// --------------------------------------------------------------------
