// --------------------------------------------------------------------
// CTableUser.cxx
// Whatis:  user table access
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableUser.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,   4, "user_idnt",       false },    // 0
    {   0,  data_struct_type_ascz,  101, "user_name",       false },    // 1
    {   0,  data_struct_type_ascz,  101, "user_logn",       false },    // 2
    {   0,  data_struct_type_ascz,  101, "user_pass",       true },    	// 3
    {   0,  data_struct_type_dword,   4, "user_text",       false },    // 4
    {   0,  data_struct_type_dword,   4, "user_pict",       false },    // 5
    {   0,  data_struct_type_time,    4, "user_atim",       false },    // 6
    {   0,  data_struct_type_time,    4, "user_ltim",       false },    // 7
    {   0,  data_struct_type_dword,   4, "user_flag",       false },    // 8
    {   0,  data_struct_type_ascz,  101, "user_cook",       false },   	// 9
    {   0,  data_struct_type_time,    4, "user_whtm",       false },    // 10
    {   0,  data_struct_type_ascz,  251, "user_colo",       false },    // 11
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableUser::CTableUser    ( ) : CMySqlData( __rules, sizeof( data_user_t ) ) {
    if  ( ! __initialized ) {
        data_user_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, user_idnt, user_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, user_idnt, user_name );
	    __rules[i++].offset = DATA_OFFSET( model, user_idnt, user_logn );
	    __rules[i++].offset = DATA_OFFSET( model, user_idnt, user_pass );
	    __rules[i++].offset = DATA_OFFSET( model, user_idnt, user_text );
	    __rules[i++].offset = DATA_OFFSET( model, user_idnt, user_pict );
	    __rules[i++].offset = DATA_OFFSET( model, user_idnt, user_atim );
	    __rules[i++].offset = DATA_OFFSET( model, user_idnt, user_ltim );
	    __rules[i++].offset = DATA_OFFSET( model, user_idnt, user_flag );
	    __rules[i++].offset = DATA_OFFSET( model, user_idnt, user_cook );
	    __rules[i++].offset = DATA_OFFSET( model, user_idnt, user_whtm );
	    __rules[i++].offset = DATA_OFFSET( model, user_idnt, user_colo );
	    __initialized = true;
    }
}

CTableUser::~CTableUser   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableUser::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "user", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_user_tl   CTableUser::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_user_tl   list;
    data_user_th   result;

    result = (data_user_th)CMySqlData::MakeSelect( aDb, "user", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableUser::Insert (   CMySqlConnect_t &   aDb,
                                           data_user_tp   aR ) {
    data_user_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "user", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableUser::Update (   CMySqlConnect_t &   aDb,
                                           data_user_tp   aR ) {
    CMySqlWhere         where;
    data_user_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "user_idnt=" << aR->user_idnt;
    CMySqlData::MakeUpdate( aDb, "user", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableUser::Delete (   CMySqlConnect_t &   aDb,
                                                data_user_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
	    where << "user_idnt=" << aR->user_idnt;
        CMySqlData::MakeDelete( aDb, "user", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "user" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableUser::Delete (   CMySqlConnect_t &   aDb,
                                           const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "user", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableUser::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// public:      Return next available identifier
// --------------------------------------------------------------------
dword_t						CTableUser::NextIdnt  ( CMySqlConnect_t &   aDb ) {
    return	CMySqlData::Maximum( aDb, "user", "user_idnt" ) + 1;
}

// --------------------------------------------------------------------
// EOF: CTableUser.cxx
// --------------------------------------------------------------------
