// --------------------------------------------------------------------
// CTableVote.cxx
// Whatis:  vote table access
// Voteors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableVote.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_ascz,   41, "vote_idnt",       false },    // 0
    {   0,  data_struct_type_time,    4, "vote_time",       false },    // 1
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableVote::CTableVote    ( ) : CMySqlData( __rules, sizeof( data_vote_t ) ) {
    if  ( ! __initialized ) {
        data_vote_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, vote_idnt, vote_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, vote_idnt, vote_time );
	    __initialized = true;
    }
}

CTableVote::~CTableVote   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableVote::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "vote", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_vote_tl   CTableVote::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_vote_tl   list;
    data_vote_th   result;

    result = (data_vote_th)CMySqlData::MakeSelect( aDb, "vote", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableVote::Insert (   CMySqlConnect_t &   aDb,
                                           data_vote_tp   aR ) {
    data_vote_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "vote", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableVote::Update (   CMySqlConnect_t &   aDb,
                                           data_vote_tp   aR ) {
    CMySqlWhere         where;
    CMySqlQuote         q;
    data_vote_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "vote_idnt='"  << q.Quote( aR->vote_idnt ) << "'";
    CMySqlData::MakeUpdate( aDb, "vote", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableVote::Delete (   CMySqlConnect_t &   aDb,
                                                data_vote_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
        CMySqlQuote q;
	    where << "vote_idnt='"  << q.Quote( aR->vote_idnt ) << "'";
        CMySqlData::MakeDelete( aDb, "vote", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "vote" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableVote::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "vote", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableVote::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTableVote.cxx
// --------------------------------------------------------------------
