// --------------------------------------------------------------------
// CTableWurl.cxx
// Whatis:  wurl table access
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableWurl.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,   4, "wurl_idnt",       false },    // 0
    {   0,  data_struct_type_ascz,   33, "wurl_type",       false },    // 1
    {   0,  data_struct_type_ascz,  101, "wurl_titl",       false },    // 2
    {   0,  data_struct_type_ascz,  251, "wurl_desc",       false },    // 3
    {   0,  data_struct_type_ascz,  201, "wurl_link",       false },    // 4
    {   0,  data_struct_type_dword,   4, "wurl_rate",       false },    // 5
    {   0,  data_struct_type_time,    4, "wurl_ltim",       false },    // 6
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableWurl::CTableWurl    ( ) : CMySqlData( __rules, sizeof( data_wurl_t ) ) {
    if  ( ! __initialized ) {
        data_wurl_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, wurl_idnt, wurl_idnt );
	    __rules[i++].offset = DATA_OFFSET( model, wurl_idnt, wurl_type );
	    __rules[i++].offset = DATA_OFFSET( model, wurl_idnt, wurl_titl );
	    __rules[i++].offset = DATA_OFFSET( model, wurl_idnt, wurl_desc );
	    __rules[i++].offset = DATA_OFFSET( model, wurl_idnt, wurl_link );
	    __rules[i++].offset = DATA_OFFSET( model, wurl_idnt, wurl_rate );
	    __rules[i++].offset = DATA_OFFSET( model, wurl_idnt, wurl_ltim );
	    __initialized = true;
    }
}
CTableWurl::~CTableWurl   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableWurl::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "wurl", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_wurl_tl   CTableWurl::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_wurl_tl   list;
    data_wurl_th   result;

    result = (data_wurl_th)CMySqlData::MakeSelect( aDb, "wurl", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableWurl::Insert (   CMySqlConnect_t &   aDb,
                                           data_wurl_tp   aR ) {
    data_wurl_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "wurl", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableWurl::Update (   CMySqlConnect_t &   aDb,
                                           data_wurl_tp   aR ) {
    CMySqlWhere         where;
    data_wurl_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "wurl_idnt=" << aR->wurl_idnt;
    CMySqlData::MakeUpdate( aDb, "wurl", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableWurl::Delete (   CMySqlConnect_t &   aDb,
                                                data_wurl_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
	    where << "wurl_idnt=" << aR->wurl_idnt;
        CMySqlData::MakeDelete( aDb, "wurl", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "wurl" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableWurl::Delete (   CMySqlConnect_t &   aDb,
                                           const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "wurl", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableWurl::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// public:      Return next available identifier
// --------------------------------------------------------------------
dword_t						CTableWurl::NextIdnt  ( CMySqlConnect_t &   aDb ) {
    return	CMySqlData::Maximum( aDb, "wurl", "wurl_idnt" ) + 1;
}

// --------------------------------------------------------------------
// EOF: CTableWurl.cxx
// --------------------------------------------------------------------
