// --------------------------------------------------------------------
// CTableXref.cxx
// Whatis:  xref table access
// Xrefors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableXref.hxx"

// --------------------------------------------------------------------
// local:       Rules used with the undelying mechanism to transport data
// --------------------------------------------------------------------
static  bool    __initialized   = false;
static  data_struct_descriptor_t    __rules[] = {
    //  ofs type                    size name               crypt
    {   0,  data_struct_type_dword,   4, "xref_file",       false },    // 0
    {   0,  data_struct_type_dword,   4, "xref_expo",       false },    // 1
    {   0,  data_struct_type_ascz,   41, "xref_name",       false },    // 2
    {   0,  data_struct_type_dword,   4, "xref_refs",       false },    // 3
    {   0 }
};

// --------------------------------------------------------------------
// public:      Constructor and destructor
// --------------------------------------------------------------------
CTableXref::CTableXref    ( ) : CMySqlData( __rules, sizeof( data_xref_t ) ) {
    if  ( ! __initialized ) {
        data_xref_t   model;
		int	i = 0;
	    __rules[i++].offset = DATA_OFFSET( model, xref_file, xref_file );
	    __rules[i++].offset = DATA_OFFSET( model, xref_file, xref_expo );
	    __rules[i++].offset = DATA_OFFSET( model, xref_file, xref_name );
	    __rules[i++].offset = DATA_OFFSET( model, xref_file, xref_refs );
	    __initialized = true;
    }
}

CTableXref::~CTableXref   ( ) {
}

// --------------------------------------------------------------------
// public:      Count
// --------------------------------------------------------------------
dword_t       CTableXref::Count (  	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    return CMySqlData::MakeSelectCount( aDb, "xref", aDist, aWhere );    
}

// --------------------------------------------------------------------
// public:      Select
// --------------------------------------------------------------------
data_xref_tl   CTableXref::Select (	CMySqlConnect_t &   aDb,
                                    const char *        aWhere,
                                    bool				aDist ) {
    data_xref_tl   list;
    data_xref_th   result;

    result = (data_xref_th)CMySqlData::MakeSelect( aDb, "xref", aDist, aWhere );
    for ( int i = 0; result[i]; i++ )   list.push_back( *(result[i]) );
    CMySqlData::Destroy( (void **)result );

    return  list;
}

// --------------------------------------------------------------------
// public:      Insert
// --------------------------------------------------------------------
void                CTableXref::Insert (   CMySqlConnect_t &   aDb,
                                           data_xref_tp   aR ) {
    data_xref_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    CMySqlData::MakeInsert( aDb, "xref", (const void **)data );
}

// --------------------------------------------------------------------
// public:      Update
// --------------------------------------------------------------------
void                CTableXref::Update (   CMySqlConnect_t &   aDb,
                                           data_xref_tp   aR ) {
    CMySqlWhere         where;
    CMySqlQuote         q;
    data_xref_tp   data[2];
    data[0] = aR;
    data[1] = NULL;
    
    where << "xref_file="  << aR->xref_file << " and ";
    where << "xref_expo="  << aR->xref_expo << " and ";
    where << "xref_name='" << q.Quote( aR->xref_name ) << "'";
    CMySqlData::MakeUpdate( aDb, "xref", where, (const void **)data );
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableXref::Delete (   CMySqlConnect_t &   aDb,
                                                data_xref_tp   aR ) {
    if  ( aR ) {
        CMySqlWhere where;
        CMySqlQuote q;
	    where << "xref_file="  << aR->xref_file << " and ";
	    where << "xref_expo="  << aR->xref_expo << " and ";
	    where << "xref_name='" << q.Quote( aR->xref_name ) << "'";
        CMySqlData::MakeDelete( aDb, "xref", where.Where() );
    }
    else {
        CMySqlData::MakeDelete( aDb, "xref" );
    }
}

// --------------------------------------------------------------------
// public:      Delete
// --------------------------------------------------------------------
void                CTableXref::Delete (   CMySqlConnect_t &   aDb,
                                                const char *        aWhere ) {
    CMySqlData::MakeDelete( aDb, "xref", aWhere );
}

// --------------------------------------------------------------------
// public:      Return the table layout descriptor
// --------------------------------------------------------------------
data_struct_descriptor_tp   CTableXref::Layout  ( void ) const {
    return  __rules;
}

// --------------------------------------------------------------------
// EOF: CTableXref.cxx
// --------------------------------------------------------------------
