// --------------------------------------------------------------------
// CDxt.cpp
// Whatis:  The DXT Texture library interface
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 11-NOV-2003     Created this source
// --------------------------------------------------------------------
#include	"CDxt.hxx"

// --------------------------------------------------------------------
CDxt::CDxt	() {
	CDxt::Cleanup();
}

// --------------------------------------------------------------------
CDxt::~CDxt	() {
	CDxt::Free();
}

// --------------------------------------------------------------------
bool	CDxt::IsPower2	( unsigned int aV ) const {
	if	( aV < 1 )		return false;
    if	( aV == 1 )		return true;
    if	( aV & (aV-1) )	return false;
    return true;
}

// --------------------------------------------------------------------
const CompressionOptions *	CDxt::OptionsC( void ) const {
	return	&itsOptions;
}

// --------------------------------------------------------------------
CompressionOptions *	CDxt::Options ( void ) {
	return	&itsOptions;
}

// --------------------------------------------------------------------
void	CDxt::Options ( const CompressionOptions * aO  ) {
	::memcpy( &itsOptions, aO, sizeof( itsOptions ) );
}

// --------------------------------------------------------------------
void	CDxt::Free		( void ) {
	CDxt::Cleanup();
}

// --------------------------------------------------------------------
void	CDxt::Cleanup	( void ) {
	itsOptions.bRescaleImage = RESCALE_NONE;
	itsOptions.scaleX = 1.0;
	itsOptions.scaleY = 1.0;
	itsOptions.bMipMapsInImage = false;
	itsOptions.MipMapType = dGenerateMipMaps;
	itsOptions.SpecifiedMipMaps = 0;
	itsOptions.MIPFilterType = dMIPFilterTriangle;
	itsOptions.bBinaryAlpha = false;
	itsOptions.bNormalizeMIPMaps = false;
	itsOptions.bDuDvMap= false;
	itsOptions.bAlphaBorder= false;
	itsOptions.bBorder= false;
	itsOptions.BorderColor.u = 0;
	itsOptions.bFadeColor = false;
	itsOptions.bFadeAlpha= false;
	itsOptions.FadeToColor.u = 0;
	itsOptions.FadeToAlpha = 0;
	itsOptions.FadeToDelay = 0;
	itsOptions.FadeAmount = 0;
	itsOptions.BinaryAlphaThreshold = 128;
	itsOptions.bDitherColor = false;
	itsOptions.bDitherEachMIPLevel = false;
	itsOptions.bGreyScale = false;
	itsOptions.bQuickCompress = false;
	itsOptions.bForceDXT1FourColors = false;
	itsOptions.bSharpenEachMIPLevel = false;
	itsOptions.SharpenEdgeRadius = 2;
	itsOptions.SharpenLambda = 10.0f;
	itsOptions.SharpenMu = 0.01f;
	itsOptions.SharpenTheta =  0.75;
	itsOptions.bSharpenUseTwoComponents = false;
	itsOptions.bSharpenNonMaximalSuppression = false;
	itsOptions.bSharpenSharpBlur = false;
	itsOptions.bSharpenFlavor2 = false;
	itsOptions.FilterGamma = 2.2f;
	itsOptions.FilterBlur = 1.0f;
	itsOptions.FilterWidth = 10.0f;
	itsOptions.bOverrideFilterWidth = false;
	itsOptions.TextureType = dTextureType2D;
	itsOptions.TextureFormat = dDXT1;
	itsOptions.bSwapRGB = false;
}

// --------------------------------------------------------------------
// EOF: CDxt.hxx
// --------------------------------------------------------------------
