// --------------------------------------------------------------------
// CFtp.hxx
// Whatis:  The FTP abstract
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 11-NOV-2003     Created this source
// --------------------------------------------------------------------
#ifndef     CFtp_hxx
#define     CFtp_hxx

#include	"CFtpEngine.hxx"
#include	"CFtpFile.hxx"
#include	"CCpuMutex.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------
// States of this thread
// --------------------------------------------------------------
typedef	enum {
	ftp_state_offline	= 0,	// Basic idle state
	ftp_state_online	= 1,	// Online idle state (logged in)

    ftp_state_login		= 100,	// Active state - logging in
    ftp_state_logout	= 101,	// Active state - logging out
    ftp_state_cwd		= 102,	// Active state - setting cwd
    ftp_state_upload	= 103,	// Active state - uploading file
    ftp_state_download	= 104,	// Active state - downloading file
    ftp_state_remove	= 105,	// Active state - removing file

    ftp_state_abort		= 998,	// Aborting
	ftp_state_error		= 999	// Error
}	ftp_state_t;

// --------------------------------------------------------------------
// Class declaration
// --------------------------------------------------------------------
class   CFtp {

	// ----------------------------------------------------------------
    public: 	// Constructor and destructor
	// ----------------------------------------------------------------
    CFtp	();
    ~CFtp 	();

	// ----------------------------------------------------------------
    public:		// Copy constructor and assignment operator - invalid
	// ----------------------------------------------------------------
    CFtp				( const CFtp & );
    CFtp & operator =	( const CFtp & );

    // ----------------------------------------------------------
	public:		// Running the thread
    // ----------------------------------------------------------
	void				Abort	( void );
	void				Run		( void );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
    void				Clear	( void );
    void				Pasv	( bool );
    bool				Pasv	( void ) const;
	void				Login	( const char *, unsigned short, const char *, const char *, const char * = NULL );
	void				Logout	( void );
    void				Cwd		( const char * );
    const char *		Cwd		( void );
	const CFtpFile_l &	Dir		( void );
    CFtpFile			Dir		( const char * );
    void				Upload	( const char *, ftp_type_t = ftp_type_IMAGE );
    void				Download( const char *, ftp_type_t = ftp_type_IMAGE );
    void				Remove	( const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    const char *		Host	( void ) const;
    unsigned short		Port	( void ) const;
    const char *		User	( void ) const;
    const char *		Pass	( void ) const;
    const char *		Acct	( void ) const;
    ftp_state_t			State	( void ) const;
    const char *		Message	( void ) const;
    CError				Error	( void ) const;

	// ----------------------------------------------------------------
	private:	// State machine states
	// ----------------------------------------------------------------
    void				DoLogin		( void );
    void				DoLogout	( void );
    void				DoCwd		( void );
    void				DoDir		( void );
    void				DoUpload	( void );
    void				DoDownload	( void );
    void				DoRemove	( void );

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
    void				BreakTest	( bool = true );
	void				Cleanup		( void );
	void				Free		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
   	unsigned long		itsThreadId;
	bool				itsRunning;
	CFtpEngine			itsEngine;
	CError				itsError;
	CCpuMutex			itsMutex;
    ftp_state_t			itsState;
    bool				itsPasv;
    char				itsMessage	[1024];

	char *				itsHost;
    unsigned short		itsPort;
    char *				itsUser;
    char *				itsPass;
    char *				itsAcct;

    char				itsCwd		[1024];
    CFtpFile_l			itsDir;

    char				itsLocalFile	[1024];
    size_t				itsLocalSize;
    ftp_type_t			itsLocalType;

};


#endif      // #ifndef CFtp_hxx
// --------------------------------------------------------------------
// EOF: CFtp.hxx
// --------------------------------------------------------------------
