// --------------------------------------------------------------------
// CFtpEngine.hxx
// Whatis:  The FTP engine (RFC 959 - http://www.faqs.org/rfcs/rfc959.html )
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-NOV-2003     Created this source
// --------------------------------------------------------------------
#ifndef     CFtpEngine_hxx
#define     CFtpEngine_hxx

#include	"CFtpStreamCtl.hxx"
#include	"CFtpSocket.hxx"

// --------------------------------------------------------------------
typedef struct {
	const char *	name;
}	ftp_system_t;

// --------------------------------------------------------------------
typedef enum {
    ftp_type_ASCII 		= 'A',
    ftp_type_EBCDIC		= 'E',
    ftp_type_IMAGE		= 'I'
}	ftp_type_t;

// --------------------------------------------------------------------
typedef enum {
	ftp_struc_file		= 'F',
    ftp_struc_record	= 'R',
    ftp_struc_page		= 'P'
}	ftp_struc_t;

// --------------------------------------------------------------------
typedef enum {
	ftp_mode_stream		= 'S',
    ftp_mode_block		= 'B',
    ftp_mode_compressed	= 'C'
}	ftp_mode_t;

// --------------------------------------------------------------------
typedef struct {
	char			addr[128];
    unsigned short	port;
}	ftp_sockaddr_t;

// --------------------------------------------------------------------
// Class declaration
// --------------------------------------------------------------------
class   CFtpEngine {

	// ----------------------------------------------------------------
    public: 	// Constructor and destructor
	// ----------------------------------------------------------------
    CFtpEngine	();
    ~CFtpEngine ();

	// ----------------------------------------------------------------
    private:	// Copy constructor and assignment operator - invalid
	// ----------------------------------------------------------------
    CFtpEngine				( const CFtpEngine & );
    CFtpEngine & operator =	( const CFtpEngine & );

	// ----------------------------------------------------------------
	public:		// Interface - RFC 959
	// ----------------------------------------------------------------
	void			Connect		( const char *, unsigned short );
	void			Disconnect	( void );
    CTcpSocket *	Listener	( void );
    CFtpStreamCtl *	Control		( void );

	CFtpReply	USER		( const char * );
	CFtpReply	PASS		( const char * );
	CFtpReply	ACCT		( const char * );
	CFtpReply	CWD			( const char * );
	CFtpReply	CDUP		( void );
	CFtpReply	SMNT		( const char * );
	CFtpReply	REIN		( void );
	CFtpReply	QUIT		( void );
	CFtpReply	PORT		( void );
	CFtpReply	PASV		( ftp_sockaddr_t & );
	CFtpReply	TYPE		( ftp_type_t );
	CFtpReply	STRU		( ftp_struc_t );
	CFtpReply	MODE		( ftp_mode_t );
	CFtpReply	RETR		( const char * );
	CFtpReply	STOR		( const char * );
	CFtpReply	STOU		( char *, size_t );
	CFtpReply	APPE		( const char * );
	CFtpReply	ALLO		( size_t, size_t = 0 );
	CFtpReply	REST		( const char * );
	CFtpReply	RNFR		( const char * );
	CFtpReply	RNTO		( const char * );
	CFtpReply	ABOR		( void );
	CFtpReply	DELE		( const char * );
	CFtpReply	MKD			( const char * );
	CFtpReply	RMD			( const char * );
	CFtpReply	PWD			( char *, size_t );
	CFtpReply	LIST		( const char * = NULL );
	CFtpReply	NLST		( const char * = NULL );
	CFtpReply	SITE		( const char * );
	CFtpReply	SYST		( ftp_system_t & );
	CFtpReply	STAT		( const char * );
	CFtpReply	HELP		( const char * = NULL );
	CFtpReply	NOOP		( void );

    CFtpReply	Reply		( void );
    CFtpReply	Reply		( ftp_sockaddr_t & );
    CFtpReply	Reply		( char *, size_t );
    CFtpReply	Reply		( ftp_system_t & );

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	void		Cleanup	( void );
	void		Free	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CFtpStreamCtl	itsControl;
	CFtpSocket *	itsControlSock;
    CTcpSocket *	itsListener;
};


#endif      // #ifndef CFtpEngine_hxx
// --------------------------------------------------------------------
// EOF: CFtpEngine.hxx
// --------------------------------------------------------------------
