// --------------------------------------------------------------------
// CFtpStream.hxx
// Whatis:  Streams for the FTP system
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-NOV-2003     Created this source
// --------------------------------------------------------------------
#ifndef     CFtpStream_hxx
#define     CFtpStream_hxx

#include	"Platform.hxx"

// --------------------------------------------------------------
// Defines for the read function
// --------------------------------------------------------------
#define	FTP_STREAM_READ_IDLE	(-1)
#define	FTP_STREAM_READ_EOF		(-2)
#define	FTP_STREAM_READ_ERROR	(-3)

// --------------------------------------------------------------
// Class declaration
// --------------------------------------------------------------
class   CFtpStream {

    // ----------------------------------------------------------
    public: 	// Constructor and destructor
    // ----------------------------------------------------------
    CFtpStream  ();
    virtual	~CFtpStream ();

    // ----------------------------------------------------------
	public:		// The interface
    // ----------------------------------------------------------
	virtual	int		Read	( void )	= 0;
	virtual void	Write	( char )	= 0;
	virtual void	Flush	( void )	= 0;

};

#endif      // #ifndef CFtpStream_hxx
// --------------------------------------------------------------
// EOF: CFtpStream.hxx
// --------------------------------------------------------------
