// --------------------------------------------------------------------
// CFtpStreamCtl.hxx
// Whatis:  Control stream for the FTP system
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-NOV-2003     Created this source
// --------------------------------------------------------------------
#ifndef     CFtpStreamCtl_hxx
#define     CFtpStreamCtl_hxx

#include	"CFtpStream.hxx"
#include	"CFtpReply.hxx"
#include	"CCpuMutex.hxx"

// --------------------------------------------------------------
// Class declaration
// --------------------------------------------------------------
class   CFtpStreamCtl : public CFtpStream {

    // ----------------------------------------------------------
    public: 	// Constructor and destructor
    // ----------------------------------------------------------
    CFtpStreamCtl	();
    ~CFtpStreamCtl 	();

    // ----------------------------------------------------------
	public:		// The interface
    // ----------------------------------------------------------
	int			Read	( void );
	void		Write	( char );
	void		Flush	( void );

    // ----------------------------------------------------------
	public:		// Additional interfaces
    // ----------------------------------------------------------
    void		Command		( const char *, char );
	void		Command		( const char *, const char * );
	void		Command		( const char * );
    CFtpReply	Reply		( void );

    // ----------------------------------------------------------
	private:	// Helpers
    // ----------------------------------------------------------
	void		Interpret	( void );
	void		Cleanup		( void );
	void		Free		( void );

    // ----------------------------------------------------------
	private:	// Instance data
    // ----------------------------------------------------------
	CCpuMutex	itsMutex;
	char *		itsCommand;
	int			itsCommandOffs;
	char		itsReply		[1024];
	int			itsReplyOffs;
	CFtpReply_l	itsReplyList;

};

#endif      // #ifndef CFtpStreamCtl_hxx
// --------------------------------------------------------------
// EOF: CFtpStreamCtl.hxx
// --------------------------------------------------------------
