// --------------------------------------------------------------------
// CFtpFile.cxx
// Whatis:  FTP Client class library
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CFtpFile.hxx"

// --------------------------------------------------------------------
CFtpFile::CFtpFile	() {
	itsName = NULL;
	itsSize	= 0;
	itsTime = 0;
	itsDirf = false;
    itsCmnd = 0;
}

// --------------------------------------------------------------------
CFtpFile::~CFtpFile	() {
	if	( itsName )	delete [] itsName;
}

// --------------------------------------------------------------------
CFtpFile::CFtpFile				( const CFtpFile & aC ) {
	itsName = NULL;
	CFtpFile::Name( aC.Name() );
	itsSize	= aC.Size();
	itsTime = aC.Time();
	itsDirf = aC.Dirf();
	itsCmnd = aC.Cmnd();
}

// --------------------------------------------------------------------
CFtpFile & CFtpFile::operator =	( const CFtpFile & aC ) {
	CFtpFile::Name( aC.Name() );
	itsSize	= aC.Size();
	itsTime = aC.Time();
	itsDirf = aC.Dirf();
	itsCmnd = aC.Cmnd();
	return *this;
}

// --------------------------------------------------------------------
CFtpFile & CFtpFile::operator =	( const char * aL ) {
	if	( itsName )	delete [] itsName;
	itsName = NULL;
	itsSize	= 0;
    itsTime = 0;
    itsDirf = false;
    itsCmnd = 0;

	struct tm	mytm;
    time_t		mytime;
    char		mypath[1024];

    // Determine if this is a directory, link or an ordinary file
    if		( *aL == 'd' )	itsDirf = true;
    else if	( *aL == '-' )	itsDirf = false;
    else		  			return *this;

    // Skip over a few items
    // drwxr-xr-x   2 ftpadmin ftpadmin     4096 Sep 12 19:08 directory
    // -rwxr-xr-x   2 ftpadmin ftpadmin     4096 Sep 12 19:08 file
    for	( int i = 0; i < 4; i++ ) {
    	while	( ( *aL > ' ' ) || ( *aL < 0 ) )	aL++;
    	while	( ( *aL > 0 ) && ( *aL <= ' ' ) )	aL++;
    }

    // We are now pointing to the file size
    if	( ( *aL < '0' ) || ( *aL > '9' ) )	return *this;
    if	( itsDirf == false )				itsSize = (size_t)::atol( aL );
   	while	( ( *aL > ' ' ) || ( *aL < 0 ) )	aL++;
   	while	( ( *aL > 0 ) && ( *aL <= ' ' ) )	aL++;

    // Initialize the time
    mytime = ::time( NULL );
    ::memcpy( &mytm, ::localtime( &mytime ), sizeof( mytm ) );

    // Next one will be the month
	if		( ! ::strnicmp( "jan", aL, 3 ) )	mytm.tm_mon = 0;
	else if	( ! ::strnicmp( "feb", aL, 3 ) )	mytm.tm_mon = 1;
	else if	( ! ::strnicmp( "mar", aL, 3 ) )	mytm.tm_mon = 2;
	else if	( ! ::strnicmp( "apr", aL, 3 ) )	mytm.tm_mon = 3;
	else if	( ! ::strnicmp( "may", aL, 3 ) )	mytm.tm_mon = 4;
	else if	( ! ::strnicmp( "jun", aL, 3 ) )	mytm.tm_mon = 5;
	else if	( ! ::strnicmp( "jul", aL, 3 ) )	mytm.tm_mon = 6;
	else if	( ! ::strnicmp( "aug", aL, 3 ) )	mytm.tm_mon = 7;
	else if	( ! ::strnicmp( "sep", aL, 3 ) )	mytm.tm_mon = 8;
	else if	( ! ::strnicmp( "oct", aL, 3 ) )	mytm.tm_mon = 9;
	else if	( ! ::strnicmp( "nov", aL, 3 ) )	mytm.tm_mon = 10;
	else if	( ! ::strnicmp( "dec", aL, 3 ) )	mytm.tm_mon = 11;
    else										return *this;
   	while	( ( *aL > ' ' ) || ( *aL < 0 ) )	aL++;
   	while	( ( *aL > 0 ) && ( *aL <= ' ' ) )	aL++;

    // Now we should have the day of the month
    if	( ( *aL < '1' ) || ( *aL > '9' ) )	return *this;
    mytm.tm_mday = ::atoi( aL );
	if	( ( mytm.tm_mday < 0 ) || ( mytm.tm_mday > 30 ) )	return *this;
   	while	( ( *aL > ' ' ) || ( *aL < 0 ) )	aL++;
   	while	( ( *aL > 0 ) && ( *aL <= ' ' ) )	aL++;

    // The next one should be either the year or the time
    if	( ( *aL < '0' ) || ( *aL > '9' ) )	return *this;
   	mytm.tm_sec = 0;
	if	( aL[2] == ':' ) {
	   	mytm.tm_hour = 10 * (aL[0] - '0') + (aL[1] - '0');
   		mytm.tm_min  = 10 * (aL[3] - '0') + (aL[4] - '0');
        if	( ( mytm.tm_hour < 0 ) || ( mytm.tm_hour > 23 ) )	return *this;
        if	( ( mytm.tm_min  < 0 ) || ( mytm.tm_min  > 59 ) )	return *this;
    }
    else {
	   	mytm.tm_hour = 0;
   		mytm.tm_min  = 0;
        mytm.tm_year = ::atoi( aL ) - 1900;
        if	( ( mytm.tm_year < 0 ) || ( mytm.tm_year > 400 ) )	return *this;
    }
    itsTime = ::mktime( &mytm );
   	while	( ( *aL > ' ' ) || ( *aL < 0 ) )	aL++;
   	while	( ( *aL > 0 ) && ( *aL <= ' ' ) )	aL++;

	// Last but not least - the file name
    ::strcpy( mypath, aL );
    if	( ::strstr( mypath, " ->" ) ) {
    	*::strstr( mypath, " ->" ) = 0;
    }
	if	( ! ::strcmp( mypath, "." ) )	return *this;
	if	( ! ::strcmp( mypath, ".." ) )	return *this;
	itsName = ::my_private_strdup( mypath );
    itsCmnd = 1;

	return *this;
}

// --------------------------------------------------------------------
const char *	CFtpFile::Name	( void ) const {
	return	itsName ? itsName : "";
}

// --------------------------------------------------------------------
size_t			CFtpFile::Size	( void ) const {
	return	itsSize;
}

// --------------------------------------------------------------------
time_t			CFtpFile::Time	( void ) const {
	return	itsTime;
}

// --------------------------------------------------------------------
bool			CFtpFile::Dirf	( void ) const {
	return	itsDirf;
}

// --------------------------------------------------------------------
char			CFtpFile::Cmnd	( void ) const {
	return	itsCmnd;
}

// --------------------------------------------------------------------
void			CFtpFile::Name	( const char * aV ) {
	if	( itsName )	delete [] itsName;
	itsName = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void			CFtpFile::Size	( size_t aV ) {
	itsSize = aV;
}

// --------------------------------------------------------------------
void			CFtpFile::Time	( time_t aV ) {
	itsTime = aV;
}

// --------------------------------------------------------------------
void			CFtpFile::Dirf	( bool aV ) {
	itsDirf = aV;
}

// --------------------------------------------------------------------
void			CFtpFile::Cmnd	( char aV ) {
	itsCmnd = aV;
}

// --------------------------------------------------------------------
// EOF:	CFtpFile.cpp
// --------------------------------------------------------------------
