//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "FurPushApp.h"
#include <dir.h>
#include <io.h>
#include <string>

//---------------------------------------------------------------------------
#pragma package(smart_init)

#pragma resource "*.dfm"
TFurPushMainWin *FurPushMainWin;

//---------------------------------------------------------------------------
// Defines for teh service
//---------------------------------------------------------------------------
#define	FURPUSH_PORT	(unsigned short)31075
#define	DEFAULT_HOST_IP	"tuubi51.adsl.netsonic.fi"

//---------------------------------------------------------------------------
// Enable different parts of GUI
//---------------------------------------------------------------------------
void __fastcall	TFurPushMainWin::SetGuiEnables	( void ) {
	DeleteAfterUploadCbx->Enabled = ((itsFurPush == NULL) && (itsSendingAll == false));
	FurPushAllButton->Enabled = ( (itsFurPush == NULL) &&
								  (FurPushFileListBox->Items->Count > 0 ) &&
                                  (itsSendingAll==false) );
	FurPushUploadButton->Enabled = ( ( itsFurPush == NULL ) &&
    								 ( RemoteFileName->Text != "" ) &&
                                     ( itsSendingAll == false) );
	LocalFileName->Enabled = ((itsFurPush == NULL) && (itsSendingAll == false));
	FurPushFileListBox->Enabled = ((itsFurPush == NULL) && (itsSendingAll == false));
	FurPushDriveCombo->Enabled = ((itsFurPush == NULL) && (itsSendingAll == false));
	FurPushDirectoryBox->Enabled = ((itsFurPush == NULL) && (itsSendingAll == false));
}

//---------------------------------------------------------------------------
// This is the transfer processor - it will do the transfers
//---------------------------------------------------------------------------
void __fastcall	TFurPushMainWin::MyIdleHandler(TObject *Sender, bool &Done) {

	// Non transfer state
	if	( itsFurPush == NULL ) {
		if	( itsSendingAll ) {
			if	( itsListIndex < (dword_t)FurPushFileListBox->Items->Count ) {
            	if	( itsPauseTime < ::time( NULL ) ) {
			    	const char *	addr = ::getenv( "FURPUSH_HOST_IP" );
                	char	filepath[1024];

                    ::strcpy( filepath, FurPushFileListBox->Directory.c_str() );
                    ::strcat( filepath, "\\" );
					::strcat( filepath, FurPushFileListBox->Items->Strings[itsListIndex].c_str() );
					if	( ! addr )	addr = DEFAULT_HOST_IP;
                    itsFurPush = new CFurPush( addr, FURPUSH_PORT, filepath );
                    if	( itsFurPush->State() == fur_push_state_error ) {
						delete	itsFurPush;
                        itsFurPush = NULL;
						itsListIndex++;
						if	( itsListIndex < (dword_t)FurPushFileListBox->Items->Count ) {
							FurPushFileListBox->TopIndex	= (int)itsListIndex;
							FurPushFileListBox->ItemIndex	= (int)itsListIndex;
                        }
                    }
                    else {
						LocalFileName->Text	= itsFurPush->LocaFile();
                    	RemoteFileName->Text= itsFurPush->RemoFile();
                    }
                }
            }
            else {
            	itsSendingAll = false;
	            TFurPushMainWin::SetGuiEnables();
            }
		    Done = false;
		    SLEEP( 1 );
        }
    }
	// Transfer is actually doing something
	else {
		char	stb[64];
    	switch	( itsFurPush->State() ) {
			case	fur_push_state_connect:		// Connecting to service
	    	FileInfoTextLabel->Text			= "Sending file ...";
	        ProgressInformationText->Text	= "Connecting to service ...";
			FurPushProgressBar->Step		= 1;
			FurPushProgressBar->Position	= ::time( NULL ) % 3;
			FurPushProgressBar->Min			= 0;
			FurPushProgressBar->Max			= 3;
			break;

			case	fur_push_state_request:		// Send request to service
			break;

			case	fur_push_state_response:	// Wait response from service
	        ProgressInformationText->Text	= "Waiting for response ...";
			FurPushProgressBar->Step		= 1;
			FurPushProgressBar->Position	= ::time( NULL ) % 3;
			FurPushProgressBar->Min			= 0;
			FurPushProgressBar->Max			= 3;
			break;

			case	fur_push_state_transini:	// Initialize the transfer
			break;

			case	fur_push_state_transfer:	// Transfer file data
            ::sprintf(	stb, "Transferring %d Kb (%d Kb done)",
						itsFurPush->SendEnd() / 1024,
						itsFurPush->SendOffset() / 1024 );

	        ProgressInformationText->Text	= stb;
			FurPushProgressBar->Step		= 1;
			FurPushProgressBar->Position	= itsFurPush->SendOffset();
			FurPushProgressBar->Min			= 0;
			FurPushProgressBar->Max			= itsFurPush->SendEnd();
			break;

			case	fur_push_state_transack:	// Wait transfer ack from service
	        ProgressInformationText->Text	= "Waiting for response ...";
			FurPushProgressBar->Step		= 1;
			FurPushProgressBar->Position	= ::time( NULL ) % 3;
			FurPushProgressBar->Min			= 0;
			FurPushProgressBar->Max			= 3;
			break;

			case	fur_push_state_finalize:	// Send final accept
			break;

			case	fur_push_state_serclose:	// Wait service to close
	        ProgressInformationText->Text	= "Waiting for disconnect ...";
			FurPushProgressBar->Step		= 1;
			FurPushProgressBar->Position	= ::time( NULL ) % 3;
			FurPushProgressBar->Min			= 0;
			FurPushProgressBar->Max			= 3;
			break;

			case	fur_push_state_ready:		// Transfer ready
            if	( itsSendingAll )	FileInfoTextLabel->Text	= "Sending all files";
            else					FileInfoTextLabel->Text = "File has been transferred";
	        ProgressInformationText->Text	= "Waiting for next file";
			FurPushProgressBar->Step		= 1;
			FurPushProgressBar->Position	= 0;
			FurPushProgressBar->Min			= 0;
			FurPushProgressBar->Max			= 3;
            if	( DeleteAfterUploadCbx->Checked == true ) {
				::unlink( itsFurPush->LocaFile() );
                if	( itsSendingAll ) {
					FurPushFileListBox->Items->Delete( itsListIndex );
					if	( itsListIndex < (dword_t)FurPushFileListBox->Items->Count ) {
						FurPushFileListBox->TopIndex	= (int)itsListIndex;
						FurPushFileListBox->ItemIndex	= (int)itsListIndex;
					}
                }
                else {
					int	item = FurPushFileListBox->ItemIndex;
                    if	( item >= 0 ) {
						FurPushFileListBox->Items->Delete( item );
                    }
				}
            }
            else if	( itsSendingAll ) {
            	itsListIndex++;
				if	( itsListIndex < (dword_t)FurPushFileListBox->Items->Count ) {
					FurPushFileListBox->TopIndex	= (int)itsListIndex;
					FurPushFileListBox->ItemIndex	= (int)itsListIndex;
				}
            }
            delete itsFurPush;
            itsFurPush = NULL;
			if	( ! itsSendingAll ) {
	            TFurPushMainWin::SetGuiEnables();
            }
            itsRetryCount = 0;
			break;

			case	fur_push_state_error:		// Error
	    	FileInfoTextLabel->Text = itsFurPush->Message();
            delete itsFurPush;
            itsFurPush = NULL;
        	if	( itsSendingAll ) {
            	if	( itsRetryCount < 5 ) {
					itsRetryCount++;
                    itsPauseTime = 15 + ::time( NULL );
                }
                else {
					itsSendingAll = false;
		            TFurPushMainWin::SetGuiEnables();
                }
            }
            else {
	            TFurPushMainWin::SetGuiEnables();
            }
			break;

        }
		// Because we don't want excessive load, hibernate for 1 milliseconds
	    Done = false;
	    SLEEP( 1 );
    }
}

//---------------------------------------------------------------------------
// GUI callback methods
//---------------------------------------------------------------------------
__fastcall TFurPushMainWin::TFurPushMainWin(TComponent* Owner)
			: TForm(Owner) {
	// Main application init
    itsFurPush			= NULL;
	itsListIndex		= 0;
	itsSendingAll		= false;
    itsPauseTime		= ::time( NULL );
	itsRetryCount		= 0;
	Application->OnIdle = MyIdleHandler;
}

//---------------------------------------------------------------------------
void __fastcall TFurPushMainWin::DriveChanged(TObject *Sender)
{
    if	( itsSendingAll )	return;
    FurPushDirectoryBox->Drive = FurPushDriveCombo->Drive;
    TFurPushMainWin::SetGuiEnables();
}

//---------------------------------------------------------------------------
void __fastcall TFurPushMainWin::DirectoryChanged(TObject *Sender)
{
    if	( itsSendingAll )	return;
     FurPushFileListBox->Drive = FurPushDirectoryBox->Drive;
     FurPushFileListBox->Directory = FurPushDirectoryBox->Directory;
     TFurPushMainWin::SetGuiEnables();
}

//---------------------------------------------------------------------------
void __fastcall TFurPushMainWin::SetLocalFileName(TObject *Sender) {
    char    fn_name     [MAXFILE];

    if	( itsSendingAll )	return;

    fnsplit( 	FurPushFileListBox->FileName.c_str(),
     			NULL, NULL, fn_name, NULL );
    if	( *fn_name != 0 ) {
		LocalFileName->Text = FurPushFileListBox->FileName.c_str();
    }
}

//---------------------------------------------------------------------------
void __fastcall TFurPushMainWin::CheckLocalFileName(TObject *Sender) {
    char    fn_name     [MAXFILE];
    char	fn_suff		[MAXEXT];
	char	fn_comp		[MAXFILE];
	bool	accepted = false;

    if	( itsSendingAll )	return;

    fnsplit( 	LocalFileName->Text.c_str(),
     			NULL, NULL, fn_name, fn_suff );
    if	( *fn_name != 0 ) {
        int		i;
        accepted = true;
        for	( i = 0; fn_name[i]; i++ ) {
        	if	( strchr( "\"$%&/=?\\+@<>|", fn_name[i] ) ) {
            	accepted = false;
		    	FileInfoTextLabel->Text = "Invalid characters in file name";
                break;
            }
        }
		if	( accepted ) {
			if	( stricmp( fn_suff, ".zip" ) ) {
            	accepted = false;
		    	FileInfoTextLabel->Text = "Propably not a zip file";
            }
        }
    	if	( accepted ) {
			if	( access( LocalFileName->Text.c_str(), 0 ) ) {
            	accepted = false;
		    	FileInfoTextLabel->Text = "File does not exist";
            }
        }
    }
    else {
    	FileInfoTextLabel->Text = "No file name";
    }

    if	( accepted ) {
        strcpy( fn_comp, fn_name );
        strcat( fn_comp, fn_suff );
		strlwr( fn_comp );
        RemoteFileName->Text = fn_comp;
    	FileInfoTextLabel->Text = "This file can be used";
	    FurPushUploadButton->Enabled = true;
        ProgressInformationText->Text = "Starting upload";
    }
    else {
        RemoteFileName->Text = "";
	    FurPushUploadButton->Enabled = false;
        ProgressInformationText->Text = "Selecting zip";
    }
}

//---------------------------------------------------------------------------
void __fastcall TFurPushMainWin::AbortButtonKlicked(TObject *Sender) {
	// User klicked the abort button
    if	( itsFurPush != NULL  ) {
    	delete itsFurPush;
        itsFurPush = NULL;
        ProgressInformationText->Text	= "Transfer aborted !";
		FurPushProgressBar->Step		= 1;
		FurPushProgressBar->Position	= 0;
		FurPushProgressBar->Min			= 0;
		FurPushProgressBar->Max			= 3;
		itsSendingAll					= false;
        TFurPushMainWin::SetGuiEnables();
    }
    else {
    	Application->Terminate();
    }
}

//---------------------------------------------------------------------------
void __fastcall TFurPushMainWin::UploadButtonKlicked(TObject *Sender) {
	// User klicked the upload button
    if	( itsFurPush != NULL ) {
    	delete itsFurPush;
        itsFurPush = NULL;
        ProgressInformationText->Text	= "Transfer aborted !";
		FurPushProgressBar->Step		= 1;
		FurPushProgressBar->Position	= 0;
		FurPushProgressBar->Min			= 0;
		FurPushProgressBar->Max			= 3;
        TFurPushMainWin::SetGuiEnables();
    }
    else {
    	const char *	addr = ::getenv( "FURPUSH_HOST_IP" );
		if	( ! addr )	addr = DEFAULT_HOST_IP;
    	itsFurPush = new CFurPush( addr, FURPUSH_PORT, LocalFileName->Text.c_str() );
        TFurPushMainWin::SetGuiEnables();
    }
}

//---------------------------------------------------------------------------
void __fastcall TFurPushMainWin::FurPushAllButtonClick(TObject *Sender) {
	// User klicked the send all button
    if	( itsFurPush != NULL ) {
    	delete itsFurPush;
        itsFurPush = NULL;
        FileInfoTextLabel->Text			= "";
        ProgressInformationText->Text	= "Transfer aborted !";
		FurPushProgressBar->Step		= 1;
		FurPushProgressBar->Position	= 0;
		FurPushProgressBar->Min			= 0;
		FurPushProgressBar->Max			= 3;
		itsSendingAll					= false;
        TFurPushMainWin::SetGuiEnables();
    }
    else {
		itsListIndex	= 0;
		itsRetryCount	= 0;
		itsSendingAll	= true;
        FileInfoTextLabel->Text = "Sending all files";
    	TFurPushMainWin::SetGuiEnables();
		FurPushFileListBox->TopIndex	= 0;
		FurPushFileListBox->ItemIndex	= 0;
    }
}

//---------------------------------------------------------------------------

