// --------------------------------------------------------------------
// CFurserController.h
// Whatis:  Furser Controller class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserController_h
#define CFurserController_h

#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
class CFurserController {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserController		();
	~CFurserController		();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserController				( const CFurserController & );
	CFurserController & operator =	( const CFurserController & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CFurserController & ) const;
	bool operator != ( const CFurserController & ) const;
	bool operator == ( const char * ) const;
	bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
    void			Load	( const CWinIniFile &, dword_t );
    void			Save	( CWinIniFile &, dword_t ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	Ip		( void ) const;
	unsigned short	Port	( void ) const;
	const char *	Pass	( void ) const;

	// ----------------------------------------------------------------
	void			Ip		( const char * );
	void			Port	( unsigned short );
	void			Pass	( const char * );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Free	( void );
	void			Cleanup	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *			itsIp;
	unsigned short	itsPort;
	char *			itsPass;

};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserController>		CFurserController_l;
typedef CFurserController_l::iterator       CFurserController_li;
typedef CFurserController_l::const_iterator	CFurserController_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserController.h
// --------------------------------------------------------------------
