// --------------------------------------------------------------------
// CFurserWizard.h
// Whatis:  Furser Document class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserWizard_h
#define CFurserWizard_h

#include	"CFurserWizQery.h"
#include	"CWinIniFile.hxx"
#include	"CFurserSrSetn.h"

// --------------------------------------------------------------------
class CFurserWizard {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserWizard	();
	~CFurserWizard	();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator - invalid
	// ----------------------------------------------------------------
	CFurserWizard				( const CFurserWizard & );
	CFurserWizard & operator =	( const CFurserWizard & );

	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
	void					Load		( const CWinIniFile &, const char * );
    CFurserWizQery &		Qery		( int );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const CFurserWizQery_l &	QeryList	( void ) const;

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CFurserWizQery_l	itsQeryList;
    CFurserWizQery		itsFallback;
};

#endif
// --------------------------------------------------------------------
// EOF:	CFurserWizard.h
// --------------------------------------------------------------------
