// --------------------------------------------------------------------
// CFurserWizardList.h
// Whatis:  Furser Document class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserWizardList_h
#define CFurserWizardList_h

#include	"CFurserString.h"

// --------------------------------------------------------------------
class CFurserWizardList {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserWizardList	();
	~CFurserWizardList	();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator - invalid
	// ----------------------------------------------------------------
	CFurserWizardList				( const CFurserWizardList & );
	CFurserWizardList & operator =	( const CFurserWizardList & );

	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
	void					Load		( const char *, const char * );
	const CFurserString_l &	CaptionList	( void ) const;
	const char *			Description	( int )	 const;
	const char *			WizardFile	( int )  const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void					ProcessFile	( const char * );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CFurserString_l	itsCaptionList;
	CFurserString_l	itsDescList;
	CFurserString_l	itsFileList;
};

#endif
// --------------------------------------------------------------------
// EOF:	CFurserWizardList.h
// --------------------------------------------------------------------
