//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TBanEditDialog.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TBanEditDialog *BanEditDialog = NULL;

//---------------------------------------------------------------------------
__fastcall TBanEditDialog::TBanEditDialog(TComponent* Owner) : TForm(Owner) {
	BanData	= NULL;
    itsUpdateFlag = 0;
}

//---------------------------------------------------------------------------
void __fastcall TBanEditDialog::Populate( void ) {
	itsUpdateFlag++;
	NameEdit->Text = BanData->BanName();
    TypeComboBox->ItemIndex = BanData->BanType();
    ArgsEdit->Text = BanData->BanArgs();
    EnabledCheckBox->Checked = BanData->Enabled();
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TBanEditDialog::NameEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	BanData->BanName( NameEdit->Text.c_str() );
}

//---------------------------------------------------------------------------
void __fastcall TBanEditDialog::TypeComboBoxChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	BanData->BanType( TypeComboBox->ItemIndex );
}

//---------------------------------------------------------------------------
void __fastcall TBanEditDialog::ArgsEditChange(TObject *Sender){
	if	( itsUpdateFlag )	return;
	BanData->BanArgs( ArgsEdit->Text.c_str() );
}

//---------------------------------------------------------------------------
void __fastcall TBanEditDialog::EnabledCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	BanData->Enabled( EnabledCheckBox->Checked );
}

//---------------------------------------------------------------------------
void __fastcall TBanEditDialog::OkButtonClick(TObject *Sender) {
	ModalResult = mrOk;
}

//---------------------------------------------------------------------------
void __fastcall TBanEditDialog::CancelButtonClick(TObject *Sender) {
	ModalResult = mrCancel;
}

//---------------------------------------------------------------------------
