//---------------------------------------------------------------------------
#ifndef TMainDialogH
#define TMainDialogH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ToolWin.hpp>
#include <Menus.hpp>
#include <ImgList.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
#include <Mask.hpp>
#include <CheckLst.hpp>
#include <Grids.hpp>

//---------------------------------------------------------------------------
#include "CFurserDoc.h"
#include "CFurserClient.h"
#include "CFurserSrData.h"

//---------------------------------------------------------------------------
// Macros to help
//---------------------------------------------------------------------------
#define TCTLSTR(c)	c->Items->Strings[c->ItemIndex]
#define TCTLCSTR(c)	c->Items->Strings[c->ItemIndex].c_str()

//---------------------------------------------------------------------------
class TMainDialog : public TForm
{
__published:	// IDE-managed Components
	TStatusBar *MainStatusBar;
	TPanel *Panel1;
	TBitBtn *MainNewBitBtn;
	TComboBox *MainControllerComboBox;
	TBitBtn *MainConnectBitBtn;
	TBitBtn *MainDisconnectBitBtn;
	TLabel *Label1;
	TLabel *Label2;
	TLabel *Label3;
	TEdit *MainIPEdit;
	TEdit *MainPortEdit;
	TGroupBox *GroupBox1;
	TBitBtn *ServerWizardBitBtn;
	TBitBtn *ServerDeleteBitBtn;
	TCheckListBox *ServersCheckListBox;
	TBitBtn *MainDeleteBitBtn;
	TPageControl *ServerPageControl;
	TTabSheet *ServerGeneralTabSheet;
	TTabSheet *ServerScheduleTabSheet;
	TTabSheet *ServerPoliciesTabSheet;
	TTabSheet *ServerMutatorsTabSheet;
	TTabSheet *ServerGamesTabSheet;
	TTabSheet *ServerMapsTabSheet;
	TLabel *Label4;
	TLabel *Label5;
	TLabel *Label6;
	TEdit *GeneralServerNameEdit;
	TEdit *GeneralServerGameRootEdit;
	TLabel *Label7;
	TEdit *GeneralServerUccArgsEdit;
	TBitBtn *ScheduleNewBitBtn;
	TBitBtn *ScheduleDeleteBitBtn;
	TGroupBox *GroupBox3;
	TLabel *Label8;
	TComboBox *ScheduleTypeComboBox;
	TComboBox *ScheduleStartJobComboBox;
	TComboBox *ScheduleStopJobComboBox;
	TLabel *Label9;
	TLabel *Label10;
	TDateTimePicker *ScheduleStartDateDateTimePicker;
	TDateTimePicker *ScheduleStartTimeDateTimePicker;
	TDateTimePicker *ScheduleEndDateDateTimePicker;
	TDateTimePicker *ScheduleEndTimeDateTimePicker;
	TCheckBox *ScheduleEnableCheckBox;
	TEdit *PoliciesAdminNameEdit;
	TEdit *PoliciesGamePassEdit;
	TLabel *Label13;
	TEdit *PoliciesAdminPassEdit;
	TCheckBox *PoliciesWebAdminCheckBox;
	TEdit *PoliciesWebAdminPortEdit;
	TCheckBox *PoliciesAdminCheckBox;
	TCheckBox *PoliciesGamePassCheckBox;
	TEdit *MainPassEdit;
	TGroupBox *GroupBox4;
	TGroupBox *GroupBox5;
	TGroupBox *GroupBox6;
	TBitBtn *PoliciesGroupsAddBitBtn;
	TBitBtn *PoliciesGroupsDeleteBitBtn;
	TBitBtn *PoliciesUsersDeleteBitBtn;
	TBitBtn *PoliciesUsersAddBitBtn;
	TBitBtn *PoliciesBanDeleteBitBtn;
	TBitBtn *PoliciesBanAddBitBtn;
	TBitBtn *ServerStartBitBtn;
	TBitBtn *ServerStopBitBtn;
	TBitBtn *MapsAddBitBtn;
	TBitBtn *MapsDeleteBitBtn;
	TBitBtn *MapsEarlierBitBtn;
	TBitBtn *MapsLaterBitBtn;
	TListView *ScheduleListView;
	TListView *PoliciesGroupsListView;
	TListView *PoliciesUsersListView;
	TListView *PolisiesBanListView;
	TListView *MutatorsListView;
	TListView *GeneralConfigListView;
	TListView *MutatorsSettingsListView;
	TListView *GamesListView;
	TListView *GamesSettingsListView;
	TCheckBox *MapsShowRotCheckBox;
	TListView *MapsListView;
	TBitBtn *MainSaveBitBtn;
	TBitBtn *ServerSaveBitBtn;
	TBitBtn *GeneralConfigAddBitBtn;
	TBitBtn *GeneralConfigDelBitBtn;
	TBitBtn *GeneralConfigEditBitBtn;
	TBitBtn *PoliciesGroupsEditBitBtn;
	TBitBtn *PoliciesUsersEditBitBtn;
	TBitBtn *PoliciesBanEditBitBtn;
	TCheckBox *MutatorLoadCheckBox;
	TBitBtn *MutatorSetnNewBitBtn;
	TBitBtn *MutatorSetnEditBitBtn;
	TBitBtn *MutatorSetnDelBitBtn;
	TBitBtn *MutatorNewBitBtn;
	TBitBtn *MutatorDelBitBtn;
	TLabel *Label11;
	TLabel *Label12;
	TEdit *MutatorNameEdit;
	TEdit *MutatorDescEdit;
	TBitBtn *GamesAddBitBtn;
	TBitBtn *GamesDelBitBtn;
	TEdit *GamesNameEdit;
	TLabel *Label14;
	TLabel *Label15;
	TEdit *GamesDescEdit;
	TBitBtn *GamesSetnNewBitBtn;
	TBitBtn *GamesSetnEditBitBtn;
	TBitBtn *GamesSetnDelBitBtn;
	TLabel *Label17;
	TCheckBox *MapsRotateCheckBox;
	TEdit *MapsArgsEdit;
	TLabel *Label16;
	TEdit *MapsNameEdit;
	TLabel *Label18;
	TEdit *MutatorGroupEdit;
	TTabSheet *ServerMacrosTabSheet;
	TBitBtn *ServerMacroAddBitBtn;
	TBitBtn *ServerMacroDelBitBtn;
	TListView *ServerMacroListView;
	TEdit *ServerMacroNameEdit;
	TLabel *Label19;
	TLabel *Label20;
	TEdit *ServerMacroValueEdit;
	TBitBtn *ServerLogBitBtn;
	TBitBtn *ScheduleStartBitBtn;
	TBitBtn *ScheduleStopBitBtn;
	TBitBtn *ScheduleRestartBitBtn;
	TPanel *GameStatusPanel;
	TLabel *GeneralServerTypeLabel;
	TEdit *GamesPrefixEdit;
	TEdit *GamesMapListEdit;
	TLabel *Label21;
	TPanel *MapRotateInfoPanel;
	void __fastcall MainNewBitBtnClick(TObject *Sender);
	void __fastcall MainDeleteBitBtnClick(TObject *Sender);
	void __fastcall MainConnectBitBtnClick(TObject *Sender);
	void __fastcall MainDisconnectBitBtnClick(TObject *Sender);
	void __fastcall MainControllerComboBoxChange(TObject *Sender);
	void __fastcall MainIPEditChange(TObject *Sender);
	void __fastcall MainPortEditChange(TObject *Sender);
	void __fastcall MainPassEditChange(TObject *Sender);
	void __fastcall ServerWizardBitBtnClick(TObject *Sender);
	void __fastcall ServerDeleteBitBtnClick(TObject *Sender);
	void __fastcall ServerStartBitBtnClick(TObject *Sender);
	void __fastcall ServerStopBitBtnClick(TObject *Sender);
	void __fastcall ServersCheckListBoxClick(TObject *Sender);
	void __fastcall ServersCheckListBoxClickCheck(TObject *Sender);
	void __fastcall ServersCheckListBoxDblClick(TObject *Sender);
	void __fastcall ServerPageControlChange(TObject *Sender);
	void __fastcall GeneralServerNameEditChange(TObject *Sender);
	void __fastcall GeneralServerGameRootEditChange(TObject *Sender);
	void __fastcall GeneralServerUccArgsEditChange(TObject *Sender);
	void __fastcall GeneralConfigListViewClick(TObject *Sender);
	void __fastcall ScheduleListViewClick(TObject *Sender);
	void __fastcall ScheduleTypeComboBoxChange(TObject *Sender);
	void __fastcall ScheduleEnableCheckBoxClick(TObject *Sender);
	void __fastcall ScheduleStartDateDateTimePickerChange(TObject *Sender);
	void __fastcall ScheduleStartTimeDateTimePickerChange(TObject *Sender);
	void __fastcall ScheduleStartJobComboBoxChange(TObject *Sender);
	void __fastcall ScheduleEndDateDateTimePickerChange(TObject *Sender);
	void __fastcall ScheduleEndTimeDateTimePickerChange(TObject *Sender);
	void __fastcall ScheduleStopJobComboBoxChange(TObject *Sender);
	void __fastcall ScheduleNewBitBtnClick(TObject *Sender);
	void __fastcall ScheduleDeleteBitBtnClick(TObject *Sender);
    void __fastcall ScheduleListViewDblClick(TObject *Sender);
	void __fastcall PoliciesAdminCheckBoxClick(TObject *Sender);
	void __fastcall PoliciesAdminNameEditChange(TObject *Sender);
	void __fastcall PoliciesAdminPassEditChange(TObject *Sender);
	void __fastcall PoliciesGamePassCheckBoxClick(TObject *Sender);
	void __fastcall PoliciesGamePassEditChange(TObject *Sender);
	void __fastcall PoliciesWebAdminCheckBoxClick(TObject *Sender);
	void __fastcall PoliciesWebAdminPortEditChange(TObject *Sender);
	void __fastcall PoliciesGroupsListViewClick(TObject *Sender);
	void __fastcall PoliciesUsersListViewClick(TObject *Sender);
	void __fastcall PolisiesBanListViewClick(TObject *Sender);
	void __fastcall PoliciesGroupsAddBitBtnClick(TObject *Sender);
	void __fastcall PoliciesGroupsDeleteBitBtnClick(TObject *Sender);
	void __fastcall PoliciesUsersAddBitBtnClick(TObject *Sender);
	void __fastcall PoliciesUsersDeleteBitBtnClick(TObject *Sender);
	void __fastcall PoliciesBanAddBitBtnClick(TObject *Sender);
	void __fastcall PoliciesBanDeleteBitBtnClick(TObject *Sender);
	void __fastcall MutatorsListViewClick(TObject *Sender);
	void __fastcall MutatorsSettingsListViewClick(TObject *Sender);
	void __fastcall GamesListViewClick(TObject *Sender);
	void __fastcall GamesSettingsListViewClick(TObject *Sender);
	void __fastcall MainSaveBitBtnClick(TObject *Sender);
	void __fastcall ServerSaveBitBtnClick(TObject *Sender);
	void __fastcall GeneralConfigAddBitBtnClick(TObject *Sender);
	void __fastcall GeneralConfigDelBitBtnClick(TObject *Sender);
	void __fastcall GeneralConfigEditBitBtnClick(TObject *Sender);
	void __fastcall PoliciesGroupsEditBitBtnClick(TObject *Sender);
	void __fastcall PoliciesUsersEditBitBtnClick(TObject *Sender);
	void __fastcall PoliciesBanEditBitBtnClick(TObject *Sender);
	void __fastcall MutatorNameEditChange(TObject *Sender);
	void __fastcall MutatorDescEditChange(TObject *Sender);
	void __fastcall MutatorLoadCheckBoxClick(TObject *Sender);
	void __fastcall MutatorNewBitBtnClick(TObject *Sender);
	void __fastcall MutatorDelBitBtnClick(TObject *Sender);
	void __fastcall MutatorSetnNewBitBtnClick(TObject *Sender);
	void __fastcall MutatorSetnEditBitBtnClick(TObject *Sender);
	void __fastcall MutatorSetnDelBitBtnClick(TObject *Sender);
	void __fastcall GamesNameEditChange(TObject *Sender);
	void __fastcall GamesDescEditChange(TObject *Sender);
	void __fastcall GamesAddBitBtnClick(TObject *Sender);
	void __fastcall GamesDelBitBtnClick(TObject *Sender);
	void __fastcall GamesSetnNewBitBtnClick(TObject *Sender);
	void __fastcall GamesSetnEditBitBtnClick(TObject *Sender);
	void __fastcall GamesSetnDelBitBtnClick(TObject *Sender);
	void __fastcall MapsShowRotCheckBoxClick(TObject *Sender);
	void __fastcall MapsListViewClick(TObject *Sender);
	void __fastcall MapsNameEditChange(TObject *Sender);
	void __fastcall MapsArgsEditChange(TObject *Sender);
	void __fastcall MapsRotateCheckBoxClick(TObject *Sender);
	void __fastcall MapsAddBitBtnClick(TObject *Sender);
	void __fastcall MapsDeleteBitBtnClick(TObject *Sender);
	void __fastcall MapsEarlierBitBtnClick(TObject *Sender);
	void __fastcall MapsLaterBitBtnClick(TObject *Sender);
	void __fastcall GeneralConfigListViewSelectItem(TObject *Sender,TListItem *Item, bool Selected);
	void __fastcall ScheduleListViewSelectItem(TObject *Sender,TListItem *Item, bool Selected);
	void __fastcall PoliciesGroupsListViewSelectItem(TObject *Sender,TListItem *Item, bool Selected);
	void __fastcall MutatorsListViewSelectItem(TObject *Sender,TListItem *Item, bool Selected);
	void __fastcall GamesListViewSelectItem(TObject *Sender, TListItem *Item,bool Selected);
	void __fastcall MapsListViewSelectItem(TObject *Sender, TListItem *Item,bool Selected);
	void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
	void __fastcall MutatorGroupEditChange(TObject *Sender);
	void __fastcall MutatorsListViewDblClick(TObject *Sender);
	void __fastcall MapsListViewDblClick(TObject *Sender);
	void __fastcall ServerMacroListViewSelectItem(TObject *Sender,TListItem *Item, bool Selected);
	void __fastcall ServerMacroListViewClick(TObject *Sender);
	void __fastcall ServerMacroAddBitBtnClick(TObject *Sender);
	void __fastcall ServerMacroDelBitBtnClick(TObject *Sender);
	void __fastcall ServerMacroNameEditChange(TObject *Sender);
	void __fastcall ServerMacroValueEditChange(TObject *Sender);
	void __fastcall ServerLogBitBtnClick(TObject *Sender);
	void __fastcall ScheduleStartBitBtnClick(TObject *Sender);
	void __fastcall ScheduleStopBitBtnClick(TObject *Sender);
	void __fastcall ScheduleRestartBitBtnClick(TObject *Sender);
	void __fastcall GamesPrefixEditChange(TObject *Sender);
	void __fastcall GamesMapListEditChange(TObject *Sender);

private:			// User declarations
	int				itsUpdateFlag;
    char			itsConfigFile[512];
    CFurserDoc		itsDoc;
    CFurserClient *	itsClient;
    CFurserSrData *	itsSrData;

public:		// User declarations
	__fastcall TMainDialog(TComponent* Owner);
	void __fastcall SetControlEnable	( TBitBtn *, bool );
	void __fastcall SetControlEnable	( TEdit *, bool, bool = true );
	void __fastcall SetControlEnable	( TCheckListBox *, bool, bool = true );
	void __fastcall SetControlEnable	( TComboBox *, bool, bool = true );
	void __fastcall SetControlEnable	( TListView *, bool, bool = true );
	void __fastcall SetControlEnable	( TCheckBox *, bool, bool = true );
	void __fastcall SetControlEnable	( TDateTimePicker *, bool, bool = true );

    void __fastcall PopulateComboBox		( TComboBox *, const CFurserString_l & );
    void __fastcall PopulateCheckListBox	( TCheckListBox *, const CFurserString_l & );
    void __fastcall SetListViewFocus		( TListView *, const char * );
    void __fastcall PopulateSettingsView	( TListView *, const CFurserSrSetn_l & );
    void __fastcall PopulateScheduleView	( TListView *, const CFurserSrEvnt_l & );
    void __fastcall PopulateGroupsListView	( TListView *, const CFurserSrGrup_l & );
    void __fastcall PopulateUsersListView	( TListView *, const CFurserSrUser_l & );
    void __fastcall PopulateBanListView		( TListView *, const CFurserSrUban_l & );
    void __fastcall PopulateMutatorListView	( TListView *, const CFurserSrMuta_l & );
    void __fastcall PopulateGamesListView	( TListView *, const CFurserSrGame_l & );
    void __fastcall PopulateMapsListView	( TListView *, const CFurserSrLevl_l &, bool );
    void __fastcall PopulateMacroListView	( TListView *, const CFurserSrMacr_l & );

    void __fastcall SendServerCommand	( char aCommand );

    char * __fastcall	Time2String		( char *, time_t );
    time_t __fastcall	GetPickerTime	( TDateTimePicker *, TDateTimePicker * );
    void   __fastcall	SetPickerTime	( TDateTimePicker *, TDateTimePicker *, time_t );

	void __fastcall	PopulateControlPane( void );
	void __fastcall	PopulateServerPane( void );
	void __fastcall	PopulateServerPaneGeneral( void );
	void __fastcall	PopulateServerPaneSchedule( void );
	void __fastcall	PopulateServerPanePolicies( void );
	void __fastcall	PopulateServerPaneMutators( void );
	void __fastcall	PopulateServerPaneGames( void );
	void __fastcall	PopulateServerPaneMaps( void );
	void __fastcall	PopulateServerPaneMacros( void );

};
//---------------------------------------------------------------------------
extern PACKAGE TMainDialog *MainDialog;
//---------------------------------------------------------------------------
#endif
