//---------------------------------------------------------------------------
// TMainDialogControlPane.cpp
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TMainDialog.h"
#include "TServerWizardDialog.h"
#include "TLogViewDialog.h"
#include "CError.hxx"

//---------------------------------------------------------------------------
void __fastcall	TMainDialog::PopulateControlPane( void ) {
	itsUpdateFlag++;

	// Set contents to the controller combo box
    TMainDialog::PopulateComboBox( MainControllerComboBox, itsDoc.ControllerNames() );

   	bool	editable = (itsClient == NULL);
	if	( ( MainControllerComboBox->ItemIndex < 0 ) && ( editable ) ) {
    	TMainDialog::SetControlEnable( MainControllerComboBox, MainControllerComboBox->Items->Count > 0 );
    	TMainDialog::SetControlEnable( MainDeleteBitBtn, false );
    	TMainDialog::SetControlEnable( MainNewBitBtn, true );
    	TMainDialog::SetControlEnable( MainConnectBitBtn, false );
    	TMainDialog::SetControlEnable( MainDisconnectBitBtn, false );
    	TMainDialog::SetControlEnable( MainIPEdit, false );
    	TMainDialog::SetControlEnable( MainPortEdit, false );
    	TMainDialog::SetControlEnable( MainPassEdit, false );
    	TMainDialog::SetControlEnable( ServerWizardBitBtn, false );
    	TMainDialog::SetControlEnable( ServersCheckListBox, false );
    }
    else {
    	TMainDialog::SetControlEnable( MainControllerComboBox,	editable, false );
    	TMainDialog::SetControlEnable( MainNewBitBtn, editable );
    	TMainDialog::SetControlEnable( MainDeleteBitBtn, editable );
    	TMainDialog::SetControlEnable( MainIPEdit, 	editable, false );
    	TMainDialog::SetControlEnable( MainPortEdit, 	editable, false );
    	TMainDialog::SetControlEnable( MainPassEdit, 	editable, false );
    	TMainDialog::SetControlEnable( MainDisconnectBitBtn, itsClient != NULL );

		CFurserController	myctl = itsDoc.GetController( TCTLCSTR(MainControllerComboBox) );
        if	( MainIPEdit->Text != myctl.Ip() )			MainIPEdit->Text = myctl.Ip();
        if	( MainPortEdit->Text != (int)myctl.Port() )	MainPortEdit->Text  = (int)myctl.Port();
        if	( MainPassEdit->Text != myctl.Pass() )		MainPassEdit->Text = myctl.Pass();

    	TMainDialog::SetControlEnable( MainConnectBitBtn,	(itsClient == NULL) &&
        													(MainIPEdit->Text != "" ) &&
                                                            (MainPassEdit->Text != "") &&
                                                            (myctl.Port() != 0 )  );
    }

	if	( itsClient == NULL ) {
		TMainDialog::SetControlEnable( ServerWizardBitBtn, false );
		TMainDialog::SetControlEnable( ServerDeleteBitBtn, false );
		TMainDialog::SetControlEnable( ServerStartBitBtn, false );
		TMainDialog::SetControlEnable( ServerStopBitBtn, false );
		TMainDialog::SetControlEnable( ServersCheckListBox, false );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, false );
    	TMainDialog::SetControlEnable( ServerLogBitBtn, false );
    }
	else {
		TMainDialog::SetControlEnable( ServerWizardBitBtn, true );
		TMainDialog::SetControlEnable( ServersCheckListBox, true );
	    TMainDialog::PopulateCheckListBox( ServersCheckListBox, itsSrData->ServerNames() );

		if	( ServersCheckListBox->ItemIndex < 0 ) {
			TMainDialog::SetControlEnable( ServerDeleteBitBtn, false );
			TMainDialog::SetControlEnable( ServerStartBitBtn, false );
			TMainDialog::SetControlEnable( ServerStopBitBtn, false );
			TMainDialog::SetControlEnable( ServerLogBitBtn, false );
		}
	    else {
			CFurserSrSrvr	mysrvr = itsSrData->GetServer( TCTLCSTR(ServersCheckListBox) );
			TMainDialog::SetControlEnable( ServerDeleteBitBtn, true );
			TMainDialog::SetControlEnable( ServerLogBitBtn, true );
			TMainDialog::SetControlEnable( ServerStartBitBtn, mysrvr.Running() == false );
			TMainDialog::SetControlEnable( ServerStopBitBtn, mysrvr.Running() == true );
        }
    }

    TMainDialog::PopulateServerPane();
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MainControllerComboBoxChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MainIPEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( MainControllerComboBox->ItemIndex < 0 )	return;
	CFurserController	myctl = itsDoc.GetController( TCTLCSTR(MainControllerComboBox) );
    int					six   = MainControllerComboBox->ItemIndex;
    myctl.Ip( MainIPEdit->Text.c_str() );
	itsDoc.SetController( TCTLCSTR(MainControllerComboBox), myctl );
    itsUpdateFlag++;
    TCTLSTR(MainControllerComboBox) = myctl.Ip();
   	TMainDialog::SetControlEnable( MainSaveBitBtn, true );
    MainControllerComboBox->ItemIndex = six;
	TMainDialog::PopulateControlPane();
    itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MainPortEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( MainControllerComboBox->ItemIndex < 0 )	return;
	CFurserController	myctl = itsDoc.GetController( TCTLCSTR(MainControllerComboBox) );
	myctl.Port( (unsigned short)::atoi( MainPortEdit->Text.c_str() ) );
	itsDoc.SetController( TCTLCSTR(MainControllerComboBox), myctl );
   	TMainDialog::SetControlEnable( MainSaveBitBtn, true );
	TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MainPassEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( MainControllerComboBox->ItemIndex < 0 )	return;
	CFurserController	myctl = itsDoc.GetController( TCTLCSTR(MainControllerComboBox) );
	myctl.Pass( MainPassEdit->Text.c_str() );
	itsDoc.SetController( TCTLCSTR(MainControllerComboBox), myctl );
   	TMainDialog::SetControlEnable( MainSaveBitBtn, true );
	TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServersCheckListBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServersCheckListBoxClickCheck(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServersCheckListBoxDblClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MainNewBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    CFurserController	myctl;
	myctl.Ip( "my.own.ip.com" );
    myctl.Port( 1717 );
    myctl.Pass( "" );
	itsDoc.AddController( myctl );
   	TMainDialog::SetControlEnable( MainSaveBitBtn, true );
    TMainDialog::PopulateControlPane();
	MainControllerComboBox->ItemIndex = MainControllerComboBox->Items->Count - 1;
    TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MainDeleteBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( MainControllerComboBox->ItemIndex < 0 )	return;
	CFurserController	myctl = itsDoc.GetController( TCTLCSTR(MainControllerComboBox) );
	itsDoc.DelController( myctl );
   	TMainDialog::SetControlEnable( MainSaveBitBtn, true );
    TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MainSaveBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	itsDoc.Save( itsConfigFile );
    itsUpdateFlag++;
   	TMainDialog::SetControlEnable( MainSaveBitBtn, false );
    itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MainConnectBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( MainControllerComboBox->ItemIndex < 0 )	return;
	CFurserController	myctl = itsDoc.GetController( TCTLCSTR(MainControllerComboBox) );
	if	( itsSrData )	delete itsSrData;
    if	( itsClient )	delete itsClient;
    itsSrData = NULL;
    itsClient = NULL;
	try {
	    itsClient = new CFurserClient( myctl.Ip(), myctl.Port(), myctl.Pass() );
        itsSrData = new CFurserSrData;
		TMainDialog::SendServerCommand( 'L' );
    }
    catch ( CError e ) {
		if	( itsSrData )	delete itsSrData;
    	if	( itsClient )	delete itsClient;
	    itsSrData = NULL;
    	itsClient = NULL;
    	Application->MessageBox(	(char *)e.Error(),
        							"Connection Error",
                                    MB_OK | MB_ICONWARNING );
    }
    catch ( ... ) {
		if	( itsSrData )	delete itsSrData;
    	if	( itsClient )	delete itsClient;
	    itsSrData = NULL;
    	itsClient = NULL;
    	Application->MessageBox(	"Not connected properly",
        							"Connection Error",
                                    MB_OK | MB_ICONWARNING );
    }
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, false );
    TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MainDisconnectBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )		return;
	if	( ServerSaveBitBtn->Enabled ) {
    	if	( Application->MessageBox(	"Do you want to loose the changes ?",
        								"Changes not saved to the server",
                                        MB_YESNO | MB_DEFBUTTON2 | MB_ICONWARNING ) ==  IDNO ) {
            return;
        }
    }
	if	( itsSrData )	delete itsSrData;
    if	( itsClient )	delete itsClient;
    itsSrData = NULL;
    itsClient = NULL;
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, false );
    TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServerSaveBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ! itsSrData )		return;
	TMainDialog::SendServerCommand( 'S' );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, false );
    TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServerStartBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ! itsSrData )		return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
	TMainDialog::SendServerCommand( 'r' );
    TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServerStopBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ! itsSrData )		return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
	TMainDialog::SendServerCommand( 's' );
    TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServerDeleteBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ! itsSrData )		return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
   	if	( Application->MessageBox(	"Do you want to remove this server ?",
       								"The server is about to be deleted",
                                    MB_YESNO | MB_DEFBUTTON2 | MB_ICONWARNING ) ==  IDNO ) {
		return;
    }

	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	itsSrData->DelServer( srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServerLogBitBtnClick(TObject *Sender) {
	char *	logtext = NULL;
	if	( itsUpdateFlag )	return;
    if	( ! itsSrData )		return;
	if	( ServersCheckListBox->ItemIndex < 0 )	return;
	try {
	    logtext = itsSrData->NetLogdata( *itsClient, NULL );
   		Application->CreateForm( __classid(TLogViewDialog), &LogViewDialog );
    	LogViewDialog->LogMemo->Lines->Text = logtext;
		LogViewDialog->ShowModal();
	    LogViewDialog->Release();
		LogViewDialog = NULL;
        delete [] logtext;
    }
    catch ( ... ) {
		if	( itsSrData )	delete itsSrData;
    	if	( itsClient )	delete itsClient;
		if	( logtext )		delete [] logtext;
	    itsSrData = NULL;
    	itsClient = NULL;
    	Application->MessageBox(	"Transfer error",
        							"Unable to show log file contents",
                                    MB_OK | MB_ICONWARNING );
	    TMainDialog::PopulateControlPane();
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServerWizardBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
   	Application->CreateForm( __classid(TServerWizardDialog), &ServerWizardDialog );
	if	( ServerWizardDialog->ShowModal() == mrOk ) {
    	int		srindex = 0;
       	char	newname[1024];
        ::strcpy( newname, ServerWizardDialog->ServerData.ServerName() );
		while	( itsSrData->HasServer( newname ) ) {
			srindex++;
	        ::sprintf( newname, "%s[%i]", ServerWizardDialog->ServerData.ServerName(), srindex );
        }
        ServerWizardDialog->ServerData.ServerName( newname );
		itsSrData->AddServer( ServerWizardDialog->ServerData );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
	Application->OnIdle = NULL;
    ServerWizardDialog->Release();
	ServerWizardDialog = NULL;
	TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
