//---------------------------------------------------------------------------
// TMainDialogServerPaneGeneral.cpp
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TMainDialog.h"
#include "TSettingsDialog.h"

//---------------------------------------------------------------------------
static char *	__MyServerTypes[] = {
	"Unreal Tournament",
    "Unreal Tournament 2003"
};

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateServerPaneGeneral( void ) {
	itsUpdateFlag++;
    if	( ServersCheckListBox->ItemIndex < 0 ) {
    	GeneralServerTypeLabel->Caption = "";
		TMainDialog::SetControlEnable( GeneralServerNameEdit, false );
		TMainDialog::SetControlEnable( GeneralServerGameRootEdit, false );
		TMainDialog::SetControlEnable( GeneralServerUccArgsEdit, false );
		TMainDialog::SetControlEnable( GeneralConfigAddBitBtn, false );
		TMainDialog::SetControlEnable( GeneralConfigEditBitBtn, false );
		TMainDialog::SetControlEnable( GeneralConfigDelBitBtn, false );
		TMainDialog::SetControlEnable( GeneralConfigListView, false );
    }
    else if	( itsSrData ) {
		CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
        GeneralServerTypeLabel->Caption = __MyServerTypes[srvr.ServerType()];
		TMainDialog::SetControlEnable( GeneralServerNameEdit, ! srvr.Running(), false );
		TMainDialog::SetControlEnable( GeneralServerGameRootEdit, ! srvr.Running(), false );
		TMainDialog::SetControlEnable( GeneralServerUccArgsEdit, ! srvr.Running(), false );
		TMainDialog::SetControlEnable( GeneralConfigAddBitBtn, ! srvr.Running() );
		TMainDialog::SetControlEnable( GeneralConfigAddBitBtn, ! srvr.Running() );
		TMainDialog::SetControlEnable( GeneralConfigListView, ! srvr.Running(), false );

        if	( GeneralServerNameEdit->Text != srvr.ServerName() ) {
        	GeneralServerNameEdit->Text = srvr.ServerName();
        }
        if	( GeneralServerGameRootEdit->Text != srvr.GameRoot() ) {
        	GeneralServerGameRootEdit->Text = srvr.GameRoot();
        }
        if	( GeneralServerUccArgsEdit->Text != srvr.ExtraUccFlags() ) {
        	GeneralServerUccArgsEdit->Text = srvr.ExtraUccFlags();
        }

        TMainDialog::PopulateSettingsView( GeneralConfigListView, srvr.SettingList() );

		TMainDialog::SetControlEnable( GeneralConfigEditBitBtn, (! srvr.Running() ) && (GeneralConfigListView->Selected) );
		TMainDialog::SetControlEnable( GeneralConfigDelBitBtn,  (! srvr.Running() ) && (GeneralConfigListView->Selected) );

    }                                                              
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GeneralServerNameEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	srvr.ServerName( GeneralServerNameEdit->Text.c_str() );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateControlPane();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GeneralServerGameRootEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	srvr.GameRoot( GeneralServerGameRootEdit->Text.c_str() );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneGeneral();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GeneralServerUccArgsEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	srvr.ExtraUccFlags( GeneralServerUccArgsEdit->Text.c_str() );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneGeneral();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GeneralConfigListViewClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPaneGeneral();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GeneralConfigAddBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrSetn	setn;
   	Application->CreateForm( __classid(TSettingsDialog), &SettingsDialog );
    setn.SettingName( "Change this name" );
	SettingsDialog->Setting = &setn;
	SettingsDialog->Populate();
	if	( SettingsDialog->ShowModal() == mrOk ) {
		srvr.AddSetting( setn );
	    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
    SettingsDialog->Release();
	SettingsDialog = NULL;
	TMainDialog::PopulateServerPaneGeneral();
	TMainDialog::SetListViewFocus( GeneralConfigListView, setn.SettingName() );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GeneralConfigEditBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
    if	( ! GeneralConfigListView->Selected )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrSetn	setn = srvr.GetSetting( GeneralConfigListView->Selected->Caption.c_str() );
   	Application->CreateForm( __classid(TSettingsDialog), &SettingsDialog );
	SettingsDialog->Setting = &setn;
	SettingsDialog->Populate();
	if	( SettingsDialog->ShowModal() == mrOk ) {
		srvr.SetSetting( GeneralConfigListView->Selected->Caption.c_str(), setn );
	    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
    SettingsDialog->Release();
	SettingsDialog = NULL;
	TMainDialog::PopulateServerPaneGeneral();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GeneralConfigDelBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
    if	( ! GeneralConfigListView->Selected )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrSetn	setn = srvr.GetSetting( GeneralConfigListView->Selected->Caption.c_str() );
	srvr.DelSetting( setn );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneGeneral();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GeneralConfigListViewSelectItem(TObject *Sender, TListItem *Item, bool Selected) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPaneGeneral();
}

//---------------------------------------------------------------------------
