//---------------------------------------------------------------------------
// TMainDialogServerPaneMaps.cpp
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TMainDialog.h"

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateServerPaneMacros( void ) {
	itsUpdateFlag++;
    if	( ServersCheckListBox->ItemIndex < 0 ) {
		TMainDialog::SetControlEnable( ServerMacroAddBitBtn, false );
        TMainDialog::SetControlEnable( ServerMacroDelBitBtn, false );
        TMainDialog::SetControlEnable( ServerMacroListView, false );
        TMainDialog::SetControlEnable( ServerMacroNameEdit, false );
        TMainDialog::SetControlEnable( ServerMacroValueEdit, false );
    }
    else if	( itsSrData ) {
		CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );

		TMainDialog::SetControlEnable( ServerMacroAddBitBtn, true );
        TMainDialog::SetControlEnable( ServerMacroListView, true );
        TMainDialog::PopulateMacroListView( ServerMacroListView, srvr.MacroList() );

        bool	editable = (ServerMacroListView->Selected != NULL);
        TMainDialog::SetControlEnable( ServerMacroDelBitBtn, editable );
        TMainDialog::SetControlEnable( ServerMacroNameEdit, editable );
        TMainDialog::SetControlEnable( ServerMacroValueEdit, editable );
		if	( editable ) {
			CFurserSrMacr	macr = srvr.GetMacro( ServerMacroListView->Selected->Caption.c_str() );
			if	( ServerMacroNameEdit->Text != macr.MacroName() ) {
            	ServerMacroNameEdit->Text = macr.MacroName();
            }
			if	( ServerMacroValueEdit->Text != macr.MacroValue() ) {
            	ServerMacroValueEdit->Text = macr.MacroValue();
            }
        }
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServerMacroListViewSelectItem(TObject *Sender,TListItem *Item, bool Selected) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPaneMacros();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServerMacroListViewClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPaneMacros();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServerMacroNameEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! ServerMacroListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	CFurserSrMacr	macr = srvr.GetMacro( ServerMacroListView->Selected->Caption.c_str() );
    macr.MacroName( ServerMacroNameEdit->Text.c_str() );
    srvr.SetMacro( ServerMacroListView->Selected->Caption.c_str(), macr );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMacros();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServerMacroValueEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! ServerMacroListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	CFurserSrMacr	macr = srvr.GetMacro( ServerMacroListView->Selected->Caption.c_str() );
    macr.MacroValue( ServerMacroValueEdit->Text.c_str() );
    srvr.SetMacro( ServerMacroListView->Selected->Caption.c_str(), macr );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMacros();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServerMacroAddBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	CFurserSrMacr	macr;
	macr.MacroName( "$(AnotherMacro)" );
    srvr.AddMacro( macr );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMacros();
	TMainDialog::SetListViewFocus( ServerMacroListView, macr.MacroName() );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ServerMacroDelBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! ServerMacroListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	CFurserSrMacr	macr = srvr.GetMacro( ServerMacroListView->Selected->Caption.c_str() );
    srvr.DelMacro( macr );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMacros();
}

//---------------------------------------------------------------------------

