//---------------------------------------------------------------------------
// TMainDialogServerPaneMutators.cpp
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TMainDialog.h"
#include "TSettingsDialog.h"

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateServerPaneMutators( void ) {
	itsUpdateFlag++;
    if	( ServersCheckListBox->ItemIndex < 0 ) {
    	TMainDialog::SetControlEnable( MutatorNewBitBtn, false );
        TMainDialog::SetControlEnable( MutatorDelBitBtn, false );
        TMainDialog::SetControlEnable( MutatorsListView, false );
        TMainDialog::SetControlEnable( MutatorNameEdit, false );
        TMainDialog::SetControlEnable( MutatorDescEdit, false );
        TMainDialog::SetControlEnable( MutatorGroupEdit, false );
        TMainDialog::SetControlEnable( MutatorSetnNewBitBtn, false );
        TMainDialog::SetControlEnable( MutatorSetnEditBitBtn, false );
        TMainDialog::SetControlEnable( MutatorSetnDelBitBtn, false );
        TMainDialog::SetControlEnable( MutatorLoadCheckBox, false );
        TMainDialog::SetControlEnable( MutatorsSettingsListView, false );
    }
    else if	( itsSrData ) {
		CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );

    	TMainDialog::SetControlEnable( MutatorNewBitBtn, true );
        TMainDialog::SetControlEnable( MutatorsListView, true );
        TMainDialog::PopulateMutatorListView( MutatorsListView, srvr.MutatorList() );

        bool	editable = (MutatorsListView->Selected != NULL);
        TMainDialog::SetControlEnable( MutatorDelBitBtn, editable );
        TMainDialog::SetControlEnable( MutatorNameEdit, editable );
        TMainDialog::SetControlEnable( MutatorDescEdit, editable );
        TMainDialog::SetControlEnable( MutatorGroupEdit, editable );
        TMainDialog::SetControlEnable( MutatorSetnNewBitBtn, editable );
        TMainDialog::SetControlEnable( MutatorLoadCheckBox, editable );
        TMainDialog::SetControlEnable( MutatorsSettingsListView, editable );

        if	( editable ) {
        	CFurserSrMuta	muta = srvr.GetMutator( MutatorsListView->Selected->Caption.c_str() );
            if	( MutatorNameEdit->Text != muta.MutatorName() ) {
            	MutatorNameEdit->Text = muta.MutatorName();
            }
            if	( MutatorDescEdit->Text != muta.Description() ) {
            	MutatorDescEdit->Text = muta.Description();
            }
            if	( MutatorGroupEdit->Text != muta.Group() ) {
            	MutatorGroupEdit->Text = muta.Group();
            }
			MutatorLoadCheckBox->Checked = muta.LoadFlag();
            TMainDialog::PopulateSettingsView( MutatorsSettingsListView, muta.SettingList() );
			editable = (MutatorsSettingsListView->Selected != NULL);

	        TMainDialog::SetControlEnable( MutatorSetnEditBitBtn, editable );
    	    TMainDialog::SetControlEnable( MutatorSetnDelBitBtn, editable );

        }
        else {
	        TMainDialog::SetControlEnable( MutatorSetnEditBitBtn, false );
    	    TMainDialog::SetControlEnable( MutatorSetnDelBitBtn, false );
        }
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MutatorsListViewClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPaneMutators();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MutatorsSettingsListViewClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPaneMutators();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MutatorNameEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MutatorsListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrMuta	muta = srvr.GetMutator( MutatorsListView->Selected->Caption.c_str() );
	muta.MutatorName( MutatorNameEdit->Text.c_str() );
    srvr.SetMutator( MutatorsListView->Selected->Caption.c_str(), muta );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMutators();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MutatorDescEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MutatorsListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrMuta	muta = srvr.GetMutator( MutatorsListView->Selected->Caption.c_str() );
	muta.Description( MutatorDescEdit->Text.c_str() );
    srvr.SetMutator( MutatorsListView->Selected->Caption.c_str(), muta );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMutators();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MutatorGroupEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MutatorsListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrMuta	muta = srvr.GetMutator( MutatorsListView->Selected->Caption.c_str() );
	muta.Group( MutatorGroupEdit->Text.c_str() );
    srvr.SetMutator( MutatorsListView->Selected->Caption.c_str(), muta );
    srvr.ScanLoadFlags();
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMutators();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MutatorLoadCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MutatorsListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    srvr.SetLoadFlag( MutatorsListView->Selected->Caption.c_str(), MutatorLoadCheckBox->Checked );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMutators();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MutatorsListViewDblClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MutatorsListView->Selected )		return;
    MutatorLoadCheckBox->Checked = ! MutatorLoadCheckBox->Checked;
    TMainDialog::MutatorLoadCheckBoxClick( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MutatorNewBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrMuta	muta;
    muta.MutatorName( "Another Mutator" );
    srvr.AddMutator( muta );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMutators();
	TMainDialog::SetListViewFocus( MutatorsListView, muta.MutatorName() );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MutatorDelBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MutatorsListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrMuta	muta = srvr.GetMutator( MutatorsListView->Selected->Caption.c_str() );
    srvr.DelMutator( muta );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMutators();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MutatorSetnNewBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MutatorsListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrMuta	muta = srvr.GetMutator( MutatorsListView->Selected->Caption.c_str() );
    CFurserSrSetn	setn;
   	Application->CreateForm( __classid(TSettingsDialog), &SettingsDialog );
    setn.SettingName( "Change this name" );
	SettingsDialog->Setting = &setn;
	SettingsDialog->Populate();
	if	( SettingsDialog->ShowModal() == mrOk ) {
		muta.AddSetting( setn );
	    srvr.SetMutator( MutatorsListView->Selected->Caption.c_str(), muta );
	    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
    SettingsDialog->Release();
	SettingsDialog = NULL;
	TMainDialog::PopulateServerPaneMutators();
	TMainDialog::SetListViewFocus( MutatorsSettingsListView, setn.SettingName() );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MutatorSetnEditBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MutatorsListView->Selected )		return;
	if	( ! MutatorsSettingsListView->Selected )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrMuta	muta = srvr.GetMutator( MutatorsListView->Selected->Caption.c_str() );
    CFurserSrSetn	setn = muta.GetSetting( MutatorsSettingsListView->Selected->Caption.c_str() );
   	Application->CreateForm( __classid(TSettingsDialog), &SettingsDialog );
	SettingsDialog->Setting = &setn;
	SettingsDialog->Populate();
	if	( SettingsDialog->ShowModal() == mrOk ) {
		muta.SetSetting( MutatorsSettingsListView->Selected->Caption.c_str(), setn );
	    srvr.SetMutator( MutatorsListView->Selected->Caption.c_str(), muta );
	    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
    SettingsDialog->Release();
	SettingsDialog = NULL;
	TMainDialog::PopulateServerPaneMutators();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MutatorSetnDelBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! MutatorsListView->Selected )		return;
	if	( ! MutatorsSettingsListView->Selected )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrMuta	muta = srvr.GetMutator( MutatorsListView->Selected->Caption.c_str() );
    CFurserSrSetn	setn = muta.GetSetting( MutatorsSettingsListView->Selected->Caption.c_str() );
	muta.DelSetting( setn );
    srvr.SetMutator( MutatorsListView->Selected->Caption.c_str(), muta );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPaneMutators();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MutatorsListViewSelectItem(TObject *Sender,TListItem *Item, bool Selected) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPaneMutators();
}

//---------------------------------------------------------------------------
