//---------------------------------------------------------------------------
// TMainDialogServerPanePolicies.cpp
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TMainDialog.h"
#include "TGroupEditDialog.h"
#include "TUserEditDialog.h"
#include "TBanEditDialog.h"

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateServerPanePolicies( void ) {
	itsUpdateFlag++;
    if	( ServersCheckListBox->ItemIndex < 0 ) {
		TMainDialog::SetControlEnable( PoliciesAdminCheckBox, false );
		TMainDialog::SetControlEnable( PoliciesAdminNameEdit, false );
		TMainDialog::SetControlEnable( PoliciesAdminPassEdit, false );
		TMainDialog::SetControlEnable( PoliciesGamePassCheckBox, false );
		TMainDialog::SetControlEnable( PoliciesGamePassEdit, false );
		TMainDialog::SetControlEnable( PoliciesWebAdminCheckBox, false );
		TMainDialog::SetControlEnable( PoliciesWebAdminPortEdit, false );
		TMainDialog::SetControlEnable( PoliciesGroupsAddBitBtn, false );
		TMainDialog::SetControlEnable( PoliciesGroupsEditBitBtn, false );
		TMainDialog::SetControlEnable( PoliciesGroupsDeleteBitBtn, false );
		TMainDialog::SetControlEnable( PoliciesGroupsListView, false );
		TMainDialog::SetControlEnable( PoliciesUsersAddBitBtn, false );
		TMainDialog::SetControlEnable( PoliciesUsersDeleteBitBtn, false );
		TMainDialog::SetControlEnable( PoliciesUsersEditBitBtn, false );
		TMainDialog::SetControlEnable( PoliciesUsersListView, false );
		TMainDialog::SetControlEnable( PoliciesBanAddBitBtn, false );
		TMainDialog::SetControlEnable( PoliciesBanDeleteBitBtn, false );
		TMainDialog::SetControlEnable( PoliciesBanEditBitBtn, false );
		TMainDialog::SetControlEnable( PolisiesBanListView, false );
    }
    else if	( itsSrData ) {
		CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );

		TMainDialog::SetControlEnable( PoliciesAdminCheckBox, true );
        PoliciesAdminCheckBox->Checked = srvr.UsesAdminName();
		TMainDialog::SetControlEnable( PoliciesAdminNameEdit, srvr.UsesAdminName() );
		TMainDialog::SetControlEnable( PoliciesAdminPassEdit, srvr.UsesAdminName() );
        if	( srvr.UsesAdminName() ) {
			if	( PoliciesAdminNameEdit->Text != srvr.AdminName() ) {
	        	PoliciesAdminNameEdit->Text = srvr.AdminName();
            }
            if	( PoliciesAdminPassEdit->Text != srvr.AdminPass() ) {
	        	PoliciesAdminPassEdit->Text = srvr.AdminPass();
            }
		}

		TMainDialog::SetControlEnable( PoliciesGamePassCheckBox, true );
        PoliciesGamePassCheckBox->Checked = srvr.UsesGamePass();
		TMainDialog::SetControlEnable( PoliciesGamePassEdit, srvr.UsesGamePass() );
        if	( srvr.UsesGamePass() ) {
        	if	( PoliciesGamePassEdit->Text != srvr.GamePass() ) {
	        	PoliciesGamePassEdit->Text = srvr.GamePass();
            }
        }

		TMainDialog::SetControlEnable( PoliciesWebAdminCheckBox, true );
        PoliciesWebAdminCheckBox->Checked = srvr.UsesWebAdmin();
		TMainDialog::SetControlEnable( PoliciesWebAdminPortEdit, srvr.UsesWebAdmin() );
		if	( srvr.UsesWebAdmin() ) {
        	AnsiString	portstr = srvr.WebAdminPort();
        	if	( PoliciesWebAdminPortEdit->Text != portstr ) {
	        	PoliciesWebAdminPortEdit->Text = portstr;
            }
        }

		if	( srvr.ServerType() > 0 ) {
			TMainDialog::SetControlEnable( PoliciesGroupsAddBitBtn, true );
			TMainDialog::SetControlEnable( PoliciesGroupsListView, true );
        	TMainDialog::PopulateGroupsListView( PoliciesGroupsListView, srvr.GroupList() );
			TMainDialog::SetControlEnable( PoliciesGroupsEditBitBtn, PoliciesGroupsListView->Selected != NULL );
			TMainDialog::SetControlEnable( PoliciesGroupsDeleteBitBtn, PoliciesGroupsListView->Selected != NULL );

			TMainDialog::SetControlEnable( PoliciesUsersAddBitBtn, true );
			TMainDialog::SetControlEnable( PoliciesUsersListView, true );
        	TMainDialog::PopulateUsersListView( PoliciesUsersListView, srvr.UserList() );
			TMainDialog::SetControlEnable( PoliciesUsersDeleteBitBtn, PoliciesUsersListView->Selected != NULL );
			TMainDialog::SetControlEnable( PoliciesUsersEditBitBtn, PoliciesUsersListView->Selected != NULL );
        }
        else {
			TMainDialog::SetControlEnable( PoliciesGroupsAddBitBtn, false );
			TMainDialog::SetControlEnable( PoliciesGroupsListView, false );
			TMainDialog::SetControlEnable( PoliciesGroupsEditBitBtn, false );
			TMainDialog::SetControlEnable( PoliciesGroupsDeleteBitBtn, false );
			TMainDialog::SetControlEnable( PoliciesUsersAddBitBtn, false );
			TMainDialog::SetControlEnable( PoliciesUsersListView, false );
			TMainDialog::SetControlEnable( PoliciesUsersDeleteBitBtn, false );
			TMainDialog::SetControlEnable( PoliciesUsersEditBitBtn, false );
        }

		TMainDialog::SetControlEnable( PoliciesBanAddBitBtn, true );
		TMainDialog::SetControlEnable( PolisiesBanListView, true );
        TMainDialog::PopulateBanListView( PolisiesBanListView, srvr.BanList() );
		TMainDialog::SetControlEnable( PoliciesBanDeleteBitBtn, PolisiesBanListView->Selected != NULL );
		TMainDialog::SetControlEnable( PoliciesBanEditBitBtn, PolisiesBanListView->Selected != NULL );
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesAdminCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	srvr.UsesAdminName( PoliciesAdminCheckBox->Checked );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesAdminNameEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	srvr.AdminName( PoliciesAdminNameEdit->Text.c_str() );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesAdminPassEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	srvr.AdminPass( PoliciesAdminPassEdit->Text.c_str() );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesGamePassCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	srvr.UsesGamePass( PoliciesGamePassCheckBox->Checked );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesGamePassEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	srvr.GamePass( PoliciesGamePassEdit->Text.c_str() );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesWebAdminCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	srvr.UsesWebAdmin( PoliciesWebAdminCheckBox->Checked );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesWebAdminPortEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
	srvr.WebAdminPort( (unsigned short)::atoi(PoliciesWebAdminPortEdit->Text.c_str()) );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesGroupsListViewClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesUsersListViewClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PolisiesBanListViewClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesGroupsDeleteBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! PoliciesGroupsListView->Selected )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrGrup	grup = srvr.GetGroup( PoliciesGroupsListView->Selected->Caption.c_str() );
	srvr.DelGroup( grup );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesUsersDeleteBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! PoliciesUsersListView->Selected )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrUser	user = srvr.GetUser( PoliciesUsersListView->Selected->Caption.c_str() );
    srvr.DelUser( user );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesBanDeleteBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! PolisiesBanListView->Selected )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrUban	uban = srvr.GetBan( PolisiesBanListView->Selected->Caption.c_str() );
    srvr.DelBan( uban );
    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesGroupsAddBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrGrup	grup;
   	Application->CreateForm( __classid(TGroupEditDialog), &GroupEditDialog );
	grup.GroupName( "Another Group" );
	GroupEditDialog->GroupData = &grup;
	GroupEditDialog->Populate();
	if	( GroupEditDialog->ShowModal() == mrOk ) {
		srvr.AddGroup( grup );
	    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
    GroupEditDialog->Release();
	GroupEditDialog = NULL;
	TMainDialog::PopulateServerPanePolicies();
	TMainDialog::SetListViewFocus( PoliciesGroupsListView, grup.GroupName() );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesGroupsEditBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! PoliciesGroupsListView->Selected )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrGrup	grup = srvr.GetGroup( PoliciesGroupsListView->Selected->Caption.c_str() );
   	Application->CreateForm( __classid(TGroupEditDialog), &GroupEditDialog );
	GroupEditDialog->GroupData = &grup;
	GroupEditDialog->Populate();
	if	( GroupEditDialog->ShowModal() == mrOk ) {
		srvr.SetGroup( PoliciesGroupsListView->Selected->Caption.c_str(), grup );
	    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
    GroupEditDialog->Release();
	GroupEditDialog = NULL;
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesUsersAddBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrUser	user;
   	Application->CreateForm( __classid(TUserEditDialog), &UserEditDialog );
	UserEditDialog->ServerData	= &srvr;
	UserEditDialog->UserData	= &user;
    user.UserName( "AnotherUser" );
	UserEditDialog->Populate();
	if	( UserEditDialog->ShowModal() == mrOk ) {
		srvr.AddUser( user );
	    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
    UserEditDialog->Release();
	UserEditDialog = NULL;
	TMainDialog::PopulateServerPanePolicies();
	TMainDialog::SetListViewFocus( PoliciesUsersListView, user.UserName() );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesUsersEditBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! PoliciesUsersListView->Selected )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrUser	user = srvr.GetUser( PoliciesUsersListView->Selected->Caption.c_str() );
   	Application->CreateForm( __classid(TUserEditDialog), &UserEditDialog );
	UserEditDialog->ServerData	= &srvr;
	UserEditDialog->UserData	= &user;
	UserEditDialog->Populate();
	if	( UserEditDialog->ShowModal() == mrOk ) {
		srvr.SetUser( PoliciesUsersListView->Selected->Caption.c_str(), user );
	    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
    UserEditDialog->Release();
	UserEditDialog = NULL;
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesBanAddBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrUban	uban;
   	Application->CreateForm( __classid(TBanEditDialog), &BanEditDialog );
	BanEditDialog->BanData	= &uban;
    uban.BanName( "AnotherBan" );
	BanEditDialog->Populate();
	if	( BanEditDialog->ShowModal() == mrOk ) {
		srvr.AddBan( uban );
	    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
    BanEditDialog->Release();
	BanEditDialog = NULL;
	TMainDialog::PopulateServerPanePolicies();
	TMainDialog::SetListViewFocus( PolisiesBanListView, uban.BanName() );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesBanEditBitBtnClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( ServersCheckListBox->ItemIndex < 0 )	return;
	if	( ! PolisiesBanListView->Selected )		return;
	CFurserSrSrvr	srvr = itsSrData->GetServer( TCTLCSTR( ServersCheckListBox ) );
    CFurserSrUban	uban = srvr.GetBan( PolisiesBanListView->Selected->Caption.c_str() );
   	Application->CreateForm( __classid(TBanEditDialog), &BanEditDialog );
	BanEditDialog->BanData	= &uban;
	BanEditDialog->Populate();
	if	( BanEditDialog->ShowModal() == mrOk ) {
		srvr.SetBan( PolisiesBanListView->Selected->Caption.c_str(), uban );
	    itsSrData->SetServer( TCTLCSTR( ServersCheckListBox ), srvr );
	   	TMainDialog::SetControlEnable( ServerSaveBitBtn, true );
    }
    BanEditDialog->Release();
	BanEditDialog = NULL;
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PoliciesGroupsListViewSelectItem(TObject *Sender, TListItem *Item, bool Selected) {
	if	( itsUpdateFlag )	return;
	TMainDialog::PopulateServerPanePolicies();
}

//---------------------------------------------------------------------------
