//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TMainDialog.h"
#include "TProgressDialog.h"
#include "CError.hxx"

//---------------------------------------------------------------------------
static const char *	__scheduleTypeName[4] = {
	"Once", "Hourly", "Daily", "Weekly"
};

//---------------------------------------------------------------------------
static const char *	__scheduleJobName[4] = {
	"Nothing", "Start", "Stop", "Restart"
};

//---------------------------------------------------------------------------
static const char *	__banModeName[2] = {
	"By IP", "By ID"
};

//---------------------------------------------------------------------------
// local:	Thread for load progress
//---------------------------------------------------------------------------
typedef struct {
    CFurserSrData *	data;
    CFurserClient *	client;
}	srdata_t;

static int	__fastcall	__loadThread( void * aSrData ) {
	srdata_t *	mydata = (srdata_t *)aSrData;

    try {
		mydata->data->NetLoad( *(mydata->client) );
    }

    catch ( CError e ) {
		mydata->data->Error( e );
	}

    catch ( ... ) {
		mydata->data->Error( CError("Unknown error") );
    }
    mydata->data->Abort();
	delete mydata;
    return	0;
}

static int	__fastcall	__saveThread( void * aSrData ) {
	srdata_t *	mydata = (srdata_t *)aSrData;

    try {
		mydata->data->NetSave( *(mydata->client) );
    }

    catch ( CError e ) {
		mydata->data->Error( e );
	}

    catch ( ... ) {
		mydata->data->Error( CError("Unknown error") );
    }
    mydata->data->Abort();
	delete mydata;
    return	0;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SetListViewFocus		( TListView * aLv, const char * aN ) {
	TListItem * item = aLv->FindCaption( 0, aN, false, false, false );
    if	( item ) {
		item->MakeVisible( false );
        aLv->Selected = item;
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateMacroListView	( TListView * aLv, const CFurserSrMacr_l & aSl ){
	int					ix	= 0;
	CFurserSrMacr_lci	loop;
    TListItem *			sele = aLv->Selected;

	if	( aSl.size() > 0 ) {
	    for	( loop = aSl.begin(); loop != aSl.end(); loop++ ) {
			if	( ix < aLv->Items->Count ) {
				if	( aLv->Items->Item[ix]->Caption != (*loop).MacroName() ) {
					aLv->Items->Item[ix]->Caption = (*loop).MacroName();
	            }
				if	( aLv->Items->Item[ix]->SubItems->Strings[0] != (*loop).MacroValue() ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[0] = (*loop).MacroValue();
            	}
	        }
    	    else {
        		aLv->Items->Add();
				aLv->Items->Item[ix]->Caption = (*loop).MacroName();
	            aLv->Items->Item[ix]->SubItems->Add( (*loop).MacroValue() );
    	    }
            ix++;
	    }
    	while	( aLv->Items->Count > ix ) {
    		if	( sele == aLv->Items->Item[ix] ) {
        		sele = NULL;
	        }
			aLv->Items->Delete( ix );
	    }
		if	( ix == 0 ) sele = NULL;
	    aLv->Selected = sele;
	}
    else {
    	aLv->Items->Clear();
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateMapsListView	( TListView * aLv, const CFurserSrLevl_l & aSl, bool aRoto ){
	int					ix	= 0;
	CFurserSrLevl_lci	loop;
    TListItem *			sele = aLv->Selected;
    AnsiString			bools;

	if	( aSl.size() > 0 ) {
	    for	( loop = aSl.begin(); loop != aSl.end(); loop++ ) {
        	if	( ( aRoto ) && ( ! (*loop).Rotate() ) )	continue;
			if	( ix < aLv->Items->Count ) {
				if	( aLv->Items->Item[ix]->Caption != (*loop).MapName() ) {
					aLv->Items->Item[ix]->Caption = (*loop).MapName();
	            }
                bools = (*loop).Rotate() ? "Yes" : "No";
				if	( aLv->Items->Item[ix]->SubItems->Strings[0] != bools ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[0] = bools;
            	}
				if	( aLv->Items->Item[ix]->SubItems->Strings[1] != (*loop).GameClass() ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[1] = (*loop).GameClass();
            	}
	        }
    	    else {
        		aLv->Items->Add();
				aLv->Items->Item[ix]->Caption = (*loop).MapName();
                bools = (*loop).Rotate() ? "Yes" : "No";
	            aLv->Items->Item[ix]->SubItems->Add( bools );
	            aLv->Items->Item[ix]->SubItems->Add( (*loop).GameClass() );
    	    }
            ix++;
	    }
    	while	( aLv->Items->Count > ix ) {
    		if	( sele == aLv->Items->Item[ix] ) {
        		sele = NULL;
	        }
			aLv->Items->Delete( ix );
	    }
		if	( ix == 0 ) sele = NULL;
	    aLv->Selected = sele;
	}
    else {
    	aLv->Items->Clear();
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateGamesListView	( TListView * aLv, const CFurserSrGame_l & aSl ){
	int					ix	= 0;
	CFurserSrGame_lci	loop;
    TListItem *			sele = aLv->Selected;

	if	( aSl.size() > 0 ) {
	    for	( loop = aSl.begin(); loop != aSl.end(); loop++, ix++ ) {
			if	( ix < aLv->Items->Count ) {
				if	( aLv->Items->Item[ix]->Caption != (*loop).GameName() ) {
					aLv->Items->Item[ix]->Caption = (*loop).GameName();
	            }
				if	( aLv->Items->Item[ix]->SubItems->Strings[0] != (*loop).Description() ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[0] = (*loop).Description();
            	}
	        }
    	    else {
        		aLv->Items->Add();
				aLv->Items->Item[ix]->Caption = (*loop).GameName();
	            aLv->Items->Item[ix]->SubItems->Add( (*loop).Description() );
    	    }
	    }
    	while	( aLv->Items->Count > ix ) {
    		if	( sele == aLv->Items->Item[ix] ) {
        		sele = NULL;
	        }
			aLv->Items->Delete( ix );
	    }
		if	( ix == 0 ) sele = NULL;
	    aLv->Selected = sele;
	}
    else {
    	aLv->Items->Clear();
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateMutatorListView( TListView * aLv, const CFurserSrMuta_l & aSl ) {
	int					ix	= 0;
	CFurserSrMuta_lci	loop;
    TListItem *			sele = aLv->Selected;
    AnsiString			bools;

	if	( aSl.size() > 0 ) {
	    for	( loop = aSl.begin(); loop != aSl.end(); loop++, ix++ ) {
			if	( ix < aLv->Items->Count ) {
				if	( aLv->Items->Item[ix]->Caption != (*loop).MutatorName() ) {
					aLv->Items->Item[ix]->Caption = (*loop).MutatorName();
	            }
				bools = (*loop).LoadFlag() ? "Yes" : "No";
				if	( aLv->Items->Item[ix]->SubItems->Strings[0] != bools ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[0] = bools;
            	}
				if	( aLv->Items->Item[ix]->SubItems->Strings[1] != (*loop).Description() ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[1] = (*loop).Description();
            	}
	        }
    	    else {
        		aLv->Items->Add();
				aLv->Items->Item[ix]->Caption = (*loop).MutatorName();
				bools = (*loop).LoadFlag() ? "Yes" : "No";
	            aLv->Items->Item[ix]->SubItems->Add( bools );
    	        aLv->Items->Item[ix]->SubItems->Add( (*loop).Description() );
    	    }
	    }
    	while	( aLv->Items->Count > ix ) {
    		if	( sele == aLv->Items->Item[ix] ) {
        		sele = NULL;
	        }
			aLv->Items->Delete( ix );
	    }
		if	( ix == 0 ) sele = NULL;
	    aLv->Selected = sele;
	}
    else {
    	aLv->Items->Clear();
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateGroupsListView	( TListView * aLv, const CFurserSrGrup_l & aSl ) {
	int					ix	= 0;
	CFurserSrGrup_lci	loop;
    TListItem *			sele = aLv->Selected;
    AnsiString			numb;

	if	( aSl.size() > 0 ) {
	    for	( loop = aSl.begin(); loop != aSl.end(); loop++, ix++ ) {
			if	( ix < aLv->Items->Count ) {
				if	( aLv->Items->Item[ix]->Caption != (*loop).GroupName() ) {
					aLv->Items->Item[ix]->Caption = (*loop).GroupName();
	            }
                numb = (*loop).GameSecLevel();
				if	( aLv->Items->Item[ix]->SubItems->Strings[0] != numb ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[0] = numb;
            	}
				if	( aLv->Items->Item[ix]->SubItems->Strings[1] != (*loop).Comment() ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[1] = (*loop).Comment();
            	}
	        }
    	    else {
        		aLv->Items->Add();
				aLv->Items->Item[ix]->Caption = (*loop).GroupName();
                numb = (*loop).GameSecLevel();
	            aLv->Items->Item[ix]->SubItems->Add( numb );
    	        aLv->Items->Item[ix]->SubItems->Add( (*loop).Comment() );
    	    }
	    }
    	while	( aLv->Items->Count > ix ) {
    		if	( sele == aLv->Items->Item[ix] ) {
        		sele = NULL;
	        }
			aLv->Items->Delete( ix );
	    }
		if	( ix == 0 ) sele = NULL;
	    aLv->Selected = sele;
	}
    else {
    	aLv->Items->Clear();
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateUsersListView	( TListView * aLv, const CFurserSrUser_l & aSl ) {
	int					ix	= 0;
	CFurserSrUser_lci	loop;
    TListItem *			sele = aLv->Selected;
    AnsiString			numbf;

	if	( aSl.size() > 0 ) {
	    for	( loop = aSl.begin(); loop != aSl.end(); loop++, ix++ ) {
			if	( ix < aLv->Items->Count ) {
				if	( aLv->Items->Item[ix]->Caption != (*loop).UserName() ) {
					aLv->Items->Item[ix]->Caption = (*loop).UserName();
	            }
                numbf = (*loop).SecurityLevel();
				if	( aLv->Items->Item[ix]->SubItems->Strings[0] != numbf ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[0] = numbf;
            	}
				if	( aLv->Items->Item[ix]->SubItems->Strings[1] != (*loop).Comment() ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[1] = (*loop).Comment();
            	}
	        }
    	    else {
        		aLv->Items->Add();
				aLv->Items->Item[ix]->Caption = (*loop).UserName();
                numbf = (*loop).SecurityLevel();
	            aLv->Items->Item[ix]->SubItems->Add( numbf );
    	        aLv->Items->Item[ix]->SubItems->Add( (*loop).Comment() );
    	    }
	    }
    	while	( aLv->Items->Count > ix ) {
    		if	( sele == aLv->Items->Item[ix] ) {
        		sele = NULL;
	        }
			aLv->Items->Delete( ix );
	    }
		if	( ix == 0 ) sele = NULL;
	    aLv->Selected = sele;
	}
    else {
    	aLv->Items->Clear();
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateBanListView	 ( TListView * aLv, const CFurserSrUban_l & aSl ) {
	int					ix	= 0;
	CFurserSrUban_lci	loop;
    TListItem *			sele = aLv->Selected;
    AnsiString			modst;

	if	( aSl.size() > 0 ) {
	    for	( loop = aSl.begin(); loop != aSl.end(); loop++, ix++ ) {
			if	( ix < aLv->Items->Count ) {
				if	( aLv->Items->Item[ix]->Caption != (*loop).BanName() ) {
					aLv->Items->Item[ix]->Caption = (*loop).BanName();
	            }
                modst = ( *loop ).Enabled() ? __banModeName[(*loop).BanType()] : "None";
				if	( aLv->Items->Item[ix]->SubItems->Strings[0] != modst ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[0] = modst;
            	}
				if	( aLv->Items->Item[ix]->SubItems->Strings[1] != (*loop).BanArgs() ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[1] = (*loop).BanArgs();
            	}
	        }
    	    else {
        		aLv->Items->Add();
				aLv->Items->Item[ix]->Caption = (*loop).BanName();
                modst = ( *loop ).Enabled() ? __banModeName[(*loop).BanType()] : "None";
	            aLv->Items->Item[ix]->SubItems->Add( modst );
    	        aLv->Items->Item[ix]->SubItems->Add( (*loop).BanArgs() );
    	    }
	    }
    	while	( aLv->Items->Count > ix ) {
    		if	( sele == aLv->Items->Item[ix] ) {
        		sele = NULL;
	        }
			aLv->Items->Delete( ix );
	    }
		if	( ix == 0 ) sele = NULL;
	    aLv->Selected = sele;
	}
    else {
    	aLv->Items->Clear();
    }
}

//---------------------------------------------------------------------------
time_t __fastcall	TMainDialog::GetPickerTime	( TDateTimePicker * aDp, TDateTimePicker * aTp ) {
	unsigned short	hh , mm, ss, ms, yy, mo, dd;
	struct	tm	mytm;
    time_t		mytime	= ::time( NULL );
    ::memcpy( &mytm, ::localtime( &mytime ), sizeof( mytm ) );
    aTp->Time.DecodeTime( &hh, &mm, &ss, &ms );
    aDp->Time.DecodeDate( &yy, &mo, &dd );
    mytm.tm_sec		= ss;
    mytm.tm_min		= mm;
    mytm.tm_hour	= hh;
    mytm.tm_mday	= dd;
    mytm.tm_mon		= mo - 1;
    mytm.tm_year	= yy - 1900;
	return ::mktime( &mytm );
}

//---------------------------------------------------------------------------
void   __fastcall	TMainDialog::SetPickerTime	( TDateTimePicker *aDp, TDateTimePicker * aTp, time_t aTt ) {
	struct tm *	mytm = ::localtime( &aTt );
    TDateTime	dd(	(unsigned short)(mytm->tm_year + 1900),
    			  	(unsigned short)(mytm->tm_mon + 1),
    			  	(unsigned short)(mytm->tm_mday) );
	TDateTime	tt(	(unsigned short)(mytm->tm_hour),
				   	(unsigned short)(mytm->tm_min),
                    (unsigned short)(mytm->tm_sec),
                    (unsigned short)0 );
	aDp->Time = dd;
	aDp->Date = dd;
    aTp->Time = tt;
}

//---------------------------------------------------------------------------
char * __fastcall	TMainDialog::Time2String	( char * aTs, time_t aTt ) {
	struct tm *	mytm = ::localtime( &aTt );
	::sprintf(	aTs, "%04d-%02d-%02d %02d:%02d:%02d",
                mytm->tm_year + 1900,
                mytm->tm_mon + 1,
                mytm->tm_mday,
                mytm->tm_hour,
                mytm->tm_min,
                mytm->tm_sec );
	return	aTs;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateScheduleView( TListView * aLv, const CFurserSrEvnt_l & aSl ) {
	int					ix	= 0;
	CFurserSrEvnt_lci	loop;
    TListItem *			sele = aLv->Selected;
    char				tbuf[32];

	if	( aSl.size() > 0 ) {
	    for	( loop = aSl.begin(); loop != aSl.end(); loop++, ix++ ) {
			if	( ix < aLv->Items->Count ) {
				if	( aLv->Items->Item[ix]->Caption != (*loop).EventName() ) {
					aLv->Items->Item[ix]->Caption = (*loop).EventName();
	            }
				if	( aLv->Items->Item[ix]->SubItems->Strings[0] != __scheduleTypeName[(*loop).EventType()] ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[0] = __scheduleTypeName[(*loop).EventType()];
            	}
				if	( aLv->Items->Item[ix]->SubItems->Strings[1] != TMainDialog::Time2String( tbuf, (int)(*loop).StartTime() ) ) {
		            aLv->Items->Item[ix]->SubItems->Strings[1] = tbuf;
        	    }
				if	( aLv->Items->Item[ix]->SubItems->Strings[2] != __scheduleJobName[(*loop).StartTask()] ) {
		            aLv->Items->Item[ix]->SubItems->Strings[2] = __scheduleJobName[(*loop).StartTask()];
    	        }
				if	( aLv->Items->Item[ix]->SubItems->Strings[3] != TMainDialog::Time2String( tbuf, (int)(*loop).EndTime() ) ) {
	        	    aLv->Items->Item[ix]->SubItems->Strings[3] = tbuf;
	            }
				if	( aLv->Items->Item[ix]->SubItems->Strings[4] != __scheduleJobName[(*loop).EndTask()] ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[4] = __scheduleJobName[(*loop).EndTask()];
            	}
	        }
    	    else {
        		aLv->Items->Add();
				aLv->Items->Item[ix]->Caption = (*loop).EventName();
	            aLv->Items->Item[ix]->SubItems->Add( __scheduleTypeName[(*loop).EventType()] );
    	        aLv->Items->Item[ix]->SubItems->Add( TMainDialog::Time2String( tbuf, (int)(*loop).StartTime() ) );
        	    aLv->Items->Item[ix]->SubItems->Add( __scheduleJobName[(*loop).StartTask()] );
            	aLv->Items->Item[ix]->SubItems->Add( TMainDialog::Time2String( tbuf, (int)(*loop).EndTime() ) );
	            aLv->Items->Item[ix]->SubItems->Add( __scheduleJobName[(*loop).EndTask()] );
    	    }
	    }
    	while	( aLv->Items->Count > ix ) {
    		if	( sele == aLv->Items->Item[ix] ) {
        		sele = NULL;
	        }
			aLv->Items->Delete( ix );
	    }
		if	( ix == 0 ) sele = NULL;
	    aLv->Selected = sele;
	}
    else {
    	aLv->Items->Clear();
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateSettingsView( TListView * aLv, const CFurserSrSetn_l & aSl ) {
	int					ix	= 0;
	CFurserSrSetn_lci	loop;
    TListItem *			sele = aLv->Selected;

    if	( aSl.size() > 0 ) {
	    for	( loop = aSl.begin(); loop != aSl.end(); loop++, ix++ ) {
			if	( ix < aLv->Items->Count ) {
				if	( aLv->Items->Item[ix]->Caption != (*loop).SettingName() ) {
					aLv->Items->Item[ix]->Caption = (*loop).SettingName();
	            }
    	        if	( aLv->Items->Item[ix]->SubItems->Strings[0] != (*loop).IniItemName() ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[0] = (*loop).IniItemName();
            	}
    	        if	( aLv->Items->Item[ix]->SubItems->Strings[1] != (*loop).SettingValu() ) {
	    	        aLv->Items->Item[ix]->SubItems->Strings[1] = (*loop).SettingValu();
            	}
	        }
    	    else {
        		aLv->Items->Add();
				aLv->Items->Item[ix]->Caption = (*loop).SettingName();
	            aLv->Items->Item[ix]->SubItems->Add( (*loop).IniItemName() );
	            aLv->Items->Item[ix]->SubItems->Add( (*loop).SettingValu() );
    	    }
	    }
    	while	( aLv->Items->Count > ix ) {
    		if	( sele == aLv->Items->Item[ix] ) {
	        	sele = NULL;
    	    }
			aLv->Items->Delete( ix );
	    }
		if	( ix == 0 ) sele = NULL;
	    aLv->Selected = sele;
	}
    else {
    	aLv->Items->Clear();
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SendServerCommand	( char aCommand ) {
	srdata_t *		mydata;
	unsigned int	thread_id = 0;
	if	( itsClient == NULL )	return;
	if	( itsSrData == NULL )	return;
	try {
		switch	( aCommand ) {
        	case	'L':	// Loading data
			itsSrData->ForceProgress();
            mydata = new srdata_t;
		    mydata->data 	= itsSrData;
		    mydata->client	= itsClient;
	    	if	( ::BeginThread( NULL, 0, __loadThread, (void *)mydata, 0, thread_id ) > 0 ) {
			   	Application->CreateForm( __classid(TProgressDialog), &ProgressDialog );
				ProgressDialog->SrData = itsSrData;
				ProgressDialog->ShowModal();
		        Application->OnIdle = NULL;
			    ProgressDialog->Release();
				ProgressDialog = NULL;
            }
            break;

            case	'S':	// Saving data
			itsSrData->ForceProgress();
            mydata = new srdata_t;
		    mydata->data 	= itsSrData;
		    mydata->client	= itsClient;
	    	if	( ::BeginThread( NULL, 0, __saveThread, (void *)mydata, 0, thread_id ) > 0 ) {
			   	Application->CreateForm( __classid(TProgressDialog), &ProgressDialog );
				ProgressDialog->SrData = itsSrData;
				ProgressDialog->ShowModal();
		        Application->OnIdle = NULL;
			    ProgressDialog->Release();
				ProgressDialog = NULL;
            }
            break;

			case	'r':	// Run the server
			itsSrData->NetStart( *itsClient, TCTLCSTR(ServersCheckListBox) );
			break;

			case	's':	// Stop the server
			itsSrData->NetStop( *itsClient, TCTLCSTR(ServersCheckListBox) );
			break;

			case	'1':	// Immediate start game server
			itsSrData->NetImmStart( *itsClient, TCTLCSTR(ServersCheckListBox) );
			break;

			case	'2':	// Immadiate stop game server
			itsSrData->NetImmStop( *itsClient, TCTLCSTR(ServersCheckListBox) );
			break;

			case	'3':	// Immediate restart game server
			itsSrData->NetImmStop( *itsClient, TCTLCSTR(ServersCheckListBox) );
			itsSrData->NetImmStart( *itsClient, TCTLCSTR(ServersCheckListBox) );
			break;
        }
        if	( itsSrData->Error().Error()[0] != 0 ) {
			throw  itsSrData->Error();
        }
    }
    catch ( CError e ) {
		if	( itsSrData )	delete itsSrData;
    	if	( itsClient )	delete itsClient;
	    itsSrData = NULL;
    	itsClient = NULL;
    	Application->MessageBox(	(char *)e.Error(),
        							"Connection Error",
                                    MB_OK | MB_ICONWARNING );
    }
    catch ( ... ) {
		if	( itsSrData )	delete itsSrData;
    	if	( itsClient )	delete itsClient;
	    itsSrData = NULL;
    	itsClient = NULL;
    	Application->MessageBox(	"Not connected properly",
        							"Connection Error",
                                    MB_OK | MB_ICONWARNING );
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateComboBox	( TComboBox * aC, const CFurserString_l & aL ) {
	int					ix	= 0;
    int					six	= aC->ItemIndex;
	CFurserString_lci	loop;

    for	( loop = aL.begin(); loop != aL.end(); loop++, ix++ ) {
		if	( ix < aC->Items->Count ) {
        	aC->Items->Strings[ix] = (*loop).c_str();
        }
        else {
        	aC->Items->Add( (*loop).c_str() );
        }
    }

	while	( ix < aC->Items->Count ) {
    	aC->Items->Delete( ix );
    }

    if		( ix == 0 ) {
    	aC->ItemIndex = -1;
    }
    else if	( six == -1 ) {
    	aC->ItemIndex = 0;
    }
    else if	( six >= aC->Items->Count ) {
    	aC->ItemIndex = aC->Items->Count - 1;
    }
    else {
    	aC->ItemIndex = six;
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateCheckListBox	( TCheckListBox * aC, const CFurserString_l & aL ) {
	int					ix	= 0;
    int					six	= aC->ItemIndex;
	CFurserString_lci	loop;

    for	( loop = aL.begin(); loop != aL.end(); loop++, ix++ ) {
		if	( ix < aC->Items->Count ) {
        	aC->Items->Strings[ix] = (*loop).c_str();
            aC->Checked[ix] = (*loop).Checked();
        }
        else {
        	aC->Items->Add( (*loop).c_str() );
            aC->Checked[ix] = (*loop).Checked();
        }
    }

	while	( ix < aC->Items->Count ) {
    	aC->Items->Delete( ix );
    }

    if		( ix == 0 ) {
    	aC->ItemIndex = -1;
    }
    else if	( six == -1 ) {
    	aC->ItemIndex = 0;
    }
    else if	( six >= aC->Items->Count ) {
    	aC->ItemIndex = aC->Items->Count - 1;
    }
    else {
    	aC->ItemIndex = six;
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SetControlEnable	( TBitBtn * aC, bool aF ) {
	if	( aC->Enabled != aF ) {
    	aC->Enabled = aF;
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SetControlEnable	( TEdit * aC, bool aF, bool aZ ) {
	if	( aC->Enabled != aF ) {
    	aC->Enabled = aF;
		if	( aZ && (!aF) ) {
        	aC->Text = "";
        }
		aC->Color = aF ? clWindow : clBtnFace;
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SetControlEnable	( TCheckListBox * aC, bool aF, bool aZ ) {
	if	( aC->Enabled != aF ) {
    	aC->Enabled = aF;
        if		( aZ && (!aF) ) {
        	aC->Items->Clear();
            aC->ItemIndex = -1;
        }
        else if	( ! aF ) {
            aC->ItemIndex = -1;
        }
		aC->Color = aF ? clWindow : clBtnFace;
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SetControlEnable	( TComboBox * aC, bool aF, bool aZ ) {
	if	( aC->Enabled != aF ) {
    	aC->Enabled = aF;
        if		( aZ && (!aF) ) {
        	aC->Items->Clear();
            aC->ItemIndex = -1;
        }
		aC->Color = aF ? clWindow : clBtnFace;
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SetControlEnable	( TListView * aC, bool aF, bool aZ ) {
	if	( aC->Enabled != aF ) {
    	aC->Enabled = aF;
        if		( aZ && (!aF) ) {
        	aC->Items->Clear();
            aC->Selected = NULL;
        }
        else if ( ! aF ) {
            aC->Selected = NULL;
        }
		aC->Color = aF ? clWindow : clBtnFace;
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SetControlEnable	( TCheckBox * aC, bool aF, bool aZ ) {
	if	( aC->Enabled != aF ) {
    	aC->Enabled = aF;
        if		( aZ && (!aF) ) {
        	aC->Checked = false;
        }
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SetControlEnable	( TDateTimePicker * aC, bool aF, bool aZ ) {
	if	( aC->Enabled != aF ) {
    	aC->Enabled = aF;
        if		( aZ && (!aF) ) {
			TDateTime	myDateTime;
			aC->DateTime = myDateTime.CurrentDateTime();
        }
		aC->Color = aF ? clWindow : clBtnFace;
    }
}

//---------------------------------------------------------------------------
