//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include	"TSelectWizardDialog.h"
#include	"CError.hxx"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TSelectWizardDialog *SelectWizardDialog = NULL;

//---------------------------------------------------------------------------
__fastcall TSelectWizardDialog::TSelectWizardDialog(TComponent* Owner) : TForm(Owner) {
	OkButton->Enabled= false;
}

//---------------------------------------------------------------------------
void __fastcall TSelectWizardDialog::Populate	( const char * aWizardDir ) {
	try	{
		itsWizardList.Load( Application->ExeName.c_str(), aWizardDir );
		CFurserString_lci	loop;
		itsUpdateFlag = 1;
        WizardListBox->Items->Clear();
		for	(	loop  = itsWizardList.CaptionList().begin();
				loop != itsWizardList.CaptionList().end();
                loop++ ) {
			WizardListBox->Items->Add( (*loop).c_str() );
        }
		itsUpdateFlag = 0;
    }
    catch ( CError e ) {
    	Application->MessageBox(	(char *)e.Error(),
        				   			"Unable to select wizard",
                                    MB_OK | MB_ICONWARNING );
		Application->OnIdle = MyIdleHandler;	// Delayed close
    }
    catch ( ... ) {
    	Application->MessageBox(	"Unknown error",
        				   			"Unable to select wizard",
                                    MB_OK | MB_ICONWARNING );
		Application->OnIdle = MyIdleHandler;	// Delayed close
    }
}

//---------------------------------------------------------------------------
void __fastcall TSelectWizardDialog::MyIdleHandler(TObject *Sender, bool &Done ) {
	Done = false;
	ModalResult = mrCancel;
}

//---------------------------------------------------------------------------
void __fastcall TSelectWizardDialog::WizardListBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( WizardListBox->ItemIndex < 0 ) {
    	OkButton->Enabled = false;
    	DescriptionMemo->Lines->Text = "";
        WizardFile = "";
    }
    else {
    	OkButton->Enabled = true;
		DescriptionMemo->Lines->Text = itsWizardList.Description( WizardListBox->ItemIndex );
        WizardFile = itsWizardList.WizardFile( WizardListBox->ItemIndex );
    }
}

//---------------------------------------------------------------------------
void __fastcall TSelectWizardDialog::OkButtonClick(TObject *Sender) {
	ModalResult = mrOk;
}

//---------------------------------------------------------------------------
void __fastcall TSelectWizardDialog::CancelButtonClick(TObject *Sender) {
	ModalResult = mrCancel;
}

//---------------------------------------------------------------------------
