//---------------------------------------------------------------------------
// FurserDaemon.cpp
// This source can be compiled in two modes:
// 1 As a daemon for Unix and like platforms (Linux)
// 2 As a service (installer) for Win platforms
//
// The service needs a directory to hold it's configuration files
// In Linux (Unix) this directory is  /etc/FurserDaemon
// In windows the directory is C:\WINNT\system32\drivers\etc\FurserDaemon
// Both versions can be overridden by an environment variable FURSERCONFDIR
//
// The FurserDaemon needs to create/remove files and directories in that
// directory.
//---------------------------------------------------------------------------
#include	"FurserDaemon.h"
#include	"CError.hxx"

//---------------------------------------------------------------------------
// More Borland peculiarities
//---------------------------------------------------------------------------
#ifdef	__TURBOC__
USELIB("..\WinLib\WinLib.lib");
USELIB("..\PlaLib\PlaLib.lib");
USEUNIT("src\CFurserClient.cpp");
USEUNIT("src\CFurserSrData.cpp");
USEUNIT("src\CFurserSrEvnt.cpp");
USEUNIT("src\CFurserSrGame.cpp");
USEUNIT("src\CFurserSrGrup.cpp");
USEUNIT("src\CFurserSrLevl.cpp");
USEUNIT("src\CFurserSrMuta.cpp");
USEUNIT("src\CFurserSrSetn.cpp");
USEUNIT("src\CFurserSrSrvr.cpp");
USEUNIT("src\CFurserSrUban.cpp");
USEUNIT("src\CFurserSrUser.cpp");
USEUNIT("src\CFurserString.cpp");
USEUNIT("src\CFurserSrMacr.cpp");
USEUNIT("src\CFurserWizQery.cpp");
USEUNIT("src\WinFurserDaemonConfig.cpp");
USEUNIT("src\FurserDaemonServer.cpp");
USEUNIT("src\FurserDaemonProcess.cpp");
USEUNIT("src\FurserClientThread.cpp");
USEUNIT("src\WinFurserDaemonService.cpp");
USEUNIT("src\FurserThread.cpp");
USEUNIT("src\FurserScheduleThread.cpp");
USEUNIT("src\FurserMutex.cpp");
USEUNIT("src\FurserLog.cpp");
USEUNIT("src\CFurserTask.cpp");
USEUNIT("src\FurserGameServer.cpp");
//---------------------------------------------------------------------------
#pragma argsused
#endif

//---------------------------------------------------------------------------
// public:	Common config structure
//---------------------------------------------------------------------------
FurserConfig_t		FurserConfig	= { { 0 } };
FurserStatus_t		FurserStatus	= { 0 };
CCpuMutex *			FurserMutex		= NULL;
CWinIniFile			FurserIni;
time_t				FurserIniTime	= 0;

//---------------------------------------------------------------------------
// local:	Log the startup
//---------------------------------------------------------------------------
static	void	__MyStartupLog	( int argc, char* argv[]) {
	int		arg;
	char	argstr	[512];
	::FurserLog( "STARTING", argc > 1 ? argv[0] : "FurserDaemon" );
	for	( arg = 0; arg < argc; arg++ ) {
       	::sprintf( argstr, "ARGV[%i]", arg );
		::FurserLog( argstr, argv[arg] );
	}
}

//---------------------------------------------------------------------------
// public: Entry of the program
//---------------------------------------------------------------------------
int main(int argc, char* argv[]) {
	int		result = 0;
	try	{

// If running under windows we make this as a service installer
#ifdef	WIN32
		//-----------------------------------------------------------------------
		// We can do the following under windows:
	    // FurserDaemon install 			- install the service
    	// FurserDaemon remove  			- remove the service
    	// FurserDaemon start				- start the service
    	// FurserDaemon stop				- stop the service
    	// FurserDaemon pause				- pause the service
	    // FurserDaemon run [confdir]		- run the program as non-service
        // FurserDaemon settings [confdir]	- Report current settings
		//-----------------------------------------------------------------------
		if		( argc == 1 ) {
        	if	( ::FurserDaemonTestWinService() ) {
			    ::FurserDaemonFindWinConfigDirectory( argv[0], NULL );
				::FurserDaemonReadWinFurserConfig( argv[0] );
                __MyStartupLog( argc, argv );
	    		::FurserDaemonRegisterDispatcher( );
            }
            else {
	            ::printf( "Usage: FurserDaemon install | remove | start | stop | pause | run [confdir] | settings [confdir]\n" );
                ::printf( "       install      Installs FurserDaemon as a service\n" );
                ::printf( "       start        Starts FurserDaemon service - install first\n" );
                ::printf( "       stop         Stops a running FurserDaemon service\n" );
                ::printf( "       pause        Pauses a running FurserDaemon service\n" );
                ::printf( "       run          Runs the FurserDaemon as a program (process)\n" );
                ::printf( "       settings     Displays current settings\n" );
                ::printf( "       confdir      Optional config directory for run and settings commands\n" );
                result = 1;
            }
	    }
    	else if	( !::stricmp( argv[1], "caninstall" ) ) {
			FurserConfig.hasconsole = true;
            if	( ::FurserDaemonTestWinInstance() ) {
            	throw	CError( "Can not install because DaemonService is already running" );
            }
        	if	( ::FurserDaemonTestWinService() ) {
            	throw	CError( "Can not install because DaemonService is already installed" );
            }
		}
    	else if	( !::stricmp( argv[1], "canremove" ) ) {
			FurserConfig.hasconsole = true;
        	if	( ! ::FurserDaemonTestWinService() ) {
            	throw	CError( "Can not remove because DaemonService was not installed" );
            }
		}
    	else if	( !::stricmp( argv[1], "install" ) ) {
            if	( ::FurserDaemonTestWinInstance() ) {
            	throw	CError( "Can not install because DaemonService is already running" );
            }
			FurserConfig.hasconsole = true;
		    ::FurserDaemonFindWinConfigDirectory( argv[0], NULL );
			::FurserDaemonReadWinFurserConfig( argv[0] );
           	__MyStartupLog( argc, argv );
	    	::FurserDaemonInstallWinService( argv[0] );
		}
    	else if	( !::stricmp( argv[1], "remove" ) ) {
			FurserConfig.hasconsole = true;
		    ::FurserDaemonFindWinConfigDirectory( argv[0], NULL );
			::FurserDaemonReadWinFurserConfig( argv[0] );
           	__MyStartupLog( argc, argv );
	    	::FurserDaemonRemoveWinService( argv[0] );
		}
    	else if	( !::stricmp( argv[1], "start" ) ) {
			FurserConfig.hasconsole = true;
		    ::FurserDaemonFindWinConfigDirectory( argv[0], NULL );
			::FurserDaemonReadWinFurserConfig( argv[0] );
           	__MyStartupLog( argc, argv );
			::FurserDaemonStartWinService();
		}
    	else if	( !::stricmp( argv[1], "stop" ) ) {
			FurserConfig.hasconsole = true;
		    ::FurserDaemonFindWinConfigDirectory( argv[0], NULL );
			::FurserDaemonReadWinFurserConfig( argv[0] );
           	__MyStartupLog( argc, argv );
			::FurserDaemonStopWinService();
		}
    	else if	( !::stricmp( argv[1], "pause" ) ) {
			FurserConfig.hasconsole = true;
		    ::FurserDaemonFindWinConfigDirectory( argv[0], NULL );
			::FurserDaemonReadWinFurserConfig( argv[0] );
           	__MyStartupLog( argc, argv );
			::FurserDaemonPauseWinService();
		}
    	else if	( !::stricmp( argv[1], "run" ) ) {
			FurserConfig.hasconsole = true;
        	if	( ::FurserDaemonTestWinService() ) {
            	throw	CError( "Can not run because a service exists" );
            }
            if	( ::FurserDaemonTestWinInstance() ) {
            	throw	CError( "Can not run because DaemonService is already running" );
            }
            else {
	            ::FurserDaemonCreateWinInstance();
                try {
				    ::FurserDaemonFindWinConfigDirectory( argv[0], argc > 2 ? argv[2] : NULL );
					::FurserDaemonReadWinFurserConfig( argv[0] );
					::FurserDaemonReportWinSettings( argv[0] );
        	    	__MyStartupLog( argc, argv );
					::FurserDaemonProcess( NULL );
		            ::FurserDaemonDeleteWinInstance();
                }
                catch ( ... ) {
		            ::FurserDaemonDeleteWinInstance();
                    throw;
                }
            }
		}
    	else if	( !::stricmp( argv[1], "settings" ) ) {
			FurserConfig.hasconsole = true;
		    ::FurserDaemonFindWinConfigDirectory( argv[0], argc > 2 ? argv[2] : NULL );
			::FurserDaemonReadWinFurserConfig( argv[0] );
            __MyStartupLog( argc, argv );
			::FurserDaemonReportWinSettings( argv[0] );
            result = 1;
		}
        else {
            ::printf( "Usage: FurserDaemon install | remove | start | stop | pause | run [confdir] | settings [confdir]\n" );
        	throw CError( argv[1], "Invalid argument" );
        }
	}
	catch	( CError e ) {
		if	( FurserConfig.hasconsole ) {
			::printf( "%s: ERROR: %s\n", argv[0], e.Error() );
        }
        result = 1;
    }
    catch	( ... ) {
		if	( FurserConfig.hasconsole ) {
			::printf( "%s: ERROR: Unknown error\n", argv[0] );
        }
        result = 1;
    }
#else
		//-----------------------------------------------------------------------
		// We can do the following under UNIX:
    	// FurserDaemon start		- start the service
	    // FurserDaemon run			- run the program as non-service
        // FurserDaemon settings	- Report current settings
		//-----------------------------------------------------------------------
	    ::FurserDaemonFindUnxConfigDirectory( argv[0] );
		::FurserDaemonReadUnxFurserConfig( argv[0] );
		::FurserLog( "Starting up", argv[0] );
		if		( argc == 1 ) {
	    	::printf( "Usage: FurserDaemon start | run | settings\n" );
	    }
    	else if	( ! ::my_stricmp( argv[1], "start" ) ) {
			::daemon( 1, 0 );
			::FurserDaemonProcess( NULL );
		}
    	else if	( ! ::my_stricmp( argv[1], "run" ) ) {
			FurserConfig.hasconsole = true;
			::FurserDaemonReportUnxSettings( argv[0] );
			::FurserDaemonProcess( NULL );
		}
    	else if	( ! ::my_stricmp( argv[1], "settings" ) ) {
			FurserConfig.hasconsole = true;
			::FurserDaemonReportUnxSettings( argv[0] );
		}
        else {
        	throw CError( argv[1], "Invalid argument" );
        }
	}
	catch	( CError e ) {
		::printf( "%s: ERROR: %s\n", argv[0], e.Error() );
    }
    catch	( ... ) {
		::printf( "%s: ERROR: Unknown error\n", argv[0] );
    }
#endif
	return result;
}

//---------------------------------------------------------------------------
// EOF: FurserDaemon.cpp
//---------------------------------------------------------------------------

