// --------------------------------------------------------------------
// CFurserSrEvnt.h
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserSrEvnt_h
#define CFurserSrEvnt_h

#include	"CFurserClient.h"
#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
// Event types
// --------------------------------------------------------------------
#define	EVENT_TYPE_ONCE		0
#define	EVENT_TYPE_HOURLY	1
#define	EVENT_TYPE_DAILY	2
#define	EVENT_TYPE_WEEKLY	3

// --------------------------------------------------------------------
// Event tasks
// --------------------------------------------------------------------
#define	EVENT_TASK_NOTHING	0
#define	EVENT_TASK_START	1
#define	EVENT_TASK_STOP		2
#define	EVENT_TASK_RESTART	3

// --------------------------------------------------------------------
class CFurserSrEvnt {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserSrEvnt		();
	~CFurserSrEvnt		();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserSrEvnt				( const CFurserSrEvnt & );
	CFurserSrEvnt & operator =	( const CFurserSrEvnt & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CFurserSrEvnt & ) const;
	bool operator != ( const CFurserSrEvnt & ) const;
	bool operator == ( const char * ) const;
	bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void			Load		( CFurserClient & );
	void			Load		( const CWinIniFile &, const char * );
	void			Save		( CFurserClient & );
	void			Save		( CWinIniFile &, const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	EventName	( void ) const;
	int				EventType	( void ) const;
	bool			Enabled		( void ) const;
	time_t			StartTime	( void ) const;
	int				StartTask	( void ) const;
	time_t			EndTime		( void ) const;
	int				EndTask		( void ) const;

	// ----------------------------------------------------------------
	void			EventName	( const char * );
	void			EventType	( int );
	void			Enabled		( bool );
	void			StartTime	( time_t );
	void			StartTask	( int );
	void			EndTime		( time_t );
	void			EndTask		( int );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Free		( void );
	void			Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *		itsEventName;
	int			itsEventType;
	bool		itsEnabled;
	time_t		itsStartTime;
	int			itsStartTask;
	time_t		itsEndTime;
	int			itsEndTask;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserSrEvnt>		CFurserSrEvnt_l;
typedef CFurserSrEvnt_l::iterator       CFurserSrEvnt_li;
typedef CFurserSrEvnt_l::const_iterator	CFurserSrEvnt_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserSrEvnt.h
// --------------------------------------------------------------------
