// --------------------------------------------------------------------
// CFurserSrMacr.h
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserSrMacr_h
#define CFurserSrMacr_h

#include	"CFurserClient.h"
#include	"CFurserWizQery.h"
#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
class CFurserSrMacr {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserSrMacr	();
	~CFurserSrMacr	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserSrMacr				( const CFurserSrMacr & );
	CFurserSrMacr & operator =	( const CFurserSrMacr & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CFurserSrMacr & ) const;
	bool operator != ( const CFurserSrMacr & ) const;
	bool operator == ( const char * ) const;
	bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void			Load		( CFurserClient & );
	void			Load		( const CWinIniFile &, const char * );
	void			Save		( CFurserClient & );
	void			Save		( CWinIniFile &, const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	MacroName	( void ) const;
	const char *	MacroValue	( void ) const;

	// ----------------------------------------------------------------
	void			MacroName	( const char * );
	void			MacroValue	( const char * );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Free		( void );
	void			Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *		itsMacroName;
	char *		itsMacroValue;

};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserSrMacr>		CFurserSrMacr_l;
typedef CFurserSrMacr_l::iterator       CFurserSrMacr_li;
typedef CFurserSrMacr_l::const_iterator	CFurserSrMacr_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserSrMacr.h
// --------------------------------------------------------------------
