// --------------------------------------------------------------------
// CFurserSrMuta.h
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserSrMuta_h
#define CFurserSrMuta_h

#include	"CFurserClient.h"
#include	"CFurserSrSetn.h"
#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
class CFurserSrMuta {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserSrMuta		();
	~CFurserSrMuta		();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserSrMuta				( const CFurserSrMuta & );
	CFurserSrMuta & operator =	( const CFurserSrMuta & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CFurserSrMuta & ) const;
	bool operator != ( const CFurserSrMuta & ) const;
	bool operator == ( const char * ) const;
	bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void			Load		( CFurserClient & );
	void			Load		( const CWinIniFile &, const char * );
	void			Save		( CFurserClient & );
	void			Save		( CWinIniFile &, const char * );

	// ----------------------------------------------------------------
	public:		// List manipulation
	// ----------------------------------------------------------------
	bool			HasSetting	( const char * ) const;
	CFurserSrSetn	GetSetting	( const char * ) const;
	void			SetSetting	( const char *, const CFurserSrSetn & );
	void			AddSetting	( const CFurserSrSetn & );
	void			DelSetting	( const CFurserSrSetn & );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	MutatorName	( void ) const;
    const char *	Description	( void ) const;
    const char *	Group		( void ) const;
    bool			LoadFlag	( void ) const;
	const CFurserSrSetn_l &	SettingList	( void ) const;

	// ----------------------------------------------------------------
	void			MutatorName	( const char * );
    void			Description	( const char * );
    void			Group		( const char * );
    void			LoadFlag	( bool );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Free		( void );
	void			Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *			itsMutatorName;
    char *			itsDescription;
    char *			itsGroup;
    bool			itsLoadFlag;
	CFurserSrSetn_l	itsSettingList;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserSrMuta>		CFurserSrMuta_l;
typedef CFurserSrMuta_l::iterator       CFurserSrMuta_li;
typedef CFurserSrMuta_l::const_iterator	CFurserSrMuta_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserSrMuta.h
// --------------------------------------------------------------------
