// --------------------------------------------------------------------
// CFurserSrUser.h
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserSrUser_h
#define CFurserSrUser_h

#include	"CFurserClient.h"
#include	"CFurserSrGrup.h"
#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
class CFurserSrUser {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserSrUser		();
	~CFurserSrUser		();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserSrUser				( const CFurserSrUser & );
	CFurserSrUser & operator =	( const CFurserSrUser & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CFurserSrUser & ) const;
	bool operator != ( const CFurserSrUser & ) const;
	bool operator == ( const char * ) const;
	bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Get user maximum security level (from groups)
	// ----------------------------------------------------------------
    int				SecurityLevel	( void ) const;

	// ----------------------------------------------------------------
	public:		// String that will be put into AdminUsers= entry
	// ----------------------------------------------------------------
    char *			IniString		( char *, size_t ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void			Load		( CFurserClient & );
	void			Load		( const CWinIniFile &, const char * );
	void			Save		( CFurserClient & );
	void			Save		( CWinIniFile &, const char * );

	// ----------------------------------------------------------------
	public:		// List manipulation
	// ----------------------------------------------------------------
	bool			HasGroup	( const char * ) const;
	CFurserSrGrup	GetGroup	( const char * ) const;
	void			SetGroup	( const char *, const CFurserSrGrup & );
	void			AddGroup	( const CFurserSrGrup & );
	void			DelGroup	( const CFurserSrGrup & );
    void			ClearGroups	( void );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *			UserName	( void ) const;
	const char *			UserPass	( void ) const;
	bool					Enabled		( void ) const;
    const char *			Comment		( void ) const;
	const CFurserSrGrup_l &	GroupList	( void ) const;

	// ----------------------------------------------------------------
	void			UserName	( const char * );
	void			UserPass	( const char * );
	void			Enabled		( bool );
    void			Comment		( const char * );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Free		( void );
	void			Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *			itsUserName;
	char *			itsUserPass;
	bool			itsEnabled;
	char *			itsComment;
	CFurserSrGrup_l	itsGroupList;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserSrUser>		CFurserSrUser_l;
typedef CFurserSrUser_l::iterator       CFurserSrUser_li;
typedef CFurserSrUser_l::const_iterator	CFurserSrUser_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserSrUser.h
// --------------------------------------------------------------------
