// --------------------------------------------------------------------
// CFurserString.h
// Whatis:  Furser Controller class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserString_h
#define CFurserString_h

#include	"Platform.hxx"

// --------------------------------------------------------------------
class CFurserString {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserString		();
	CFurserString		( const char * );
	~CFurserString		();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserString				( const CFurserString & );
	CFurserString & operator =	( const CFurserString & );
	CFurserString & operator =	( const char * );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CFurserString & ) const;
	bool operator != ( const CFurserString & ) const;
	bool operator == ( const char * ) const;
	bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	c_str	( void ) const;
	bool			Checked	( void ) const;
    void			Checked	( bool );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Free	( void );
	void			Cleanup	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *			itsString;
	bool			itsChecked;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserString>		CFurserString_l;
typedef CFurserString_l::iterator       CFurserString_li;
typedef CFurserString_l::const_iterator	CFurserString_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserString.h
// --------------------------------------------------------------------
