// --------------------------------------------------------------------
// CFurserTask.h
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserTask_h
#define CFurserTask_h

#include	"CFurserSrSrvr.h"

// --------------------------------------------------------------------
class CFurserTask {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserTask		();
	~CFurserTask	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserTask					( const CFurserTask & );
	CFurserTask & operator =	( const CFurserTask & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CFurserTask & ) const;
	bool operator != ( const CFurserTask & ) const;


	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *			Server		( void ) const;
    bool					Running		( void ) const;
    const char *			UccBinary	( void ) const;
    const char *			SysFolder	( void ) const;
    const char *			CmdLine		( void ) const;

#ifdef	WIN32
    const PROCESS_INFORMATION &	ProcessInfo	( void ) const;
#else
#endif

	// ----------------------------------------------------------------
	void					Server		( const char * );
    void					Running		( bool );
    void					UccBinary	( const char * );
    void					SysFolder	( const char * );
    void					CmdLine		( const char * );
#ifdef	WIN32
    void					ProcessInfo	( const PROCESS_INFORMATION & );
#else
#endif

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void					Free		( void );
	void					Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *		itsServer;
    bool		itsRunning;
	char *		itsUccBinary;
    char *		itsSysFolder;
    char *		itsCmdLine;

#ifdef	WIN32
	// ----------------------------------------------------------------
	private:	// Windows process stuff
	// ----------------------------------------------------------------
	PROCESS_INFORMATION		itsProcessInfo;

#else
	// ----------------------------------------------------------------
	private:	// Unix process stuff
	// ----------------------------------------------------------------

#endif
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserTask>		CFurserTask_l;
typedef CFurserTask_l::iterator			CFurserTask_li;
typedef CFurserTask_l::const_iterator	CFurserTask_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserTask.h
// --------------------------------------------------------------------
