// --------------------------------------------------------------------
// FurserDaemon.h
// Whatis:  FurserDaemon service/daemon definitions
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef FurserDaemon_h
#define FurserDaemon_h

// --------------------------------------------------------------------
// Borland peculiarities
// --------------------------------------------------------------------
#ifdef	__TURBOC__
#pragma hdrstop
#include <condefs.h>
#endif

// --------------------------------------------------------------------
// Some includes
// --------------------------------------------------------------------
#include	"CFurserSrData.h"
#include	"CFurserTask.h"
#include	"CCpuMutex.hxx"

// --------------------------------------------------------------------
// Configuration - common for all platforms
// --------------------------------------------------------------------
typedef	struct	FurserConfig_s {
	char			configdir	[512];		// Config file directory
	char			configfile	[512];		// Main config file
	char			serverfile	[512];		// Server data file
    char			logfile		[512];		// Log file
    bool			hasconsole;				// True if we can output to console
	char			serverpass	[512];		// Password for the server
	unsigned short	listenport;				// Listen port for the server
	int				maxclients;				// Max number of clients
    long			maxlogfile;				// Max size of the logfile

}	FurserConfig_t;


// --------------------------------------------------------------------
// Status - common for all platforms
// --------------------------------------------------------------------
typedef	struct	FurserStatus_s {
	const char *	error;					// Error explanation
    bool			abort;					// Abort request
    bool			pause;					// Pause state
    int				clients;				// Number of clients
    int				running;				// Number of thread running
}	FurserStatus_t;

extern	"C" {
// --------------------------------------------------------------------
// Extern function declarations for WIN platform
// --------------------------------------------------------------------
#ifdef	WIN32
extern	void	FurserDaemonFindWinConfigDirectory( const char *, const char * );
extern	void	FurserDaemonReadWinFurserConfig( const char * );
extern	void	FurserDaemonReportWinSettings( const char * );
extern	void	FurserDaemonInstallWinService( const char * );
extern	void	FurserDaemonRemoveWinService( const char * );
extern	void	FurserDaemonStartWinService( void );
extern	void	FurserDaemonStopWinService( void );
extern	void	FurserDaemonPauseWinService( void );
extern	void	FurserDaemonRegisterDispatcher( void );
extern	bool	FurserDaemonTestWinService( void );
extern	bool	FurserDaemonTestWinInstance( void );
extern	void	FurserDaemonCreateWinInstance( void );
extern	void	FurserDaemonDeleteWinInstance( void );

// --------------------------------------------------------------------
// Extern function declarations for UNIX platform
// --------------------------------------------------------------------
#else
extern	void	FurserDaemonFindUnxConfigDirectory( const char * );
extern	void	FurserDaemonReadUnxFurserConfig( const char * );
extern	void	FurserDaemonReportUnxSettings( const char * );

// --------------------------------------------------------------------
// Common extern function declarations
// --------------------------------------------------------------------
#endif
extern	void	FurserServerSendSettings( CFurserClient & );
extern	void	FurserServerRecvSettings( CFurserClient & );
extern	void	FurserServerStartScheduler( CFurserClient & );
extern	void	FurserServerStopScheduler( CFurserClient & );
extern	void	FurserServerImmediateStart( CFurserClient & );
extern	void	FurserServerImmediateStop( CFurserClient & );
extern	void	FurserServerSendLogFile( CFurserClient & );
extern	void	FurserStartThread( void (*)( void *), void * );
extern	void	FurserDaemonProcess( void * );
extern	void	FurserClientThread( void * );
extern	void	FurserScheduleThread( void * );
extern	void	FurserStartGameServer( CFurserTask &, const CFurserSrSrvr & );
extern	void	FurserStopGameServer( CFurserTask & );
extern	void	FurserCheckRunningState( CFurserTask & );
extern	void	FurserScanRunningServers( CFurserSrData & );
extern	void	FurserLoadServerData( void );
extern	void	FurserLock( void );
extern	void	FurserUnlock( void );
extern	void	FurserLog( const char *, const char * );

// --------------------------------------------------------------------
// Common extern data declarations
// --------------------------------------------------------------------
extern	FurserConfig_t	FurserConfig;
extern	FurserStatus_t	FurserStatus;
extern	CCpuMutex *		FurserMutex;
extern	CWinIniFile		FurserIni;
extern	time_t			FurserIniTime;
}

#endif
// --------------------------------------------------------------------
// EOF:	FurserDaemon.h
// --------------------------------------------------------------------
